/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.request.zzm;
import com.google.android.gms.internal.zzrp;
import java.util.concurrent.TimeUnit;

public class DataUpdateRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final long zzXy;
    private final long zzaCJ;
    private final DataSet zzaEa;
    private final zzrp zzaHq;
    public static final Parcelable.Creator<DataUpdateRequest> CREATOR = new zzm();

    DataUpdateRequest(int n, long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.mVersionCode = n;
        this.zzXy = l;
        this.zzaCJ = l2;
        this.zzaEa = dataSet;
        this.zzaHq = zzrp.zza.zzbZ(iBinder);
    }

    private DataUpdateRequest(Builder builder) {
        this(builder.zzXy, builder.zzaCJ, builder.zzaEa, null);
    }

    public DataUpdateRequest(long l, long l2, DataSet dataSet, IBinder iBinder) {
        this.mVersionCode = 1;
        this.zzXy = l;
        this.zzaCJ = l2;
        this.zzaEa = dataSet;
        this.zzaHq = zzrp.zza.zzbZ(iBinder);
    }

    public DataUpdateRequest(DataUpdateRequest dataUpdateRequest, IBinder iBinder) {
        this(dataUpdateRequest.zzoq(), dataUpdateRequest.zzxn(), dataUpdateRequest.getDataSet(), iBinder);
    }

    public long zzoq() {
        return this.zzXy;
    }

    public long zzxn() {
        return this.zzaCJ;
    }

    public DataSet getDataSet() {
        return this.zzaEa;
    }

    public IBinder getCallbackBinder() {
        return this.zzaHq == null ? null : this.zzaHq.asBinder();
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzXy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaCJ, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataUpdateRequest && this.zzb((DataUpdateRequest)((Object)object));
    }

    private boolean zzb(DataUpdateRequest dataUpdateRequest) {
        return this.zzXy == dataUpdateRequest.zzXy && this.zzaCJ == dataUpdateRequest.zzaCJ && zzz.equal((Object)((Object)this.zzaEa), (Object)((Object)dataUpdateRequest.zzaEa));
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzXy, this.zzaCJ, this.zzaEa});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzXy).zzg("endTimeMillis", (Object)this.zzaCJ).zzg("dataSet", (Object)this.zzaEa).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }

    public static class Builder {
        private long zzXy;
        private long zzaCJ;
        private DataSet zzaEa;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzaa.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzaa.zzb((l2 >= l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzXy = timeUnit.toMillis(l);
            this.zzaCJ = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setDataSet(DataSet dataSet) {
            zzaa.zzb((Object)((Object)dataSet), (Object)"Must set the data set");
            this.zzaEa = dataSet;
            return this;
        }

        public DataUpdateRequest build() {
            this.zzyf();
            return new DataUpdateRequest(this);
        }

        private void zzyf() {
            zzaa.zza((long)this.zzXy, (Object)"Must set a non-zero value for startTimeMillis/startTime");
            zzaa.zza((long)this.zzaCJ, (Object)"Must set a non-zero value for endTimeMillis/endTime");
            zzaa.zzb((Object)((Object)this.zzaEa), (Object)"Must set the data set");
            for (DataPoint dataPoint : this.zzaEa.getDataPoints()) {
                long l;
                long l2 = dataPoint.getStartTime(TimeUnit.MILLISECONDS);
                boolean bl = l2 > (l = dataPoint.getEndTime(TimeUnit.MILLISECONDS)) || l2 != 0L && l2 < this.zzXy || l2 != 0L && l2 > this.zzaCJ || l > this.zzaCJ || l < this.zzXy;
                zzaa.zza((!bl ? 1 : 0) != 0, (String)"Data Point's startTimeMillis %d, endTimeMillis %d should lie between timeRange provided in the request. StartTimeMillis %d, EndTimeMillis: %d", (Object[])new Object[]{l2, l, this.zzXy, this.zzaCJ});
            }
        }
    }
}

