/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzaCI;
    private final DataType zzaCH;
    private final long zzaEb;
    private final long zzaHY;
    private final long zzaHX;
    private final int zzaEc;
    private final LocationRequest zzaIc;
    private final long zzaId;

    private SensorRequest(Builder builder) {
        this.zzaCI = builder.zzaCI;
        this.zzaCH = builder.zzaCH;
        this.zzaEb = builder.zzaEb;
        this.zzaHY = builder.zzaHY;
        this.zzaHX = builder.zzaHX;
        this.zzaEc = builder.zzaEc;
        this.zzaIc = null;
        this.zzaId = builder.zzaId;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.zzaIc = locationRequest;
        this.zzaEb = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzaHY = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzaHX = this.zzaEb;
        this.zzaCH = dataSource.getDataType();
        this.zzaEc = SensorRequest.zza(locationRequest);
        this.zzaCI = dataSource;
        long l = locationRequest.getExpirationTime();
        this.zzaId = l == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int zza(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.zzaCI;
    }

    public DataType getDataType() {
        return this.zzaCH;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaEb, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaHY, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaHX, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzaEc;
    }

    public long zzym() {
        return this.zzaId;
    }

    public String toString() {
        return zzz.zzy((Object)this).zzg("dataSource", (Object)this.zzaCI).zzg("dataType", (Object)this.zzaCH).zzg("samplingRateMicros", (Object)this.zzaEb).zzg("deliveryLatencyMicros", (Object)this.zzaHX).zzg("timeOutMicros", (Object)this.zzaId).toString();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SensorRequest && this.zza((SensorRequest)object);
    }

    private boolean zza(SensorRequest sensorRequest) {
        return zzz.equal((Object)((Object)this.zzaCI), (Object)((Object)sensorRequest.zzaCI)) && zzz.equal((Object)((Object)this.zzaCH), (Object)((Object)sensorRequest.zzaCH)) && this.zzaEb == sensorRequest.zzaEb && this.zzaHY == sensorRequest.zzaHY && this.zzaHX == sensorRequest.zzaHX && this.zzaEc == sensorRequest.zzaEc && zzz.equal((Object)this.zzaIc, (Object)sensorRequest.zzaIc) && this.zzaId == sensorRequest.zzaId;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaCI, this.zzaCH, this.zzaEb, this.zzaHY, this.zzaHX, this.zzaEc, this.zzaIc, this.zzaId});
    }

    public static int zzfR(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return n;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource zzaCI;
        private DataType zzaCH;
        private long zzaEb = -1L;
        private long zzaHY = 0L;
        private long zzaHX = 0L;
        private boolean zzaIe = false;
        private int zzaEc = 2;
        private long zzaId = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzaCI = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzaCH = dataType;
            return this;
        }

        public Builder setSamplingRate(long l, TimeUnit timeUnit) {
            zzaa.zzb((l >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzaEb = timeUnit.toMicros(l);
            if (!this.zzaIe) {
                this.zzaHY = this.zzaEb / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int n, TimeUnit timeUnit) {
            zzaa.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzaIe = true;
            this.zzaHY = timeUnit.toMicros(n);
            return this;
        }

        public Builder setMaxDeliveryLatency(int n, TimeUnit timeUnit) {
            zzaa.zzb((n >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzaHX = timeUnit.toMicros(n);
            return this;
        }

        public Builder setAccuracyMode(int n) {
            this.zzaEc = SensorRequest.zzfR(n);
            return this;
        }

        public Builder setTimeout(long l, TimeUnit timeUnit) {
            zzaa.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{l});
            zzaa.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzaId = timeUnit.toMicros(l);
            return this;
        }

        public SensorRequest build() {
            zzaa.zza((this.zzaCI != null || this.zzaCH != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzaa.zza((this.zzaCH == null || this.zzaCI == null || this.zzaCH.equals((Object)this.zzaCI.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

