/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzy;
import com.google.android.gms.internal.zzrn;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final String zzaIh;
    private final String zzPE;
    private final long zzXy;
    private final long zzaCJ;
    private final List<DataType> zzaCS;
    private final List<DataSource> zzaHs;
    private boolean zzaIi;
    private final boolean zzaHD;
    private final List<String> zzaIj;
    private final zzrn zzaIk;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzy();

    SessionReadRequest(int n, String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, IBinder iBinder) {
        this.mVersionCode = n;
        this.zzaIh = string;
        this.zzPE = string2;
        this.zzXy = l;
        this.zzaCJ = l2;
        this.zzaCS = list;
        this.zzaHs = list2;
        this.zzaIi = bl;
        this.zzaHD = bl2;
        this.zzaIj = list3;
        this.zzaIk = zzrn.zza.zzbX(iBinder);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzaIh, builder.zzPE, builder.zzXy, builder.zzaCJ, builder.zzaCS, builder.zzaHs, builder.zzaIi, builder.zzaHD, builder.zzaIj, null);
    }

    public SessionReadRequest(SessionReadRequest sessionReadRequest, zzrn zzrn2) {
        this(sessionReadRequest.zzaIh, sessionReadRequest.zzPE, sessionReadRequest.zzXy, sessionReadRequest.zzaCJ, sessionReadRequest.zzaCS, sessionReadRequest.zzaHs, sessionReadRequest.zzaIi, sessionReadRequest.zzaHD, sessionReadRequest.zzaIj, zzrn2);
    }

    public SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, zzrn zzrn2) {
        this(5, string, string2, l, l2, list, list2, bl, bl2, list3, zzrn2 == null ? null : zzrn2.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzXy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaCJ, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzaIh;
    }

    public String getSessionId() {
        return this.zzPE;
    }

    public List<DataType> getDataTypes() {
        return this.zzaCS;
    }

    public List<DataSource> getDataSources() {
        return this.zzaHs;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzaIi;
    }

    public List<String> getExcludedPackages() {
        return this.zzaIj;
    }

    public boolean zzxZ() {
        return this.zzaHD;
    }

    public long zzxn() {
        return this.zzaCJ;
    }

    public long zzoq() {
        return this.zzXy;
    }

    public boolean zzyo() {
        return this.zzaIi;
    }

    public IBinder getCallbackBinder() {
        return this.zzaIk == null ? null : this.zzaIk.asBinder();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SessionReadRequest && this.zzb((SessionReadRequest)((Object)object));
    }

    private boolean zzb(SessionReadRequest sessionReadRequest) {
        return zzz.equal((Object)this.zzaIh, (Object)sessionReadRequest.zzaIh) && this.zzPE.equals(sessionReadRequest.zzPE) && this.zzXy == sessionReadRequest.zzXy && this.zzaCJ == sessionReadRequest.zzaCJ && zzz.equal(this.zzaCS, sessionReadRequest.zzaCS) && zzz.equal(this.zzaHs, sessionReadRequest.zzaHs) && this.zzaIi == sessionReadRequest.zzaIi && this.zzaIj.equals(sessionReadRequest.zzaIj) && this.zzaHD == sessionReadRequest.zzaHD;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaIh, this.zzPE, this.zzXy, this.zzaCJ});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("sessionName", (Object)this.zzaIh).zzg("sessionId", (Object)this.zzPE).zzg("startTimeMillis", (Object)this.zzXy).zzg("endTimeMillis", (Object)this.zzaCJ).zzg("dataTypes", this.zzaCS).zzg("dataSources", this.zzaHs).zzg("sessionsFromAllApps", (Object)this.zzaIi).zzg("excludedPackages", this.zzaIj).zzg("useServer", (Object)this.zzaHD).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzy.zza(this, parcel, n);
    }

    public static class Builder {
        private String zzaIh;
        private String zzPE;
        private long zzXy = 0L;
        private long zzaCJ = 0L;
        private List<DataType> zzaCS = new ArrayList<DataType>();
        private List<DataSource> zzaHs = new ArrayList<DataSource>();
        private boolean zzaIi = false;
        private boolean zzaHD = false;
        private List<String> zzaIj = new ArrayList<String>();

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzXy = timeUnit.toMillis(l);
            this.zzaCJ = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setSessionName(String string) {
            this.zzaIh = string;
            return this;
        }

        public Builder setSessionId(String string) {
            this.zzPE = string;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzaa.zzb((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            if (!this.zzaHs.contains((Object)dataSource)) {
                this.zzaHs.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzaa.zzb((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzaCS.contains((Object)dataType)) {
                this.zzaCS.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzaIi = true;
            return this;
        }

        public Builder excludePackage(String string) {
            zzaa.zzb((Object)string, (Object)"Attempting to use a null package name");
            if (!this.zzaIj.contains(string)) {
                this.zzaIj.add(string);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaHD = true;
            return this;
        }

        public SessionReadRequest build() {
            zzaa.zzb((this.zzXy > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzXy});
            zzaa.zzb((this.zzaCJ > 0L && this.zzaCJ > this.zzXy ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzaCJ});
            return new SessionReadRequest(this);
        }
    }
}

