/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataSourcesResult
extends AbstractSafeParcelable
implements Result {
    private final int mVersionCode;
    private final List<DataSource> zzaHs;
    private final Status zzaaO;
    public static final Parcelable.Creator<DataSourcesResult> CREATOR = new zze();

    DataSourcesResult(int n, List<DataSource> list, Status status) {
        this.mVersionCode = n;
        this.zzaHs = Collections.unmodifiableList(list);
        this.zzaaO = status;
    }

    public DataSourcesResult(List<DataSource> list, Status status) {
        this.mVersionCode = 3;
        this.zzaHs = Collections.unmodifiableList(list);
        this.zzaaO = status;
    }

    public static DataSourcesResult zzV(Status status) {
        return new DataSourcesResult(Collections.emptyList(), status);
    }

    public List<DataSource> getDataSources() {
        return this.zzaHs;
    }

    public List<DataSource> getDataSources(DataType dataType) {
        ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
        for (DataSource dataSource : this.zzaHs) {
            if (!dataSource.getDataType().equals((Object)dataType)) continue;
            arrayList.add(dataSource);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzaaO;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataSourcesResult && this.zzb((DataSourcesResult)((Object)object));
    }

    private boolean zzb(DataSourcesResult dataSourcesResult) {
        return this.zzaaO.equals((Object)dataSourcesResult.zzaaO) && zzz.equal(this.zzaHs, dataSourcesResult.zzaHs);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaaO, this.zzaHs});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("status", (Object)this.zzaaO).zzg("dataSets", this.zzaHs).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }
}

