/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.zzh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
extends AbstractSafeParcelable
implements Result {
    private final int mVersionCode;
    private final List<Subscription> zzaIz;
    private final Status zzaaO;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new zzh();

    ListSubscriptionsResult(int n, List<Subscription> list, Status status) {
        this.mVersionCode = n;
        this.zzaIz = list;
        this.zzaaO = status;
    }

    public ListSubscriptionsResult(List<Subscription> list, Status status) {
        this.mVersionCode = 3;
        this.zzaIz = Collections.unmodifiableList(list);
        this.zzaaO = (Status)zzaa.zzb((Object)status, (Object)"status");
    }

    public static ListSubscriptionsResult zzX(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.zzaIz;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : this.zzaIz) {
            if (!dataType.equals((Object)subscription.zzxI())) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzaaO;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ListSubscriptionsResult && this.zzb((ListSubscriptionsResult)((Object)object));
    }

    private boolean zzb(ListSubscriptionsResult listSubscriptionsResult) {
        return this.zzaaO.equals((Object)listSubscriptionsResult.zzaaO) && zzz.equal(this.zzaIz, listSubscriptionsResult.zzaIz);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaaO, this.zzaIz});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("status", (Object)this.zzaaO).zzg("subscriptions", this.zzaIz).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }
}

