/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomConfigImpl;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class RoomConfig {
    protected RoomConfig() {
    }

    public abstract RoomUpdateListener getRoomUpdateListener();

    public abstract String getInvitationId();

    public abstract RoomStatusUpdateListener getRoomStatusUpdateListener();

    public abstract RealTimeMessageReceivedListener getMessageReceivedListener();

    public abstract int getVariant();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder(RoomUpdateListener roomUpdateListener) {
        return new Builder(roomUpdateListener);
    }

    public static Bundle createAutoMatchCriteria(int n, int n2, long l) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", n);
        bundle.putInt("max_automatch_players", n2);
        bundle.putLong("exclusive_bit_mask", l);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener zzbdP;
        RoomStatusUpdateListener zzbdQ;
        RealTimeMessageReceivedListener zzbdR;
        String zzbdS = null;
        int zzbdE = -1;
        ArrayList<String> zzbdT = new ArrayList();
        Bundle zzbdU;

        private Builder(RoomUpdateListener roomUpdateListener) {
            this.zzbdP = (RoomUpdateListener)zzac.zzb((Object)roomUpdateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String string) {
            zzac.zzw((Object)string);
            this.zzbdS = string;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener roomStatusUpdateListener) {
            this.zzbdQ = roomStatusUpdateListener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.zzbdR = realTimeMessageReceivedListener;
            return this;
        }

        public Builder addPlayersToInvite(String ... stringArray) {
            zzac.zzw((Object)stringArray);
            this.zzbdT.addAll(Arrays.asList(stringArray));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> arrayList) {
            zzac.zzw(arrayList);
            this.zzbdT.addAll(arrayList);
            return this;
        }

        public Builder setVariant(int n) {
            zzac.zzb((n == -1 || n > 0 ? 1 : 0) != 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.zzbdE = n;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle bundle) {
            this.zzbdU = bundle;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfigImpl(this);
        }
    }
}

