/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;

public final class MilestoneEntity
extends GamesAbstractSafeParcelable
implements Milestone {
    public static final Parcelable.Creator<MilestoneEntity> CREATOR = new MilestoneEntityCreator();
    private final int mVersionCode;
    private final String zzbaa;
    private final long zzbeo;
    private final long zzbep;
    private final byte[] zzbeq;
    private final int mState;
    private final String zzaYL;

    public MilestoneEntity(Milestone milestone) {
        this.mVersionCode = 4;
        this.zzbaa = milestone.getMilestoneId();
        this.zzbeo = milestone.getCurrentProgress();
        this.zzbep = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.zzaYL = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.zzbeq = null;
        } else {
            this.zzbeq = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzbeq, 0, byArray.length);
        }
    }

    MilestoneEntity(int n, String string, long l, long l2, byte[] byArray, int n2, String string2) {
        this.mVersionCode = n;
        this.zzbaa = string;
        this.zzbeo = l;
        this.zzbep = l2;
        this.zzbeq = byArray;
        this.mState = n2;
        this.zzaYL = string2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.zzaYL;
    }

    @Override
    public String getMilestoneId() {
        return this.zzbaa;
    }

    @Override
    public long getCurrentProgress() {
        return this.zzbeo;
    }

    @Override
    public long getTargetProgress() {
        return this.zzbep;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.zzbeq;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    public Milestone freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    static int zza(Milestone milestone) {
        return zzaa.hashCode((Object[])new Object[]{milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId()});
    }

    public boolean equals(Object object) {
        return MilestoneEntity.zza(this, object);
    }

    static boolean zza(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return zzaa.equal((Object)milestone2.getMilestoneId(), (Object)milestone.getMilestoneId()) && zzaa.equal((Object)milestone2.getCurrentProgress(), (Object)milestone.getCurrentProgress()) && zzaa.equal((Object)milestone2.getTargetProgress(), (Object)milestone.getTargetProgress()) && zzaa.equal((Object)milestone2.getState(), (Object)milestone.getState()) && zzaa.equal((Object)milestone2.getEventId(), (Object)milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    static String zzb(Milestone milestone) {
        return zzaa.zzv((Object)milestone).zzg("MilestoneId", (Object)milestone.getMilestoneId()).zzg("CurrentProgress", (Object)milestone.getCurrentProgress()).zzg("TargetProgress", (Object)milestone.getTargetProgress()).zzg("State", (Object)milestone.getState()).zzg("CompletionRewardData", (Object)milestone.getCompletionRewardData()).zzg("EventId", (Object)milestone.getEventId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        MilestoneEntityCreator.zza(this, parcel, n);
    }
}

