/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;

public final class GameRef
extends zzc
implements Game {
    public GameRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
    }

    @Override
    public String getApplicationId() {
        return this.getString("external_game_id");
    }

    @Override
    public String getDisplayName() {
        return this.getString("display_name");
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        this.zza("display_name", charArrayBuffer);
    }

    @Override
    public String getPrimaryCategory() {
        return this.getString("primary_category");
    }

    @Override
    public String getSecondaryCategory() {
        return this.getString("secondary_category");
    }

    @Override
    public String getDescription() {
        return this.getString("game_description");
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        this.zza("game_description", charArrayBuffer);
    }

    @Override
    public String getDeveloperName() {
        return this.getString("developer_name");
    }

    @Override
    public void getDeveloperName(CharArrayBuffer charArrayBuffer) {
        this.zza("developer_name", charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzdk("game_icon_image_uri");
    }

    @Override
    public String getIconImageUrl() {
        return this.getString("game_icon_image_url");
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzdk("game_hi_res_image_uri");
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString("game_hi_res_image_url");
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzdk("featured_image_uri");
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.getString("featured_image_url");
    }

    @Override
    public boolean zzCV() {
        return this.getBoolean("play_enabled_game");
    }

    @Override
    public boolean isMuted() {
        return this.getBoolean("muted");
    }

    @Override
    public boolean zzCW() {
        return this.getBoolean("identity_sharing_confirmed");
    }

    @Override
    public boolean zzCX() {
        return this.getInteger("installed") > 0;
    }

    @Override
    public String zzCY() {
        return this.getString("package_name");
    }

    @Override
    public int getAchievementTotalCount() {
        return this.getInteger("achievement_total_count");
    }

    @Override
    public int getLeaderboardCount() {
        return this.getInteger("leaderboard_count");
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.getInteger("real_time_support") > 0;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.getInteger("turn_based_support") > 0;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.getInteger("snapshots_enabled") > 0;
    }

    @Override
    public String getThemeColor() {
        return this.getString("theme_color");
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.getInteger("gamepad_support") > 0;
    }

    public Game freeze() {
        return new GameEntity(this);
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    public boolean equals(Object object) {
        return GameEntity.zza(this, object);
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameEntity gameEntity = (GameEntity)((Game)this.freeze());
        gameEntity.writeToParcel(parcel, n);
    }
}

