/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
extends GamesAbstractSafeParcelable
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzbbQ;
    private final String zzber;
    private final long zzbes;
    private final Uri zzbet;
    private final String zzbeu;
    private final String zzacd;
    private final long zzbev;
    private final long zzaYl;
    private final Uri mIconUri;
    private final String zzbew;
    private final String mName;
    private final long zzbex;
    private final long zzbey;
    private final int mState;
    private final int zzanR;
    private final ArrayList<MilestoneEntity> zzbez;

    public QuestEntity(Quest quest) {
        this.mVersionCode = 2;
        this.zzbbQ = new GameEntity(quest.getGame());
        this.zzber = quest.getQuestId();
        this.zzbes = quest.getAcceptedTimestamp();
        this.zzacd = quest.getDescription();
        this.zzbet = quest.getBannerImageUri();
        this.zzbeu = quest.getBannerImageUrl();
        this.zzbev = quest.getEndTimestamp();
        this.mIconUri = quest.getIconImageUri();
        this.zzbew = quest.getIconImageUrl();
        this.zzaYl = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzbex = quest.zzFJ();
        this.zzbey = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzanR = quest.getType();
        List<Milestone> list = quest.zzFI();
        int n = list.size();
        this.zzbez = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzbez.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int n, GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n2, int n3, ArrayList<MilestoneEntity> arrayList) {
        this.mVersionCode = n;
        this.zzbbQ = gameEntity;
        this.zzber = string;
        this.zzbes = l;
        this.zzbet = uri;
        this.zzbeu = string2;
        this.zzacd = string3;
        this.zzbev = l2;
        this.zzaYl = l3;
        this.mIconUri = uri2;
        this.zzbew = string4;
        this.mName = string5;
        this.zzbex = l4;
        this.zzbey = l5;
        this.mState = n2;
        this.zzanR = n3;
        this.zzbez = arrayList;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getQuestId() {
        return this.zzber;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzacd;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzacd, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.mIconUri;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzbew;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzbet;
    }

    @Override
    public String getBannerImageUrl() {
        return this.zzbeu;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzFI().get(0);
    }

    @Override
    public List<Milestone> zzFI() {
        return new ArrayList<Milestone>(this.zzbez);
    }

    @Override
    public Game getGame() {
        return this.zzbbQ;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.zzanR;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.zzbes;
    }

    @Override
    public long getEndTimestamp() {
        return this.zzbev;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaYl;
    }

    @Override
    public long zzFJ() {
        return this.zzbex;
    }

    @Override
    public long getStartTimestamp() {
        return this.zzbey;
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzbex <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzaa.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzFI(), quest.getName(), quest.zzFJ(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzaa.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzaa.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzaa.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzaa.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzaa.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzaa.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzaa.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzaa.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzaa.equal(quest2.zzFI(), quest.zzFI()) && zzaa.equal((Object)quest2.getName(), (Object)quest.getName()) && zzaa.equal((Object)quest2.zzFJ(), (Object)quest.zzFJ()) && zzaa.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzaa.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzaa.zzv((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzFI()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzFJ()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        QuestEntityCreator.zza(this, parcel, n);
    }
}

