/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;

public final class EventEntity
extends GamesAbstractSafeParcelable
implements Event {
    public static final Parcelable.Creator<EventEntity> CREATOR = new EventEntityCreator();
    private final String zzaZp;
    private final String mName;
    private final String zzade;
    private final Uri zzaXy;
    private final String zzaXJ;
    private final PlayerEntity zzaYM;
    private final long zzadd;
    private final String zzaZq;
    private final boolean zzww;

    public EventEntity(Event event) {
        this.zzaZp = event.getEventId();
        this.mName = event.getName();
        this.zzade = event.getDescription();
        this.zzaXy = event.getIconImageUri();
        this.zzaXJ = event.getIconImageUrl();
        this.zzaYM = (PlayerEntity)event.getPlayer().freeze();
        this.zzadd = event.getValue();
        this.zzaZq = event.getFormattedValue();
        this.zzww = event.isVisible();
    }

    EventEntity(String string, String string2, String string3, Uri uri, String string4, Player player, long l, String string5, boolean bl) {
        this.zzaZp = string;
        this.mName = string2;
        this.zzade = string3;
        this.zzaXy = uri;
        this.zzaXJ = string4;
        this.zzaYM = new PlayerEntity(player);
        this.zzadd = l;
        this.zzaZq = string5;
        this.zzww = bl;
    }

    @Override
    public String getEventId() {
        return this.zzaZp;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzade;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzade, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaXy;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaXJ;
    }

    @Override
    public Player getPlayer() {
        return this.zzaYM;
    }

    @Override
    public long getValue() {
        return this.zzadd;
    }

    @Override
    public String getFormattedValue() {
        return this.zzaZq;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzaZq, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public boolean isVisible() {
        return this.zzww;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzaa.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object object) {
        return EventEntity.zza(this, object);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzaa.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzaa.equal((Object)event2.getName(), (Object)event.getName()) && zzaa.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzaa.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzaa.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzaa.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzaa.equal((Object)event2.getValue(), (Object)event.getValue()) && zzaa.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzaa.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzaa.zzv((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        EventEntityCreator.zza(this, parcel, n);
    }
}

