/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzabh;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class RequestsImpl
implements Requests {
    @Override
    public void registerRequestListener(GoogleApiClient googleApiClient, OnRequestReceivedListener onRequestReceivedListener) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            zzabh zzabh2 = googleApiClient.zzr((Object)onRequestReceivedListener);
            gamesClientImpl.zzd((zzabh<OnRequestReceivedListener>)zzabh2);
        }
    }

    @Override
    public void unregisterRequestListener(GoogleApiClient googleApiClient) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzEY();
        }
    }

    @Override
    public Intent getInboxIntent(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzFd();
    }

    @Override
    public Intent getSendIntent(GoogleApiClient googleApiClient, int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        return Games.zzi(googleApiClient).zza(n, byArray, n2, bitmap, string);
    }

    @Override
    public int getMaxPayloadSize(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzFe();
    }

    @Override
    public int getMaxLifetimeDays(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzFf();
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> acceptRequest(GoogleApiClient googleApiClient, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return this.acceptRequests(googleApiClient, arrayList);
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> acceptRequests(GoogleApiClient googleApiClient, List<String> list) {
        final String[] stringArray = list == null ? null : list.toArray(new String[list.size()]);
        return googleApiClient.zzb((zzaad.zza)new UpdateRequestsImpl(this, googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zzaad.zzb<Requests.UpdateRequestsResult>)this, stringArray);
            }
        });
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> dismissRequest(GoogleApiClient googleApiClient, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return this.dismissRequests(googleApiClient, arrayList);
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> dismissRequests(GoogleApiClient googleApiClient, List<String> list) {
        final String[] stringArray = list == null ? null : list.toArray(new String[list.size()]);
        return googleApiClient.zzb((zzaad.zza)new UpdateRequestsImpl(this, googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzc((zzaad.zzb<Requests.UpdateRequestsResult>)this, stringArray);
            }
        });
    }

    @Override
    public PendingResult<Requests.LoadRequestsResult> loadRequests(GoogleApiClient googleApiClient, final int n, final int n2, final int n3) {
        return googleApiClient.zza((zzaad.zza)new LoadRequestsImpl(this, googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzaad.zzb<Requests.LoadRequestsResult>)this, n, n2, n3);
            }
        });
    }

    @Override
    public ArrayList<GameRequest> getGameRequestsFromInboxResponse(Intent intent) {
        if (intent == null) {
            return new ArrayList<GameRequest>();
        }
        return this.getGameRequestsFromBundle(intent.getExtras());
    }

    @Override
    public ArrayList<GameRequest> getGameRequestsFromBundle(Bundle bundle) {
        if (bundle == null || !bundle.containsKey("requests")) {
            return new ArrayList<GameRequest>();
        }
        ArrayList arrayList = (ArrayList)bundle.get("requests");
        ArrayList<GameRequest> arrayList2 = new ArrayList<GameRequest>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList2.add((GameRequest)arrayList.get(i));
        }
        return arrayList2;
    }

    private static abstract class LoadRequestSummariesImpl
    extends Games.BaseGamesApiMethodImpl<Requests.LoadRequestSummariesResult> {
        public Requests.LoadRequestSummariesResult zzaP(final Status status) {
            return new Requests.LoadRequestSummariesResult(this){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaP(status);
        }
    }

    private static abstract class SendRequestImpl
    extends Games.BaseGamesApiMethodImpl<Requests.SendRequestResult> {
        public Requests.SendRequestResult zzaR(final Status status) {
            return new Requests.SendRequestResult(this){

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaR(status);
        }
    }

    private static abstract class UpdateRequestsImpl
    extends Games.BaseGamesApiMethodImpl<Requests.UpdateRequestsResult> {
        private UpdateRequestsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Requests.UpdateRequestsResult zzaS(final Status status) {
            return new Requests.UpdateRequestsResult(this){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public int getRequestOutcome(String string) {
                    String string2 = String.valueOf(string);
                    throw new IllegalArgumentException(string2.length() != 0 ? "Unknown request ID ".concat(string2) : new String("Unknown request ID "));
                }

                @Override
                public Set<String> getRequestIds() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaS(status);
        }
    }

    private static abstract class LoadRequestsImpl
    extends Games.BaseGamesApiMethodImpl<Requests.LoadRequestsResult> {
        private LoadRequestsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Requests.LoadRequestsResult zzaQ(final Status status) {
            return new Requests.LoadRequestsResult(this){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public GameRequestBuffer getRequests(int n) {
                    int n2 = status.getStatusCode();
                    return new GameRequestBuffer(DataHolder.zzcJ((int)n2));
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaQ(status);
        }
    }
}

