/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
extends GamesAbstractSafeParcelable
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final GameEntity zzbcv;
    private final String zzbeV;
    private final long zzbeW;
    private final Uri zzbeX;
    private final String zzbeY;
    private final String zzade;
    private final long zzbeZ;
    private final long zzaYP;
    private final Uri mIconUri;
    private final String zzbfa;
    private final String mName;
    private final long zzbfb;
    private final long zzbfc;
    private final int mState;
    private final int zzakD;
    private final ArrayList<MilestoneEntity> zzbfd;

    public QuestEntity(Quest quest) {
        this.zzbcv = new GameEntity(quest.getGame());
        this.zzbeV = quest.getQuestId();
        this.zzbeW = quest.getAcceptedTimestamp();
        this.zzade = quest.getDescription();
        this.zzbeX = quest.getBannerImageUri();
        this.zzbeY = quest.getBannerImageUrl();
        this.zzbeZ = quest.getEndTimestamp();
        this.mIconUri = quest.getIconImageUri();
        this.zzbfa = quest.getIconImageUrl();
        this.zzaYP = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzbfb = quest.zzGw();
        this.zzbfc = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzakD = quest.getType();
        List<Milestone> list = quest.zzGv();
        int n = list.size();
        this.zzbfd = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzbfd.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n, int n2, ArrayList<MilestoneEntity> arrayList) {
        this.zzbcv = gameEntity;
        this.zzbeV = string;
        this.zzbeW = l;
        this.zzbeX = uri;
        this.zzbeY = string2;
        this.zzade = string3;
        this.zzbeZ = l2;
        this.zzaYP = l3;
        this.mIconUri = uri2;
        this.zzbfa = string4;
        this.mName = string5;
        this.zzbfb = l4;
        this.zzbfc = l5;
        this.mState = n;
        this.zzakD = n2;
        this.zzbfd = arrayList;
    }

    @Override
    public String getQuestId() {
        return this.zzbeV;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzade;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzade, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.mIconUri;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzbfa;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzbeX;
    }

    @Override
    public String getBannerImageUrl() {
        return this.zzbeY;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzGv().get(0);
    }

    @Override
    public List<Milestone> zzGv() {
        return new ArrayList<Milestone>(this.zzbfd);
    }

    @Override
    public Game getGame() {
        return this.zzbcv;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.zzakD;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.zzbeW;
    }

    @Override
    public long getEndTimestamp() {
        return this.zzbeZ;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaYP;
    }

    @Override
    public long zzGw() {
        return this.zzbfb;
    }

    @Override
    public long getStartTimestamp() {
        return this.zzbfc;
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzbfb <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzaa.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzGv(), quest.getName(), quest.zzGw(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzaa.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzaa.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzaa.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzaa.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzaa.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzaa.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzaa.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzaa.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzaa.equal(quest2.zzGv(), quest.zzGv()) && zzaa.equal((Object)quest2.getName(), (Object)quest.getName()) && zzaa.equal((Object)quest2.zzGw(), (Object)quest.zzGw()) && zzaa.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzaa.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzaa.zzv((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzGv()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzGw()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        QuestEntityCreator.zza(this, parcel, n);
    }
}

