/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.AchievementEntity;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.player.ProfileSettingsEntity;
import com.google.android.gms.games.internal.player.StockProfileImageBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.social.OnSocialInviteUpdateReceivedListener;
import com.google.android.gms.games.social.Social;
import com.google.android.gms.games.social.SocialInvite;
import com.google.android.gms.games.social.SocialInviteBuffer;
import com.google.android.gms.games.social.SocialInviteEntity;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.PlayerStatsEntity;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoBuffer;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaan;
import com.google.android.gms.internal.zzaao;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzbat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends zzl<IGamesService> {
    EventIncrementManager zzaZt = new EventIncrementManager(){

        @Override
        public EventIncrementCache zzFn() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String zzaZu;
    private PlayerEntity zzaZv;
    private GameEntity zzaZw;
    private final PopupManager zzaZx;
    private boolean zzaZy = false;
    private final Binder zzaZz;
    private final long zzaZA;
    private final Games.GamesOptions zzaZB;
    private boolean zzaZC = false;

    public GamesClientImpl(Context context, Looper looper, zzg zzg2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzaZu = zzg2.zzxO();
        this.zzaZz = new Binder();
        this.zzaZx = PopupManager.zza(this, zzg2.zzxK());
        this.zzaZA = ((Object)((Object)this)).hashCode();
        this.zzaZB = gamesOptions;
        if (!this.zzaZB.zzaYg) {
            this.zzv(zzg2.zzxQ());
        }
    }

    public boolean zzrd() {
        return true;
    }

    public void zza(@NonNull IGamesService iGamesService) {
        super.zza((IInterface)iGamesService);
        if (this.zzaZy) {
            this.zzaZx.zzFB();
            this.zzaZy = false;
        }
        if (!this.zzaZB.zzaXY && !this.zzaZB.zzaYg) {
            this.zzb(iGamesService);
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzaZy = false;
    }

    public void zziH(int n) {
        this.zzaZx.setGravity(n);
    }

    public void zzv(View view) {
        this.zzaZx.zzw(view);
    }

    protected Set<Scope> zzc(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            zzac.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzac.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public void zza(zzf.zzf zzf2) {
        this.zzEO();
        super.zza(zzf2);
    }

    public void disconnect() {
        this.zzaZy = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zzxD();
                iGamesService.zzFm();
                this.zzaZt.flush();
                iGamesService.zzN(this.zzaZA);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzF("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String zzez() {
        return "com.google.android.gms.games.service.START";
    }

    protected String zzeA() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzcP(IBinder iBinder) {
        return IGamesService.Stub.zzcS(iBinder);
    }

    public Bundle zzuC() {
        try {
            Bundle bundle = ((IGamesService)this.zzxD()).zzuC();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return null;
        }
    }

    private void zzEO() {
        this.zzaZv = null;
        this.zzaZw = null;
    }

    protected Bundle zzqL() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzaZB.zzDP();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzaZu);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzaZx.zzFD()));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 6);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzbat.zza((zzg)this.zzxW()));
        return bundle;
    }

    public void zzb(IGamesService iGamesService) {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.zzaZx);
            iGamesService.zza(popupLocationInfoBinderCallbacks, this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public String zzEP() {
        try {
            return ((IGamesService)this.zzxD()).zzEP();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return null;
        }
    }

    public void zzf(zzaad.zzb<Games.GetTokenResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzj(new GetAuthTokenBinderCallbacks(zzb2));
    }

    public void zzb(String string, zzaad.zzb<Games.GetServerAuthCodeResult> zzb2) throws RemoteException {
        zzac.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((IGamesService)this.zzxD()).zza(string, new GetServerAuthCodeBinderCallbacks(zzb2));
    }

    public String zzaC(boolean bl) {
        if (bl && this.zzaZv != null) {
            return this.zzaZv.getPlayerId();
        }
        try {
            return ((IGamesService)this.zzxD()).zzFo();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zzEQ() {
        this.zzxC();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaZv == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zzxD()).zzFp());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzaZv = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzd(remoteException);
                }
            }
        }
        return this.zzaZv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zzER() {
        this.zzxC();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaZw == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zzxD()).zzFr());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzaZw = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzd(remoteException);
                }
            }
        }
        return this.zzaZw;
    }

    public void zza(zzaad.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzaad.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzxD()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zzaad.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zzaad.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzxD()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zzaad.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "connected_1p": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                String string3 = String.valueOf(string);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid player collection: ".concat(string3) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zzaad.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zzES() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzES();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzl(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzm(string, n, n2);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzb(zzaad.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zzaad.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzaad.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zzaad.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zzaad.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zzaad.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zzGo().asBundle(), n, n2);
    }

    public void zza(zzaad.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zzET() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzET();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zzaad.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzaad.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaZx.zzFD(), this.zzaZx.zzFC());
    }

    public void zzb(zzaad.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaZx.zzFD(), this.zzaZx.zzFC());
    }

    public void zza(zzaad.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaZx.zzFD(), this.zzaZx.zzFC());
    }

    public void zzb(zzaad.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaZx.zzFD(), this.zzaZx.zzFC());
    }

    public void zzd(zzaad.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.zzaZt.flush();
        ((IGamesService)this.zzxD()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzaad.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzaZt.flush();
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzo(String string, int n) {
        this.zzaZt.zzo(string, n);
    }

    public Intent zzEU() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzEU();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzEV() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzEV();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzabh<OnInvitationReceivedListener> zzabh2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zzabh2);
            ((IGamesService)this.zzxD()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzEW() {
        try {
            ((IGamesService)this.zzxD()).zzO(this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzb(zzabh<OnTurnBasedMatchUpdateReceivedListener> zzabh2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zzabh2);
            ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzEX() {
        try {
            ((IGamesService)this.zzxD()).zzP(this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzc(zzabh<QuestUpdateListener> zzabh2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zzabh2);
            ((IGamesService)this.zzxD()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzEY() {
        try {
            ((IGamesService)this.zzxD()).zzR(this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzd(zzabh<OnRequestReceivedListener> zzabh2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zzabh2);
            ((IGamesService)this.zzxD()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzEZ() {
        try {
            ((IGamesService)this.zzxD()).zzQ(this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzFa() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzFa();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzFb() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzFb();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzg(zzaad.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzh(zzaad.zzb<Status> zzb2) throws RemoteException {
        this.zzaZt.flush();
        ((IGamesService)this.zzxD()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zzFc() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zzxD()).zzFc();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public String zzke() {
        try {
            return ((IGamesService)this.zzxD()).zzke();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return null;
        }
    }

    public void zza(zzaad.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzp(String string, int n) {
        try {
            ((IGamesService)this.zzxD()).zzp(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzq(String string, int n) {
        try {
            ((IGamesService)this.zzxD()).zzq(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzaad.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzGu(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zzaad.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzk((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zzaad.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzl((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zzFd() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzxD()).zzFd();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public void zza(zzaad.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zzaad.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zzaad.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzn(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zzaad.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzaad.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzm((IGamesCallbacks)new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzem(String string) {
        try {
            ((IGamesService)this.zzxD()).zzeu(string);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zza(zzaad.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zzaad.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzo(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzabh<RoomUpdateListener> zzabh2, zzabh<RoomStatusUpdateListener> zzabh3, zzabh<RealTimeMessageReceivedListener> zzabh4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzabh2, zzabh3, zzabh4);
            ((IGamesService)this.zzxD()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaZz, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzb(zzabh<RoomUpdateListener> zzabh2, zzabh<RoomStatusUpdateListener> zzabh3, zzabh<RealTimeMessageReceivedListener> zzabh4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzabh2, zzabh3, zzabh4);
            ((IGamesService)this.zzxD()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaZz, roomConfig.getInvitationId(), false, this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zza(zzabh<RoomUpdateListener> zzabh2, String string) {
        try {
            ((IGamesService)this.zzxD()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zzabh2), string);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public int zza(zzabh<RealTimeMultiplayer.ReliableMessageSentCallback> zzabh2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zzabh2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzac.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zzxD()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return -1;
        }
    }

    public int zze(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zzxD()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return -1;
        }
    }

    public void zziI(int n) {
        try {
            ((IGamesService)this.zzxD()).zziI(n);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public Intent zzFe() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzFe();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zza(n, byArray, n2, string);
            zzac.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public int zzFf() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzxD()).zzFf();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public int zzFg() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzxD()).zzFg();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public void zzb(zzaad.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zzaad.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zzaad.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zzaad.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public void zze(zzaad.zzb<Stats.LoadPlayerStatsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzi((IGamesCallbacks)new PlayerStatsLoadedBinderCallbacks(zzb2), bl);
    }

    public Intent zzc(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzc(nArray);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzen(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzen(string);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zzaad.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.zzaZt.flush();
        ((IGamesService)this.zzxD()).zzt(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zzaad.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.zzaZt.flush();
        ((IGamesService)this.zzxD()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zzaad.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaZt.flush();
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zzaad.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaZt.flush();
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzeo(String string) {
        try {
            ((IGamesService)this.zzxD()).zza(string, this.zzaZx.zzFD(), this.zzaZx.zzFC());
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zza(zzaad.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaZt.flush();
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zzaad.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaZt.flush();
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zzFh() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzxD()).zzFh();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public int zzFi() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzxD()).zzFi();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zzaad.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zzaad.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zzaad.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzac.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzGz();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzAq();
        snapshotContents.close();
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, zzc2);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzac.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzAq();
        snapshotContents.close();
        try {
            ((IGamesService)this.zzxD()).zza(zzc2);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzi(zzaad.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzq(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zzaad.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzac.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzGz();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzAq();
        snapshotContents.close();
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, zzc2);
    }

    public void zzi(zzaad.zzb<Videos.CaptureCapabilitiesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzl(new CaptureCapabilitiesBinderCallback(zzb2));
    }

    public Intent zzFj() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zzFx();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzj(zzaad.zzb<Videos.CaptureStateResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzv(new CaptureStateBinderCallbacks(zzb2));
    }

    public void zzk(zzaad.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzs(new CaptureStreamingAvailabilityBinderCallback(zzb2));
    }

    public void zzl(zzaad.zzb<Videos.CaptureStreamingMetadataResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzq(new CaptureStreamingMetadataBinderCallback(zzb2));
    }

    public void zzm(zzaad.zzb<Videos.CaptureStreamingUrlResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzr(new CaptureStreamingUrlBinderCallback(zzb2));
    }

    public void zzn(zzaad.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzt(new HeadlessCaptureEnabledBinderCallback(zzb2));
    }

    public void zzb(zzaad.zzb<Videos.CaptureAvailableResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzxD()).zzc((IGamesCallbacks)new CaptureAvailableBinderCallback(zzb2), n);
    }

    public boolean zzFk() {
        boolean bl = false;
        try {
            bl = ((IGamesService)this.zzxD()).zzFk();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return bl;
    }

    public void zzo(zzaad.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzo(new CaptureStreamingEnabledBinderCallback(zzb2));
    }

    public void zza(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl, String string, VideoConfiguration videoConfiguration) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new CaptureLaunchGameAndOverlayBinderCallback(baseGamesApiMethodImpl), string, videoConfiguration);
    }

    public void zzp(zzaad.zzb<Videos.ListVideosResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzk(new ListVideosBinderCallback(zzb2));
    }

    public void zzc(zzaad.zzb<Videos.ListVideosResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzxD()).zzd((IGamesCallbacks)new ListVideosBinderCallback(zzb2), string, n);
    }

    public void zze(zzabh<Videos.CaptureOverlayStateListener> zzabh2) {
        try {
            CaptureOverlayStateBinderCallback captureOverlayStateBinderCallback = new CaptureOverlayStateBinderCallback(zzabh2);
            ((IGamesService)this.zzxD()).zzf((IGamesCallbacks)captureOverlayStateBinderCallback, this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzg(zzaad.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzm((IGamesCallbacks)new CapturePausedBinderCallback(zzb2), bl);
    }

    public void zza(zzaad.zzb<Status> zzb2, VideoConfiguration videoConfiguration, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new CaptureStartedBinderCallbacks(zzb2, captureRuntimeErrorCallback), videoConfiguration);
    }

    public void zzq(zzaad.zzb<Videos.CaptureStoppedResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzu(new CaptureStoppedBinderCallbacks(zzb2));
    }

    public void zzFl() {
        try {
            ((IGamesService)this.zzxD()).zzU(this.zzaZA);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzc(zzaad.zzb<Status> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzh(new UpdateHeadlessCapturePermissionBinderCallback(zzb2), string, bl);
    }

    public void zzj(zzaad.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zzaad.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzp(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzaad.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzaad.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zzaad.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzaad.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzaad.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zzaad.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zzaad.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzxD()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzb(zzaad.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zzaad.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzl(zzaad.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzr(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzaad.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zze(zzaad.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzxD()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zza(zzaad.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl, bl2);
    }

    public void zzh(zzaad.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zza(zzaad.zzb<Players.LoadPlayersResult> zzb2, Account account) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), account);
    }

    public void zzr(zzaad.zzb<Players.LoadStockProfileImagesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzp(new StockProfileImagesLoadedBinderCallback(zzb2));
    }

    public void zza(zzaad.zzb<Players.UpdateGamerProfileResult> zzb2, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new GamerProfileUpdatedBinderCallback(zzb2), string, bl, string2, bl2, bl3);
    }

    public void zzi(zzaad.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzj((IGamesCallbacks)new DeletePlayerBinderCallback(zzb2), bl);
    }

    public void zzj(zzaad.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzk((IGamesCallbacks)new UpdateAutoSignInBinderCallback(zzb2), bl);
    }

    public void zzk(zzaad.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzl((IGamesCallbacks)new UpdateProfileDiscoverabilityBinderCallback(zzb2), bl);
    }

    public void zzb(zzaad.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public Intent zza(AchievementEntity achievementEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzxD()).zza(achievementEntity);
            if (achievementEntity != null && intent != null) {
                intent.setExtrasClassLoader(achievementEntity.getClass().getClassLoader());
            }
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zzaad.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zzaad.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzxD()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzaad.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzm(zzaad.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzj((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zzaad.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zze(zzaad.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzn(zzaad.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzi((IGamesCallbacks)new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzl(zzaad.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzaad.zzb<Status> zzb2, boolean bl, boolean bl2, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bl2, bundle);
    }

    public void zzs(zzaad.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzs(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zzaad.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zzaad.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zzaad.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzg(zzaad.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzxD()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zzaad.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzxD()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                this.zzd(remoteException);
            }
        }
    }

    public void zzFm() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzxD()).zzFm();
            }
            catch (RemoteException remoteException) {
                this.zzd(remoteException);
            }
        }
    }

    private void zzd(RemoteException remoteException) {
        GamesLog.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static Room zzai(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzaZC = this.zzaZy = bundle.getBoolean("show_welcome_popup");
            this.zzaZv = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzaZw = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public void zzo(zzaad.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzu(new SendFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzp(zzaad.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzv(new AcceptFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzq(zzaad.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzw(new IgnoreFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzr(zzaad.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzx(new CancelFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zze(zzaad.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzxD()).zzf(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzs(zzaad.zzb<Players.LoadPlayersResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzxD()).zzy(new PlayerUnfriendedBinderCallback(zzb2), string);
    }

    public void zzf(zzaad.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzxD()).zzg(new SetPlayerMutedBinderCallback(zzb2), string, bl);
    }

    public void zzc(zzaad.zzb<Social.LoadInvitesResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzxD()).zzb((IGamesCallbacks)new InvitesLoadedBinderCallback(zzb2), n);
    }

    public void zza(Account account, byte[] byArray) throws RemoteException {
        ((IGamesService)this.zzxD()).zza(account, byArray);
    }

    public void zzg(Account account) throws RemoteException {
        ((IGamesService)this.zzxD()).zzg(account);
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzcP(iBinder);
    }

    private static final class ListVideosResultImpl
    extends GamesDataHolderResult
    implements Videos.ListVideosResult {
        private final VideoBuffer zzbaa;

        public ListVideosResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbaa = new VideoBuffer(dataHolder);
        }
    }

    private static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final Status zzair;
        private final String zzE;

        CaptureStreamingUrlResultImpl(Status status, String string) {
            this.zzair = status;
            this.zzE = string;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public String getUrl() {
            return this.zzE;
        }
    }

    private static final class CaptureStreamingMetadataResultImpl
    implements Videos.CaptureStreamingMetadataResult {
        private final Status zzair;
        private final String zzamJ;
        private final String zzade;

        CaptureStreamingMetadataResultImpl(Status status, String string, String string2) {
            this.zzair = status;
            this.zzamJ = string;
            this.zzade = string2;
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    private static final class CaptureStreamingEnabledResultImpl
    implements Result {
        private final Status zzair;

        public Status getStatus() {
            return this.zzair;
        }
    }

    private static final class CaptureStreamingAvailabilityResultImpl
    implements Videos.CaptureStreamingAvailabilityResult {
        private final Status zzair;
        private final boolean zzaZI;
        private final boolean zzaZP;

        CaptureStreamingAvailabilityResultImpl(Status status, boolean bl, boolean bl2) {
            this.zzair = status;
            this.zzaZI = bl;
            this.zzaZP = bl2;
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    private static final class CaptureStoppedResultImpl
    implements Videos.CaptureStoppedResult {
        private final Status zzair;
        private final Uri zzaZO;

        CaptureStoppedResultImpl(Status status, Uri uri) {
            this.zzair = status;
            this.zzaZO = uri;
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    private static final class CaptureStateResultImpl
    implements Videos.CaptureStateResult {
        private final Status zzair;
        private final CaptureState zzaZN;

        CaptureStateResultImpl(Status status, CaptureState captureState) {
            this.zzair = status;
            this.zzaZN = captureState;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public CaptureState getCaptureState() {
            return this.zzaZN;
        }
    }

    private static final class CaptureCapabilitiesResultImpl
    implements Videos.CaptureCapabilitiesResult {
        private final Status zzair;
        private final VideoCapabilities zzaZJ;

        CaptureCapabilitiesResultImpl(Status status, VideoCapabilities videoCapabilities) {
            this.zzair = status;
            this.zzaZJ = videoCapabilities;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public VideoCapabilities getCapabilities() {
            return this.zzaZJ;
        }
    }

    private static final class CaptureAvailableResultImpl
    implements Videos.CaptureAvailableResult {
        private final Status zzair;
        private final boolean zzaZI;

        CaptureAvailableResultImpl(Status status, boolean bl) {
            this.zzair = status;
            this.zzaZI = bl;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public boolean isAvailable() {
            return this.zzaZI;
        }
    }

    private static final class InviteUpdateResultImpl
    extends GamesDataHolderResult
    implements Social.InviteUpdateResult {
        private final SocialInvite zzaZX;

        InviteUpdateResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            try {
                this.zzaZX = socialInviteBuffer.getCount() > 0 ? new SocialInviteEntity((SocialInvite)socialInviteBuffer.get(0)) : null;
            }
            finally {
                socialInviteBuffer.release();
            }
        }
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status zzair;
        private final String zzaZS;

        DeleteSnapshotResultImpl(int n, String string) {
            this.zzair = GamesStatusCodes.zzik(n);
            this.zzaZS = string;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public String getSnapshotId() {
            return this.zzaZS;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzaZR;

        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzaZR = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.zzaZR;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzbax;
        private final String zzbay;
        private final Snapshot zzbaz;
        private final com.google.android.gms.drive.zzc zzbaA;
        private final SnapshotContents zzbaB;

        OpenSnapshotResultImpl(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this(dataHolder, null, zzc2, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzbax = null;
                    this.zzbaz = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    zzc.zzaw((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzbax = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(zzc2));
                    this.zzbaz = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzbax = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(zzc2));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.zzbaz = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(zzc3));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzbay = string;
            this.zzbaA = zzc4;
            this.zzbaB = new SnapshotContentsEntity(zzc4);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.zzbax;
        }

        @Override
        public String getConflictId() {
            return this.zzbay;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.zzbaz;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.zzbaB;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzaBi);
        }
    }

    private static final class LoadPlayerStatsResultImpl
    extends GamesDataHolderResult
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzbal;

        LoadPlayerStatsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzbal = playerStatsBuffer.getCount() > 0 ? new PlayerStatsEntity((PlayerStats)playerStatsBuffer.get(0)) : null;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public PlayerStats getPlayerStats() {
            return this.zzbal;
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> zzbac;

        LoadAppContentsResultImpl(DataHolder[] dataHolderArray) {
            super(dataHolderArray[0]);
            this.zzbac = new ArrayList<DataHolder>(Arrays.asList(dataHolderArray));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzaZQ;
        private final Quest zzaZF;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzaZF = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzaZF.zzGw();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.zzaZQ = list.get(i);
                        return;
                    }
                    this.zzaZQ = null;
                } else {
                    this.zzaZQ = null;
                    this.zzaZF = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.zzaZQ;
        }

        @Override
        public Quest getQuest() {
            return this.zzaZF;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest zzaZF;

        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzaZF = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.zzaZF;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder zzaBi;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaBi = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.zzaBi);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status zzair;
        private final Bundle zzban;

        LoadRequestsResultImpl(Status status, Bundle bundle) {
            this.zzair = status;
            this.zzban = bundle;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public GameRequestBuffer getRequests(int n) {
            String string = RequestType.zziL(n);
            if (!this.zzban.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzban.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.zzban.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzban.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes zzbbe;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbbe = RequestUpdateOutcomes.zzal(dataHolder);
        }

        @Override
        public int getRequestOutcome(String string) {
            return this.zzbbe.getRequestOutcome(string);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.zzbbe.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest zzbaK;

        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.zzbaK = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status zzair;
        private final Bundle zzaZV;

        InboxCountResultImpl(Status status, Bundle bundle) {
            this.zzair = status;
            this.zzaZV = bundle;
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    private static final class GetServerAuthCodeResultImpl
    implements Games.GetServerAuthCodeResult {
        private final Status zzair;
        private final String zzaZU;

        GetServerAuthCodeResultImpl(Status status, String string) {
            this.zzair = status;
            this.zzaZU = string;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public String getCode() {
            return this.zzaZU;
        }
    }

    private static final class GetTokenResultImpl
    implements Games.GetTokenResult {
        private final Status zzair;
        private final String zzaiJ;

        GetTokenResultImpl(Status status, String string) {
            this.zzair = status;
            this.zzaiJ = string;
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status zzair;
        private final String zzaZT;
        private final boolean zzaaD;

        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.zzair = GamesStatusCodes.zzik(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.zzaZT = dataHolder.zzd("external_game_id", 0, 0);
                    this.zzaaD = dataHolder.zze("muted", 0, 0);
                } else {
                    this.zzaZT = null;
                    this.zzaaD = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status zzair;
        private final String zzaZT;
        private final boolean zzaaD;

        public GameMuteStatusChangeResultImpl(int n, String string, boolean bl) {
            this.zzair = GamesStatusCodes.zzik(n);
            this.zzaZT = string;
            this.zzaaD = bl;
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status zzair;
        private final String zzaZH;

        CancelMatchResultImpl(Status status, String string) {
            this.zzair = status;
            this.zzaZH = string;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public String getMatchId() {
            return this.zzaZH;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch zzbav;

        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzbav = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzbav;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzbaW;

        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzbaW = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.zzbaW;
        }
    }

    private static final class UpdateGamerProfileResultImpl
    implements Players.UpdateGamerProfileResult {
        private final Status zzair;
        private final Bundle zzbbd;

        UpdateGamerProfileResultImpl(int n, Bundle bundle) {
            this.zzair = new Status(n);
            this.zzbbd = bundle;
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    private static final class LoadStockProfileImagesResultImpl
    extends GamesDataHolderResult
    implements Players.LoadStockProfileImagesResult {
        private final StockProfileImageBuffer zzbaq;

        LoadStockProfileImagesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbaq = new StockProfileImageBuffer(dataHolder);
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer zzbat;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbat = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status zzair;
        private final List<String> zzbar;
        private final Bundle zzbas;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle bundle) {
            this.zzair = status;
            this.zzbar = bundle.getStringArrayList("game_category_list");
            this.zzbas = bundle;
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    private static final class LoadInvitesResultImpl
    extends GamesDataHolderResult
    implements Social.LoadInvitesResult {
        private final SocialInviteBuffer zzbai;

        LoadInvitesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbai = new SocialInviteBuffer(dataHolder);
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzbam;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbam = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.zzbam;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status zzair;
        private final LoadMatchesResponse zzbaj;

        LoadMatchesResultImpl(Status status, Bundle bundle) {
            this.zzair = status;
            this.zzbaj = new LoadMatchesResponse(bundle);
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.zzbaj;
        }

        public void release() {
            this.zzbaj.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzbah;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbah = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.zzbah;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzbak;

        LoadPlayerScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.zzbak = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.zzbak;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzbao;
        private final LeaderboardScoreBuffer zzbap;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.zzbao = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzbap = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.zzbao;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.zzbap;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzaZY;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZY = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.zzaZY;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer zzbaf;

        LoadGameSearchSuggestionsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbaf = new GameSearchSuggestionBuffer(dataHolder);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer zzbae;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbae = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzbag;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbag = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.zzbag;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer zzbad;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbad = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.zzbad;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status zzair;
        private final String zzaYF;

        UpdateAchievementResultImpl(int n, String string) {
            this.zzair = GamesStatusCodes.zzik(n);
            this.zzaYF = string;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public String getAchievementId() {
            return this.zzaYF;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzbab;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbab = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.zzbab;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zzaao {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzik(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zzabh.zzc<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzavD;
        private final String zzbaH;
        private final int zzbaI;

        RealTimeMessageSentNotifier(int n, int n2, String string) {
            this.zzavD = n;
            this.zzbaI = n2;
            this.zzbaH = string;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.zzavD, this.zzbaI, this.zzbaH);
            }
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zzabh.zzc<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzbaw;

        MessageReceivedNotifier(RealTimeMessage realTimeMessage) {
            this.zzbaw = realTimeMessage;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.zzbaw);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zzabh.zzc<RoomStatusUpdateListener> {
        private final String zzbaC;

        P2PDisconnectedNotifier(String string) {
            this.zzbaC = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.zzbaC);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zzabh.zzc<RoomStatusUpdateListener> {
        private final String zzbaC;

        P2PConnectedNotifier(String string) {
            this.zzbaC = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.zzbaC);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zzabh.zzc<RoomUpdateListener> {
        private final int zzavD;
        private final String zzaZZ;

        LeftRoomNotifier(int n, String string) {
            this.zzavD = n;
            this.zzaZZ = string;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.zzavD, this.zzaZZ);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> zzaZE = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzaZE.add(stringArray[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzaZE);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zzaan<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzai(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zzaan<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzai(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zzabh.zzc<OnNearbyPlayerDetectedListener> {
        public void zzwc() {
        }
    }

    private static final class SocialInviteRemovedNotifier
    implements zzabh.zzc<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite zzbaV;

        SocialInviteRemovedNotifier(SocialInvite socialInvite) {
            this.zzbaV = socialInvite;
        }

        public void zzwc() {
        }
    }

    private static final class SocialInviteUpdateReceivedNotifier
    implements zzabh.zzc<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite zzbaV;

        SocialInviteUpdateReceivedNotifier(SocialInvite socialInvite) {
            this.zzbaV = socialInvite;
        }

        public void zzwc() {
        }
    }

    private static final class RequestRemovedNotifier
    implements zzabh.zzc<OnRequestReceivedListener> {
        private final String zzOV;

        RequestRemovedNotifier(String string) {
            this.zzOV = string;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzOV);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zzabh.zzc<OnRequestReceivedListener> {
        private final GameRequest zzbaK;

        RequestReceivedNotifier(GameRequest gameRequest) {
            this.zzbaK = gameRequest;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.zzbaK);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zzabh.zzc<QuestUpdateListener> {
        private final Quest zzaZF;

        QuestCompletedNotifier(Quest quest) {
            this.zzaZF = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.zzaZF);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zzabh.zzc<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzbau;

        MatchRemovedNotifier(String string) {
            this.zzbau = string;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.zzbau);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zzabh.zzc<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzbav;

        MatchUpdateReceivedNotifier(TurnBasedMatch turnBasedMatch) {
            this.zzbav = turnBasedMatch;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.zzbav);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zzabh.zzc<OnInvitationReceivedListener> {
        private final String zzaij;

        InvitationRemovedNotifier(String string) {
            this.zzaij = string;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.zzaij);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zzabh.zzc<OnInvitationReceivedListener> {
        private final Invitation zzaZW;

        InvitationReceivedNotifier(Invitation invitation) {
            this.zzaZW = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.zzaZW);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class CaptureOverlayStateChangedNotifier
    implements zzabh.zzc<Videos.CaptureOverlayStateListener> {
        private final int zzaZL;

        CaptureOverlayStateChangedNotifier(int n) {
            this.zzaZL = n;
        }

        public void zza(Videos.CaptureOverlayStateListener captureOverlayStateListener) {
            captureOverlayStateListener.onCaptureOverlayStateChanged(this.zzaZL);
        }

        public void zzwc() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((Videos.CaptureOverlayStateListener)object);
        }
    }

    private static final class SetPlayerMutedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Players.LoadPlayersResult> zzaGN;

        SetPlayerMutedBinderCallback(zzaad.zzb<Players.LoadPlayersResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzag(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class PlayerUnfriendedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Players.LoadPlayersResult> zzaGN;

        PlayerUnfriendedBinderCallback(zzaad.zzb<Players.LoadPlayersResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaf(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class CancelFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Social.InviteUpdateResult> zzaGN;

        CancelFriendInviteFirstPartyBinderCallback(zzaad.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzae(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class IgnoreFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Social.InviteUpdateResult> zzaGN;

        IgnoreFriendInviteFirstPartyBinderCallback(zzaad.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzad(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class AcceptFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Social.InviteUpdateResult> zzaGN;

        AcceptFriendInviteFirstPartyBinderCallback(zzaad.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaa(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class SendFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Social.InviteUpdateResult> zzaGN;

        SendFriendInviteFirstPartyBinderCallback(zzaad.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzZ(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class UpdateHeadlessCapturePermissionBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Status> zzaGN;

        UpdateHeadlessCapturePermissionBinderCallback(zzaad.zzb<Status> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzao(Status status) {
            this.zzaGN.setResult((Object)status);
        }
    }

    private static final class ListVideosBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Videos.ListVideosResult> zzaGN;

        ListVideosBinderCallback(zzaad.zzb<Videos.ListVideosResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzX(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new ListVideosResultImpl(dataHolder));
        }
    }

    private static final class CaptureStreamingUrlBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Videos.CaptureStreamingUrlResult> zzaGN;

        CaptureStreamingUrlBinderCallback(zzaad.zzb<Videos.CaptureStreamingUrlResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(int n, String string) {
            this.zzaGN.setResult((Object)new CaptureStreamingUrlResultImpl(new Status(n), string));
        }
    }

    private static final class CaptureStreamingMetadataBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Videos.CaptureStreamingMetadataResult> zzaGN;

        CaptureStreamingMetadataBinderCallback(zzaad.zzb<Videos.CaptureStreamingMetadataResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, String string, String string2) {
            this.zzaGN.setResult((Object)new CaptureStreamingMetadataResultImpl(new Status(n), string, string2));
        }
    }

    private static final class CaptureStreamingEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Status> zzaGN;

        CaptureStreamingEnabledBinderCallback(zzaad.zzb<Status> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zziA(int n) {
            this.zzaGN.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureStreamingAvailabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Videos.CaptureStreamingAvailabilityResult> zzaGN;

        CaptureStreamingAvailabilityBinderCallback(zzaad.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, boolean bl, boolean bl2) {
            this.zzaGN.setResult((Object)new CaptureStreamingAvailabilityResultImpl(new Status(n), bl, bl2));
        }
    }

    private static final class CaptureStoppedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Videos.CaptureStoppedResult> zzaGN;

        public CaptureStoppedBinderCallbacks(zzaad.zzb<Videos.CaptureStoppedResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, Uri uri) {
            this.zzaGN.setResult((Object)new CaptureStoppedResultImpl(new Status(n), uri));
        }
    }

    private static final class CaptureStateBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Videos.CaptureStateResult> zzaGN;

        public CaptureStateBinderCallbacks(zzaad.zzb<Videos.CaptureStateResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, Bundle bundle) {
            this.zzaGN.setResult((Object)new CaptureStateResultImpl(new Status(n), CaptureState.zzC(bundle)));
        }
    }

    private static final class CaptureStartedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Status> zzaGN;
        private final Videos.CaptureRuntimeErrorCallback zzaZM;

        public CaptureStartedBinderCallbacks(zzaad.zzb<Status> zzb2, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
            this.zzaZM = (Videos.CaptureRuntimeErrorCallback)zzac.zzb((Object)captureRuntimeErrorCallback, (Object)"Callback must not be null");
        }

        @Override
        public void zzap(Status status) {
            this.zzaGN.setResult((Object)status);
        }

        @Override
        public void zziE(int n) {
        }
    }

    private static final class CapturePausedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Status> zzaGN;

        public CapturePausedBinderCallback(zzaad.zzb<Status> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zziF(int n) {
            this.zzaGN.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureOverlayStateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzabh<Videos.CaptureOverlayStateListener> zzaNm;

        CaptureOverlayStateBinderCallback(zzabh<Videos.CaptureOverlayStateListener> zzabh2) {
            this.zzaNm = (zzabh)zzac.zzb(zzabh2, (Object)"Callback must not be null");
        }

        @Override
        public void onCaptureOverlayStateChanged(int n) {
            this.zzaNm.zza((zzabh.zzc)new CaptureOverlayStateChangedNotifier(n));
        }
    }

    private static final class CaptureLaunchGameAndOverlayBinderCallback
    extends AbstractGamesCallbacks {
        private final Games.BaseGamesApiMethodImpl<Status> zzaZK;

        CaptureLaunchGameAndOverlayBinderCallback(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl) {
            this.zzaZK = (Games.BaseGamesApiMethodImpl)((Object)zzac.zzb(baseGamesApiMethodImpl, (Object)"Holder must not be null"));
        }

        @Override
        public void zziz(int n) {
            this.zzaZK.zzb((Result)new Status(n));
        }

        @Override
        public void zzam(Status status) {
            this.zzaZK.zzb((Result)status);
        }
    }

    private static final class CaptureCapabilitiesBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Videos.CaptureCapabilitiesResult> zzaGN;

        CaptureCapabilitiesBinderCallback(zzaad.zzb<Videos.CaptureCapabilitiesResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, VideoCapabilities videoCapabilities) {
            this.zzaGN.setResult((Object)new CaptureCapabilitiesResultImpl(new Status(n), videoCapabilities));
        }
    }

    private static final class CaptureAvailableBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Videos.CaptureAvailableResult> zzaGN;

        CaptureAvailableBinderCallback(zzaad.zzb<Videos.CaptureAvailableResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, boolean bl) {
            this.zzaGN.setResult((Object)new CaptureAvailableResultImpl(new Status(n), bl));
        }
    }

    private static final class HeadlessCaptureEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Status> zzaGN;

        HeadlessCaptureEnabledBinderCallback(zzaad.zzb<Status> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzan(Status status) {
            this.zzaGN.setResult((Object)status);
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Snapshots.DeleteSnapshotResult> zzaGN;

        public SnapshotDeletedBinderCallbacks(zzaad.zzb<Snapshots.DeleteSnapshotResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(int n, String string) {
            this.zzaGN.setResult((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Snapshots.CommitSnapshotResult> zzbaS;

        public SnapshotCommittedBinderCallbacks(zzaad.zzb<Snapshots.CommitSnapshotResult> zzb2) {
            this.zzbaS = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzO(DataHolder dataHolder) {
            this.zzbaS.setResult((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Snapshots.OpenSnapshotResult> zzbaT;

        public SnapshotOpenedBinderCallbacks(zzaad.zzb<Snapshots.OpenSnapshotResult> zzb2) {
            this.zzbaT = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this.zzbaT.setResult((Object)new OpenSnapshotResultImpl(dataHolder, zzc2));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            this.zzbaT.setResult((Object)new OpenSnapshotResultImpl(dataHolder, string, zzc2, zzc3, zzc4));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Snapshots.LoadSnapshotsResult> zzbaU;

        public SnapshotsLoadedBinderCallbacks(zzaad.zzb<Snapshots.LoadSnapshotsResult> zzb2) {
            this.zzbaU = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzN(DataHolder dataHolder) {
            this.zzbaU.setResult((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class PlayerStatsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Stats.LoadPlayerStatsResult> zzaGN;

        public PlayerStatsLoadedBinderCallbacks(zzaad.zzb<Stats.LoadPlayerStatsResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzW(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadPlayerStatsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<AppContents.LoadAppContentResult> zzaZG;

        public AppContentLoadedBinderCallbacks(zzaad.zzb<AppContents.LoadAppContentResult> zzb2) {
            this.zzaZG = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.zzaZG.setResult((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Quests.LoadQuestsResult> zzbaG;

        public QuestsLoadedBinderCallbacks(zzaad.zzb<Quests.LoadQuestsResult> zzb2) {
            this.zzbaG = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzT(DataHolder dataHolder) {
            this.zzbaG.setResult((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Quests.ClaimMilestoneResult> zzbaE;
        private final String zzbaF;

        public QuestMilestoneClaimBinderCallbacks(zzaad.zzb<Quests.ClaimMilestoneResult> zzb2, String string) {
            this.zzbaE = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
            this.zzbaF = (String)zzac.zzb((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzP(DataHolder dataHolder) {
            this.zzbaE.setResult((Object)new ClaimMilestoneResultImpl(dataHolder, this.zzbaF));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Quests.AcceptQuestResult> zzbaD;

        public QuestAcceptedBinderCallbacks(zzaad.zzb<Quests.AcceptQuestResult> zzb2) {
            this.zzbaD = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzQ(DataHolder dataHolder) {
            this.zzbaD.setResult((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Requests.LoadRequestSummariesResult> zzbaM;

        public RequestSummariesLoadedBinderCallbacks(zzaad.zzb<Requests.LoadRequestSummariesResult> zzb2) {
            this.zzbaM = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzM(DataHolder dataHolder) {
            this.zzbaM.setResult((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Requests.LoadRequestsResult> zzbaN;

        public RequestsLoadedBinderCallbacks(zzaad.zzb<Requests.LoadRequestsResult> zzb2) {
            this.zzbaN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzik(n);
            this.zzbaN.setResult((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Requests.SendRequestResult> zzbaL;

        public RequestSentBinderCallbacks(zzaad.zzb<Requests.SendRequestResult> zzb2) {
            this.zzbaL = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzL(DataHolder dataHolder) {
            this.zzbaL.setResult((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Requests.UpdateRequestsResult> zzbaO;

        public RequestsUpdatedBinderCallbacks(zzaad.zzb<Requests.UpdateRequestsResult> zzb2) {
            this.zzbaO = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzK(DataHolder dataHolder) {
            this.zzbaO.setResult((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager zzaZx;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.zzaZx = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zzEL() {
            return new PopupLocationInfoParcelable(this.zzaZx.zzFE());
        }
    }

    private static final class GetServerAuthCodeBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Games.GetServerAuthCodeResult> zzaGN;

        public GetServerAuthCodeBinderCallbacks(zzaad.zzb<Games.GetServerAuthCodeResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            Status status = GamesStatusCodes.zzik(n);
            this.zzaGN.setResult((Object)new GetServerAuthCodeResultImpl(status, string));
        }
    }

    private static final class GetAuthTokenBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Games.GetTokenResult> zzaGN;

        public GetAuthTokenBinderCallbacks(zzaad.zzb<Games.GetTokenResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            Status status = GamesStatusCodes.zzik(n);
            this.zzaGN.setResult((Object)new GetTokenResultImpl(status, string));
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Status> zzaGN;

        public SignOutCompleteBinderCallbacks(zzaad.zzb<Status> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzEK() {
            Status status = GamesStatusCodes.zzik(0);
            this.zzaGN.setResult((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Notifications.InboxCountResult> zzaGN;

        InboxCountsLoadedBinderCallback(zzaad.zzb<Notifications.InboxCountResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzik(n);
            this.zzaGN.setResult((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Status> zzaGN;

        ContactSettingsUpdatedBinderCallback(zzaad.zzb<Status> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzix(int n) {
            this.zzaGN.setResult((Object)GamesStatusCodes.zzik(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Notifications.ContactSettingLoadResult> zzaGN;

        ContactSettingsLoadedBinderCallback(zzaad.zzb<Notifications.ContactSettingLoadResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzI(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Notifications.GameMuteStatusLoadResult> zzaGN;

        GameMuteStatusLoadedBinderCallback(zzaad.zzb<Notifications.GameMuteStatusLoadResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzG(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Notifications.GameMuteStatusChangeResult> zzaGN;

        GameMuteStatusChangedBinderCallback(zzaad.zzb<Notifications.GameMuteStatusChangeResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.zzaGN.setResult((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zzabh<RealTimeMultiplayer.ReliableMessageSentCallback> zzbaJ;

        public RealTimeReliableMessageBinderCallbacks(zzabh<RealTimeMultiplayer.ReliableMessageSentCallback> zzabh2) {
            this.zzbaJ = zzabh2;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.zzbaJ != null) {
                this.zzbaJ.zza((zzabh.zzc)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzabh<? extends RoomUpdateListener> zzbaP;
        private final zzabh<? extends RoomStatusUpdateListener> zzbaQ;
        private final zzabh<RealTimeMessageReceivedListener> zzbaR;

        public RoomBinderCallbacks(zzabh<RoomUpdateListener> zzabh2) {
            this.zzbaP = (zzabh)zzac.zzb(zzabh2, (Object)"Callbacks must not be null");
            this.zzbaQ = null;
            this.zzbaR = null;
        }

        public RoomBinderCallbacks(zzabh<? extends RoomUpdateListener> zzabh2, zzabh<? extends RoomStatusUpdateListener> zzabh3, zzabh<RealTimeMessageReceivedListener> zzabh4) {
            this.zzbaP = (zzabh)zzac.zzb(zzabh2, (Object)"Callbacks must not be null");
            this.zzbaQ = zzabh3;
            this.zzbaR = zzabh4;
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            this.zzbaP.zza((zzabh.zzc)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzA(DataHolder dataHolder) {
            this.zzbaP.zza((zzabh.zzc)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int n, String string) {
            this.zzbaP.zza((zzabh.zzc)new LeftRoomNotifier(n, string));
        }

        @Override
        public void zzD(DataHolder dataHolder) {
            this.zzbaP.zza((zzabh.zzc)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzB(DataHolder dataHolder) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzC(DataHolder dataHolder) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzE(DataHolder dataHolder) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzF(DataHolder dataHolder) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String string) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new P2PConnectedNotifier(string));
            }
        }

        @Override
        public void onP2PDisconnected(String string) {
            if (this.zzbaQ != null) {
                this.zzbaQ.zza((zzabh.zzc)new P2PDisconnectedNotifier(string));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.zzbaR != null) {
                this.zzbaR.zza((zzabh.zzc)new MessageReceivedNotifier(realTimeMessage));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<TurnBasedMultiplayer.CancelMatchResult> zzbaX;

        public TurnBasedMatchCanceledBinderCallbacks(zzaad.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2) {
            this.zzbaX = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(int n, String string) {
            Status status = GamesStatusCodes.zzik(n);
            this.zzbaX.setResult((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzbaZ;

        public TurnBasedMatchLeftBinderCallbacks(zzaad.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2) {
            this.zzbaZ = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            this.zzbaZ.setResult((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzbbb;

        public TurnBasedMatchUpdatedBinderCallbacks(zzaad.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2) {
            this.zzbbb = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzw(DataHolder dataHolder) {
            this.zzbbb.setResult((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzbaY;

        public TurnBasedMatchInitiatedBinderCallbacks(zzaad.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2) {
            this.zzbaY = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.zzbaY.setResult((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<TurnBasedMultiplayer.LoadMatchResult> zzbba;

        public TurnBasedMatchLoadedBinderCallbacks(zzaad.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2) {
            this.zzbba = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.zzbba.setResult((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzbbc;

        public TurnBasedMatchesLoadedBinderCallbacks(zzaad.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2) {
            this.zzbbc = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzik(n);
            this.zzbbc.setResult((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Leaderboards.SubmitScoreResult> zzaGN;

        public SubmitScoreBinderCallbacks(zzaad.zzb<Leaderboards.SubmitScoreResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class UpdateProfileDiscoverabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Status> zzaGN;

        UpdateProfileDiscoverabilityBinderCallback(zzaad.zzb<Status> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zziD(int n) {
            this.zzaGN.setResult((Object)new Status(n));
        }
    }

    private static final class UpdateAutoSignInBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Status> zzaGN;

        UpdateAutoSignInBinderCallback(zzaad.zzb<Status> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zziC(int n) {
            this.zzaGN.setResult((Object)new Status(n));
        }
    }

    private static final class DeletePlayerBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Status> zzaGN;

        DeletePlayerBinderCallback(zzaad.zzb<Status> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zziB(int n) {
            this.zzaGN.setResult((Object)new Status(n));
        }
    }

    private static final class GamerProfileUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Players.UpdateGamerProfileResult> zzaGN;

        GamerProfileUpdatedBinderCallback(zzaad.zzb<Players.UpdateGamerProfileResult> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zzh(int n, Bundle bundle) {
            this.zzaGN.setResult((Object)new UpdateGamerProfileResultImpl(n, bundle));
        }
    }

    private static final class StockProfileImagesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Players.LoadStockProfileImagesResult> zzaGN;

        StockProfileImagesLoadedBinderCallback(zzaad.zzb<Players.LoadStockProfileImagesResult> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zzY(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadStockProfileImagesResultImpl(dataHolder));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Status> zzaGN;

        ProfileSettingsUpdatedBinderCallback(zzaad.zzb<Status> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zziy(int n) {
            this.zzaGN.setResult((Object)GamesStatusCodes.zzik(n));
        }
    }

    private static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Players.LoadProfileSettingsResult> zzaGN;

        ProfileSettingsLoadedBinderCallback(zzaad.zzb<Players.LoadProfileSettingsResult> zzb2) {
            this.zzaGN = zzb2;
        }

        @Override
        public void zzV(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new ProfileSettingsEntity(dataHolder));
            dataHolder.close();
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Players.LoadXpStreamResult> zzaGN;

        PlayerXpStreamLoadedBinderCallback(zzaad.zzb<Players.LoadXpStreamResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzU(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Players.LoadXpForGameCategoriesResult> zzaGN;

        PlayerXpForGameCategoriesLoadedBinderCallback(zzaad.zzb<Players.LoadXpForGameCategoriesResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzik(n);
            this.zzaGN.setResult((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class InvitesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Social.LoadInvitesResult> zzaGN;

        InvitesLoadedBinderCallback(zzaad.zzb<Social.LoadInvitesResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzah(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadInvitesResultImpl(dataHolder));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Players.LoadPlayersResult> zzaGN;

        PlayersLoadedBinderCallback(zzaad.zzb<Players.LoadPlayersResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzm(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class SocialInviteUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzab(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzabh.zzc)new SocialInviteUpdateReceivedNotifier(socialInvite));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzac(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzabh.zzc)new SocialInviteRemovedNotifier(socialInvite));
            }
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzabh<OnRequestReceivedListener> zzaNm;

        RequestReceivedBinderCallback(zzabh<OnRequestReceivedListener> zzabh2) {
            this.zzaNm = zzabh2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzt(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzaNm.zza((zzabh.zzc)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String string) {
            this.zzaNm.zza((zzabh.zzc)new RequestRemovedNotifier(string));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzabh<QuestUpdateListener> zzaNm;

        QuestUpdateBinderCallback(zzabh<QuestUpdateListener> zzabh2) {
            this.zzaNm = zzabh2;
        }

        @Override
        public void zzR(DataHolder dataHolder) {
            Quest quest = this.zzak(dataHolder);
            if (quest != null) {
                this.zzaNm.zza((zzabh.zzc)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzak(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzabh<OnTurnBasedMatchUpdateReceivedListener> zzaNm;

        MatchUpdateReceivedBinderCallback(zzabh<OnTurnBasedMatchUpdateReceivedListener> zzabh2) {
            this.zzaNm = zzabh2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzy(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzaNm.zza((zzabh.zzc)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String string) {
            this.zzaNm.zza((zzabh.zzc)new MatchRemovedNotifier(string));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzabh<OnInvitationReceivedListener> zzaNm;

        InvitationReceivedBinderCallback(zzabh<OnInvitationReceivedListener> zzabh2) {
            this.zzaNm = zzabh2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzs(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzaNm.zza((zzabh.zzc)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String string) {
            this.zzaNm.zza((zzabh.zzc)new InvitationRemovedNotifier(string));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Invitations.LoadInvitationsResult> zzaGN;

        InvitationsLoadedBinderCallback(zzaad.zzb<Invitations.LoadInvitationsResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzr(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Leaderboards.LoadPlayerScoreResult> zzaGN;

        PlayerLeaderboardScoreLoadedBinderCallback(zzaad.zzb<Leaderboards.LoadPlayerScoreResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzJ(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Leaderboards.LoadScoresResult> zzaGN;

        LeaderboardScoresLoadedBinderCallback(zzaad.zzb<Leaderboards.LoadScoresResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzaGN.setResult((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Leaderboards.LeaderboardMetadataResult> zzaGN;

        LeaderboardsLoadedBinderCallback(zzaad.zzb<Leaderboards.LeaderboardMetadataResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzaGN;

        GameSearchSuggestionsLoadedBinderCallback(zzaad.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzq(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<GamesMetadata.LoadGameInstancesResult> zzaGN;

        GameInstancesLoadedBinderCallback(zzaad.zzb<GamesMetadata.LoadGameInstancesResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Events.LoadEventsResult> zzaGN;

        EventsLoadedBinderCallback(zzaad.zzb<Events.LoadEventsResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<GamesMetadata.LoadGamesResult> zzaGN;

        GamesLoadedBinderCallback(zzaad.zzb<GamesMetadata.LoadGamesResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzn(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Achievements.UpdateAchievementResult> zzaGN;

        AchievementUpdatedBinderCallback(zzaad.zzb<Achievements.UpdateAchievementResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            this.zzaGN.setResult((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaad.zzb<Achievements.LoadAchievementsResult> zzaGN;

        AchievementsLoadedBinderCallback(zzaad.zzb<Achievements.LoadAchievementsResult> zzb2) {
            this.zzaGN = (zzaad.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.zzaGN.setResult((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzr(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zzxD()).zzo(string, n);
                } else {
                    GamesLog.zzG("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                }
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.this.zzd(remoteException);
            }
        }
    }
}

