/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.player;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.internal.player.ProfileSettingsEntityCreator;
import com.google.android.gms.games.internal.player.StockProfileImage;
import com.google.android.gms.games.internal.player.StockProfileImageEntity;

public class ProfileSettingsEntity
extends GamesAbstractSafeParcelable
implements Players.LoadProfileSettingsResult {
    public static final Parcelable.Creator<ProfileSettingsEntity> CREATOR = new ProfileSettingsEntityCreator();
    private final Status zzair;
    private final String zzaYp;
    private final boolean zzbdr;
    private final boolean zzaYn;
    private final boolean zzbds;
    private final StockProfileImageEntity zzbdt;
    private final boolean zzbdu;
    private final boolean zzbdv;

    public ProfileSettingsEntity(DataHolder dataHolder) {
        this.zzair = new Status(dataHolder.getStatusCode());
        if (this.zzair.isSuccess() && dataHolder.getCount() > 0) {
            int n = dataHolder.zzcI(0);
            this.zzaYp = dataHolder.zzd("gamer_tag", 0, n);
            this.zzbdr = dataHolder.zze("gamer_tag_explicitly_set", 0, n);
            this.zzaYn = dataHolder.zze("profile_visible", 0, n);
            this.zzbds = dataHolder.zze("profile_visibility_explicitly_set", 0, n);
            String string = dataHolder.zzd("stock_avatar_url", 0, n);
            String string2 = dataHolder.zzd("stock_avatar_uri", 0, n);
            this.zzbdt = !TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) ? new StockProfileImageEntity(string, Uri.parse((String)string2)) : null;
            this.zzbdu = dataHolder.zze("profile_discoverable", 0, n);
            this.zzbdv = dataHolder.zze("auto_sign_in", 0, n);
        } else {
            this.zzaYp = null;
            this.zzbdr = false;
            this.zzaYn = false;
            this.zzbds = false;
            this.zzbdt = null;
            this.zzbdu = false;
            this.zzbdv = false;
        }
    }

    ProfileSettingsEntity(Status status, String string, boolean bl, boolean bl2, boolean bl3, StockProfileImageEntity stockProfileImageEntity, boolean bl4, boolean bl5) {
        this.zzair = status;
        this.zzaYp = string;
        this.zzbdr = bl;
        this.zzaYn = bl2;
        this.zzbds = bl3;
        this.zzbdt = stockProfileImageEntity;
        this.zzbdu = bl4;
        this.zzbdv = bl5;
    }

    @Override
    public String zzDQ() {
        return this.zzaYp;
    }

    @Override
    public boolean zzEa() {
        return this.zzbdr;
    }

    @Override
    public boolean zzDT() {
        return this.zzaYn;
    }

    @Override
    public boolean zzDY() {
        return this.zzbds;
    }

    @Override
    public StockProfileImage zzDZ() {
        return this.zzbdt;
    }

    @Override
    public boolean zzEb() {
        return this.zzbdu;
    }

    @Override
    public boolean zzEc() {
        return this.zzbdv;
    }

    public Status getStatus() {
        return this.zzair;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaYp, this.zzbdr, this.zzaYn, this.zzbds, this.zzair, this.zzbdt, this.zzbdu, this.zzbdv});
    }

    public boolean equals(Object object) {
        if (!(object instanceof Players.LoadProfileSettingsResult)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Players.LoadProfileSettingsResult loadProfileSettingsResult = (Players.LoadProfileSettingsResult)object;
        return zzaa.equal((Object)this.zzaYp, (Object)loadProfileSettingsResult.zzDQ()) && zzaa.equal((Object)this.zzbdr, (Object)loadProfileSettingsResult.zzEa()) && zzaa.equal((Object)this.zzaYn, (Object)loadProfileSettingsResult.zzDT()) && zzaa.equal((Object)this.zzbds, (Object)loadProfileSettingsResult.zzDY()) && zzaa.equal((Object)this.zzair, (Object)loadProfileSettingsResult.getStatus()) && zzaa.equal((Object)this.zzbdt, (Object)loadProfileSettingsResult.zzDZ()) && zzaa.equal((Object)this.zzbdu, (Object)loadProfileSettingsResult.zzEb()) && zzaa.equal((Object)this.zzbdv, (Object)loadProfileSettingsResult.zzEc());
    }

    public String toString() {
        return zzaa.zzv((Object)this).zzg("GamerTag", (Object)this.zzaYp).zzg("IsGamerTagExplicitlySet", (Object)this.zzbdr).zzg("IsProfileVisible", (Object)this.zzaYn).zzg("IsVisibilityExplicitlySet", (Object)this.zzbds).zzg("Status", (Object)this.zzair).zzg("StockProfileImage", (Object)this.zzbdt).zzg("IsProfileDiscoverable", (Object)this.zzbdu).zzg("AutoSignIn", (Object)this.zzbdv).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        ProfileSettingsEntityCreator.zza(this, parcel, n);
    }
}

