/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
extends GamesAbstractSafeParcelable
implements TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new TurnBasedMatchEntityCreator();
    private final GameEntity zzbcv;
    private final String zzbau;
    private final String zzbeA;
    private final long mCreationTimestamp;
    private final String zzbeI;
    private final long zzaYP;
    private final String zzbeJ;
    private final int zzbeK;
    private final int zzbei;
    private final int mVersion;
    private final byte[] zzbeL;
    private final ArrayList<ParticipantEntity> zzbeh;
    private final String zzbeM;
    private final byte[] zzbeN;
    private final int zzbeO;
    private final Bundle zzbey;
    private final int zzbeP;
    private final boolean zzbeQ;
    private final String zzade;
    private final String zzbeR;

    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        this.zzbcv = new GameEntity(turnBasedMatch.getGame());
        this.zzbau = turnBasedMatch.getMatchId();
        this.zzbeA = turnBasedMatch.getCreatorId();
        this.mCreationTimestamp = turnBasedMatch.getCreationTimestamp();
        this.zzbeI = turnBasedMatch.getLastUpdaterId();
        this.zzaYP = turnBasedMatch.getLastUpdatedTimestamp();
        this.zzbeJ = turnBasedMatch.getPendingParticipantId();
        this.zzbeK = turnBasedMatch.getStatus();
        this.zzbeP = turnBasedMatch.getTurnStatus();
        this.zzbei = turnBasedMatch.getVariant();
        this.mVersion = turnBasedMatch.getVersion();
        this.zzbeM = turnBasedMatch.getRematchId();
        this.zzbeO = turnBasedMatch.getMatchNumber();
        this.zzbey = turnBasedMatch.getAutoMatchCriteria();
        this.zzbeQ = turnBasedMatch.isLocallyModified();
        this.zzade = turnBasedMatch.getDescription();
        this.zzbeR = turnBasedMatch.getDescriptionParticipantId();
        byte[] byArray = turnBasedMatch.getData();
        if (byArray == null) {
            this.zzbeL = null;
        } else {
            this.zzbeL = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzbeL, 0, byArray.length);
        }
        byte[] byArray2 = turnBasedMatch.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzbeN = null;
        } else {
            this.zzbeN = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzbeN, 0, byArray2.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        this.zzbeh = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzbeh.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(GameEntity gameEntity, String string, String string2, long l, String string3, long l2, String string4, int n, int n2, int n3, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string5, byte[] byArray2, int n4, Bundle bundle, int n5, boolean bl, String string6, String string7) {
        this.zzbcv = gameEntity;
        this.zzbau = string;
        this.zzbeA = string2;
        this.mCreationTimestamp = l;
        this.zzbeI = string3;
        this.zzaYP = l2;
        this.zzbeJ = string4;
        this.zzbeK = n;
        this.zzbeP = n5;
        this.zzbei = n2;
        this.mVersion = n3;
        this.zzbeL = byArray;
        this.zzbeh = arrayList;
        this.zzbeM = string5;
        this.zzbeN = byArray2;
        this.zzbeO = n4;
        this.zzbey = bundle;
        this.zzbeQ = bl;
        this.zzade = string6;
        this.zzbeR = string7;
    }

    @Override
    public Game getGame() {
        return this.zzbcv;
    }

    @Override
    public String getMatchId() {
        return this.zzbau;
    }

    @Override
    public String getCreatorId() {
        return this.zzbeA;
    }

    @Override
    public long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public String getLastUpdaterId() {
        return this.zzbeI;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaYP;
    }

    @Override
    public String getPendingParticipantId() {
        return this.zzbeJ;
    }

    @Override
    public int getStatus() {
        return this.zzbeK;
    }

    @Override
    public int getTurnStatus() {
        return this.zzbeP;
    }

    @Override
    public String getDescription() {
        return this.zzade;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.zzbeR;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzade, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public int getVariant() {
        return this.zzbei;
    }

    @Override
    public byte[] getData() {
        return this.zzbeL;
    }

    @Override
    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String getRematchId() {
        return this.zzbeM;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.zzbeN;
    }

    @Override
    public int getMatchNumber() {
        return this.zzbeO;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzbey;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.zzbey == null) {
            return 0;
        }
        return this.zzbey.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.zzbeK == 2 && this.zzbeM == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.zzbeQ;
    }

    @Override
    public int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzbeh);
    }

    public TurnBasedMatch freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return zzaa.hashCode((Object[])new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzaa.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzaa.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzaa.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzaa.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzaa.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzaa.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzaa.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzaa.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzaa.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzaa.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzaa.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzaa.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzaa.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzaa.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzaa.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzaa.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzaa.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzaa.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzaa.zzv((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        TurnBasedMatchEntityCreator.zza(this, parcel, n);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }
}

