/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.video.VideoCapabilitiesCreator;
import com.google.android.gms.games.video.VideoConfiguration;

public final class VideoCapabilities
extends GamesAbstractSafeParcelable {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new VideoCapabilitiesCreator();
    private final boolean zzbfS;
    private final boolean zzbfT;
    private final boolean zzbfU;
    private final boolean[] zzbfV;
    private final boolean[] zzbfW;

    public VideoCapabilities(boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.zzbfS = bl;
        this.zzbfT = bl2;
        this.zzbfU = bl3;
        this.zzbfV = blArray;
        this.zzbfW = blArray2;
    }

    public boolean isMicSupported() {
        return this.zzbfT;
    }

    public boolean isCameraSupported() {
        return this.zzbfS;
    }

    public boolean isWriteStorageSupported() {
        return this.zzbfU;
    }

    public boolean[] getSupportedCaptureModes() {
        return this.zzbfV;
    }

    public boolean[] getSupportedQualityLevels() {
        return this.zzbfW;
    }

    public boolean supportsCaptureMode(int n) {
        zzac.zzav((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.zzbfV[n];
    }

    public boolean supportsQualityLevel(int n) {
        zzac.zzav((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.zzbfW[n];
    }

    public boolean isFullySupported(int n, int n2) {
        return this.zzbfS && this.zzbfT && this.zzbfU && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.getSupportedCaptureModes(), this.getSupportedQualityLevels(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzaa.equal((Object)videoCapabilities.getSupportedCaptureModes(), (Object)this.getSupportedCaptureModes()) && zzaa.equal((Object)videoCapabilities.getSupportedQualityLevels(), (Object)this.getSupportedQualityLevels()) && zzaa.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzaa.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzaa.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.getSupportedCaptureModes()).zzg("SupportedQualityLevels", (Object)this.getSupportedQualityLevels()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoCapabilitiesCreator.zza(this, parcel, n);
    }
}

