/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzbcl;
import com.google.android.gms.internal.zzbdj;
import com.google.android.gms.internal.zzbdk;
import com.google.android.gms.internal.zzbfi;
import com.google.android.gms.internal.zzbfl;
import com.google.android.gms.internal.zzcbv;
import com.google.android.gms.internal.zzcbx;
import com.google.android.gms.internal.zzcby;
import com.google.android.gms.internal.zzcvg;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends com.google.android.gms.common.internal.zzaa<com.google.android.gms.games.internal.zzj> {
    private zzcbx zzaZt = new com.google.android.gms.games.internal.zzd(this);
    private final String zzaZu;
    private PlayerEntity zzaZv;
    private GameEntity zzaZw;
    private final com.google.android.gms.games.internal.zzn zzaZx;
    private boolean zzaZy = false;
    private final Binder zzaZz;
    private final long zzaZA;
    private final Games.GamesOptions zzaZB;
    private boolean zzaZC = false;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzq zzq2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzaZu = zzq2.zzro();
        this.zzaZz = new Binder();
        int n = zzq2.zzrk();
        GamesClientImpl gamesClientImpl = this;
        this.zzaZx = new com.google.android.gms.games.internal.zzq(gamesClientImpl, n);
        this.zzaZA = ((Object)((Object)this)).hashCode();
        this.zzaZB = gamesOptions;
        if (!this.zzaZB.zzaYG) {
            this.zzs(zzq2.zzrq());
        }
    }

    public final boolean zzmt() {
        return true;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzaZy = false;
    }

    public final void zzaZ(int n) {
        int n2;
        this.zzaZx.zzbaP.gravity = n2 = n;
    }

    public final void zzs(View view) {
        this.zzaZx.zzt(view);
    }

    protected final Set<Scope> zzb(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            com.google.android.gms.common.internal.zzbr.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            com.google.android.gms.common.internal.zzbr.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public final void zza(com.google.android.gms.common.internal.zzj zzj2) {
        GamesClientImpl gamesClientImpl = this;
        this.zzaZv = null;
        gamesClientImpl.zzaZw = null;
        super.zza(zzj2);
    }

    public final void disconnect() {
        this.zzaZy = false;
        if (this.isConnected()) {
            try {
                com.google.android.gms.games.internal.zzj zzj2 = (com.google.android.gms.games.internal.zzj)this.zzrd();
                zzj2.zzuO();
                this.zzaZt.flush();
                zzj2.zzC(this.zzaZA);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.games.internal.zze.zzy("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected final String zzda() {
        return "com.google.android.gms.games.service.START";
    }

    protected final String zzdb() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    public final Bundle zzoA() {
        try {
            Bundle bundle = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzoA();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    protected final Bundle zzmm() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzaZB.zzuh();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzaZu);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzaZx.zzbaP.zzbaQ));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 6);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzcvg.zza((com.google.android.gms.common.internal.zzq)this.zzrx()));
        return bundle;
    }

    public final String zzur() {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzur();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzb(String string, zzbcl<Games.GetServerAuthCodeResult> zzbcl2) throws RemoteException {
        com.google.android.gms.common.internal.zzbr.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza(string, new zzy(zzbcl2));
    }

    public final String zzah(boolean bl) {
        if (this.zzaZv != null) {
            return this.zzaZv.getPlayerId();
        }
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuQ();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Player zzus() {
        this.zzrc();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaZv == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuR());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzaZv = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesClientImpl.zzd(remoteException);
                }
            }
        }
        return this.zzaZv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Game zzut() {
        this.zzrc();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaZw == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuS());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzaZw = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesClientImpl.zzd(remoteException);
                }
            }
        }
        return this.zzaZw;
    }

    public final void zza(zzbcl<Players.LoadPlayersResult> zzbcl2, String string, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb((com.google.android.gms.games.internal.zzf)new zzbn(zzbcl2), string, bl);
    }

    public final void zza(zzbcl<Players.LoadPlayersResult> zzbcl2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzbn(zzbcl2), n, bl, bl2);
    }

    public final void zza(zzbcl<Players.LoadPlayersResult> zzbcl2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzbn(zzbcl2), string, n, bl, bl2);
    }

    public final void zza(zzbcl<Players.LoadPlayersResult> zzbcl2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzc((com.google.android.gms.games.internal.zzf)new zzbn(zzbcl2), bl);
    }

    public final Intent zzuu() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuu();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzj(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzk(string, n, n2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzb(zzbcl<Leaderboards.LeaderboardMetadataResult> zzbcl2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb((com.google.android.gms.games.internal.zzf)new zzai(zzbcl2), bl);
    }

    public final void zzb(zzbcl<Leaderboards.LeaderboardMetadataResult> zzbcl2, String string, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzai(zzbcl2), string, bl);
    }

    public final void zza(zzbcl<Leaderboards.LoadPlayerScoreResult> zzbcl2, String string, String string2, int n, int n2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzbl(zzbcl2), null, string2, n, n2);
    }

    public final void zza(zzbcl<Leaderboards.LoadScoresResult> zzbcl2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza(new zzah(zzbcl2), string, n, n2, n3, bl);
    }

    public final void zzb(zzbcl<Leaderboards.LoadScoresResult> zzbcl2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb(new zzah(zzbcl2), string, n, n2, n3, bl);
    }

    public final void zza(zzbcl<Leaderboards.LoadScoresResult> zzbcl2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzah(zzbcl2), leaderboardScoreBuffer.zzvm().asBundle(), n, n2);
    }

    public final void zza(zzbcl<Leaderboards.SubmitScoreResult> zzbcl2, String string, long l, String string2) throws RemoteException {
        zzcl zzcl2 = zzbcl2 == null ? null : new zzcl(zzbcl2);
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)zzcl2, string, l, string2);
    }

    public final Intent zzuv() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuv();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzc(zzbcl<Achievements.LoadAchievementsResult> zzbcl2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzf(zzbcl2), bl);
    }

    public final void zza(zzbcl<Achievements.UpdateAchievementResult> zzbcl2, String string) throws RemoteException {
        zze zze2 = zzbcl2 == null ? null : new zze(zzbcl2);
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)zze2, string, this.zzaZx.zzbaP.zzbaQ, this.zzaZx.zzbaP.zzuV());
    }

    public final void zzb(zzbcl<Achievements.UpdateAchievementResult> zzbcl2, String string) throws RemoteException {
        zze zze2 = zzbcl2 == null ? null : new zze(zzbcl2);
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb(zze2, string, this.zzaZx.zzbaP.zzbaQ, this.zzaZx.zzbaP.zzuV());
    }

    public final void zza(zzbcl<Achievements.UpdateAchievementResult> zzbcl2, String string, int n) throws RemoteException {
        zze zze2 = zzbcl2 == null ? null : new zze(zzbcl2);
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)zze2, string, n, this.zzaZx.zzbaP.zzbaQ, this.zzaZx.zzbaP.zzuV());
    }

    public final void zzb(zzbcl<Achievements.UpdateAchievementResult> zzbcl2, String string, int n) throws RemoteException {
        zze zze2 = zzbcl2 == null ? null : new zze(zzbcl2);
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb(zze2, string, n, this.zzaZx.zzbaP.zzbaQ, this.zzaZx.zzbaP.zzuV());
    }

    public final void zzd(zzbcl<Events.LoadEventsResult> zzbcl2, boolean bl) throws RemoteException {
        this.zzaZt.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zze((com.google.android.gms.games.internal.zzf)new zzu(zzbcl2), bl);
    }

    public final void zza(zzbcl<Events.LoadEventsResult> zzbcl2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzaZt.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzu(zzbcl2), bl, stringArray);
    }

    public final void zzn(String string, int n) {
        this.zzaZt.zzn(string, n);
    }

    public final Intent zzuw() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuw();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzux() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzux();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(zzbfi<OnInvitationReceivedListener> zzbfi2) {
        try {
            zzab zzab2 = new zzab(zzbfi2);
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)zzab2, this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzuy() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzD(this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzb(zzbfi<OnTurnBasedMatchUpdateReceivedListener> zzbfi2) {
        try {
            zzaz zzaz2 = new zzaz(zzbfi2);
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb((com.google.android.gms.games.internal.zzf)zzaz2, this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzuz() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzE(this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzc(zzbfi<QuestUpdateListener> zzbfi2) {
        try {
            zzbs zzbs2 = new zzbs(zzbfi2);
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzd((com.google.android.gms.games.internal.zzf)zzbs2, this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzuA() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzG(this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzd(zzbfi<OnRequestReceivedListener> zzbfi2) {
        try {
            zzbw zzbw2 = new zzbw(zzbfi2);
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzc((com.google.android.gms.games.internal.zzf)zzbw2, this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzuB() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzF(this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzuC() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuC();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzuD() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuD();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzf(zzbcl<GamesMetadata.LoadGamesResult> zzbcl2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb(new zzx(zzbcl2));
    }

    public final void zzg(zzbcl<Status> zzbcl2) throws RemoteException {
        this.zzaZt.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza(new zzcg(zzbcl2));
    }

    public final int zzuE() {
        int n = 4368;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuE();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final String zzhk() {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzhk();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(zzbcl<Invitations.LoadInvitationsResult> zzbcl2, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzae(zzbcl2), n);
    }

    public final void zzo(String string, int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzo(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzp(String string, int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzp(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(zzbcl<TurnBasedMultiplayer.InitiateMatchResult> zzbcl2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzco(zzbcl2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzvr(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public final void zzc(zzbcl<TurnBasedMultiplayer.InitiateMatchResult> zzbcl2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb((com.google.android.gms.games.internal.zzf)new zzco(zzbcl2), string);
    }

    public final void zzd(zzbcl<TurnBasedMultiplayer.InitiateMatchResult> zzbcl2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzc((com.google.android.gms.games.internal.zzf)new zzco(zzbcl2), string);
    }

    public final int zzuF() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuF();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final void zza(zzbcl<TurnBasedMultiplayer.UpdateMatchResult> zzbcl2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzcs(zzbcl2), string, byArray, string2, participantResultArray);
    }

    public final void zza(zzbcl<TurnBasedMultiplayer.UpdateMatchResult> zzbcl2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzcs(zzbcl2), string, byArray, participantResultArray);
    }

    public final void zze(zzbcl<TurnBasedMultiplayer.LeaveMatchResult> zzbcl2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zze((com.google.android.gms.games.internal.zzf)new zzcp(zzbcl2), string);
    }

    public final void zza(zzbcl<TurnBasedMultiplayer.LeaveMatchResult> zzbcl2, String string, String string2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzcp(zzbcl2), string, string2);
    }

    public final void zzf(zzbcl<TurnBasedMultiplayer.CancelMatchResult> zzbcl2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzd((com.google.android.gms.games.internal.zzf)new zzcn(zzbcl2), string);
    }

    public final void zzdk(String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzdn(string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(zzbcl<TurnBasedMultiplayer.LoadMatchesResult> zzbcl2, int n, int[] nArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzct(zzbcl2), n, nArray);
    }

    public final void zzg(zzbcl<TurnBasedMultiplayer.LoadMatchResult> zzbcl2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzf((com.google.android.gms.games.internal.zzf)new zzcq(zzbcl2), string);
    }

    public final Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(zzbfi<RoomUpdateListener> zzbfi2, zzbfi<RoomStatusUpdateListener> zzbfi3, zzbfi<RealTimeMessageReceivedListener> zzbfi4, RoomConfig roomConfig) {
        try {
            zzcc zzcc2 = new zzcc(zzbfi2, zzbfi3, zzbfi4);
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza(zzcc2, (IBinder)this.zzaZz, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzb(zzbfi<RoomUpdateListener> zzbfi2, zzbfi<RoomStatusUpdateListener> zzbfi3, zzbfi<RealTimeMessageReceivedListener> zzbfi4, RoomConfig roomConfig) {
        try {
            zzcc zzcc2 = new zzcc(zzbfi2, zzbfi3, zzbfi4);
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)zzcc2, (IBinder)this.zzaZz, roomConfig.getInvitationId(), false, this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(zzbfi<RoomUpdateListener> zzbfi2, String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzcc(zzbfi2), string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zza(zzbfi<RealTimeMultiplayer.ReliableMessageSentCallback> zzbfi2, byte[] byArray, String string, String string2) {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzbv(zzbfi2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zza(byte[] byArray, String string, String[] stringArray) {
        com.google.android.gms.common.internal.zzbr.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zzc(byte[] byArray, String string) {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final void zzba(int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzba(n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzuG() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuG();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza(n, byArray, n2, string);
            com.google.android.gms.common.internal.zzbr.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final int zzuH() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuH();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final int zzuI() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuI();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final void zza(zzbcl<Requests.UpdateRequestsResult> zzbcl2, String[] stringArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzca(zzbcl2), stringArray);
    }

    public final void zzb(zzbcl<Requests.UpdateRequestsResult> zzbcl2, String[] stringArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb((com.google.android.gms.games.internal.zzf)new zzca(zzbcl2), stringArray);
    }

    public final void zza(zzbcl<Requests.LoadRequestsResult> zzbcl2, int n, int n2, int n3) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzbz(zzbcl2), n, n2, n3);
    }

    public final void zze(zzbcl<Stats.LoadPlayerStatsResult> zzbcl2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzf((com.google.android.gms.games.internal.zzf)new zzbm(zzbcl2), bl);
    }

    public final Intent zzb(int[] nArray) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb(nArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzdl(String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzdl(string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzh(zzbcl<Quests.AcceptQuestResult> zzbcl2, String string) throws RemoteException {
        this.zzaZt.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzh(new zzbp(zzbcl2), string);
    }

    public final void zzb(zzbcl<Quests.ClaimMilestoneResult> zzbcl2, String string, String string2) throws RemoteException {
        this.zzaZt.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb((com.google.android.gms.games.internal.zzf)new zzbr(zzbcl2, string2), string, string2);
    }

    public final void zza(zzbcl<Quests.LoadQuestsResult> zzbcl2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaZt.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzbt(zzbcl2), nArray, n, bl);
    }

    public final void zzb(zzbcl<Quests.LoadQuestsResult> zzbcl2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaZt.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzbt(zzbcl2), stringArray, bl);
    }

    public final void zzdm(String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza(string, this.zzaZx.zzbaP.zzbaQ, this.zzaZx.zzbaP.zzuV());
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zzuJ() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuJ();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final int zzuK() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuK();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzf(zzbcl<Snapshots.LoadSnapshotsResult> zzbcl2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzd((com.google.android.gms.games.internal.zzf)new zzck(zzbcl2), bl);
    }

    public final void zza(zzbcl<Snapshots.OpenSnapshotResult> zzbcl2, String string, boolean bl, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzcj(zzbcl2), string, bl, n);
    }

    public final void zza(zzbcl<Snapshots.CommitSnapshotResult> zzbcl2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbr.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzvu();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzsL();
        snapshotContents.close();
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzch(zzbcl2), snapshot.getMetadata().getSnapshotId(), (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
    }

    public final void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbr.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzsL();
        snapshotContents.close();
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza(zzc2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzi(zzbcl<Snapshots.DeleteSnapshotResult> zzbcl2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzg(new zzci(zzbcl2), string);
    }

    public final void zza(zzbcl<Snapshots.OpenSnapshotResult> zzbcl2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        com.google.android.gms.common.internal.zzbr.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzvu();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzsL();
        snapshotContents.close();
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza((com.google.android.gms.games.internal.zzf)new zzcj(zzbcl2), string, string2, (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
    }

    public final void zzh(zzbcl<Videos.CaptureCapabilitiesResult> zzbcl2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzc(new zzj(zzbcl2));
    }

    public final Intent zzuL() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuT();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzi(zzbcl<Videos.CaptureStateResult> zzbcl2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzd(new zzn(zzbcl2));
    }

    public final void zzb(zzbcl<Videos.CaptureAvailableResult> zzbcl2, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzb((com.google.android.gms.games.internal.zzf)new zzh(zzbcl2), n);
    }

    public final boolean zzuM() {
        boolean bl = false;
        try {
            bl = ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuM();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return bl;
    }

    public final void zze(zzbfi<Videos.CaptureOverlayStateListener> zzbfi2) {
        try {
            zzl zzl2 = new zzl(zzbfi2);
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zze((com.google.android.gms.games.internal.zzf)zzl2, this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzuN() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzH(this.zzaZA);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzj)this.zzrd()).zza(iBinder, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    public final void zzuO() {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzj)this.zzrd()).zzuO();
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    private static void zzd(RemoteException remoteException) {
        com.google.android.gms.games.internal.zze.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static Room zzK(DataHolder dataHolder) {
        com.google.android.gms.games.multiplayer.realtime.zzb zzb2 = new com.google.android.gms.games.multiplayer.realtime.zzb(dataHolder);
        Room room = null;
        try {
            if (zzb2.getCount() > 0) {
                room = (Room)((Room)zzb2.get(0)).freeze();
            }
        }
        finally {
            zzb2.release();
        }
        return room;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzaZC = this.zzaZy = bundle.getBoolean("show_welcome_popup");
            this.zzaZv = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzaZw = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final /* synthetic */ void zza(@NonNull IInterface iInterface) {
        com.google.android.gms.games.internal.zzj zzj2 = (com.google.android.gms.games.internal.zzj)iInterface;
        GamesClientImpl gamesClientImpl = this;
        super.zza((IInterface)zzj2);
        if (gamesClientImpl.zzaZy) {
            gamesClientImpl.zzaZx.zzuU();
            gamesClientImpl.zzaZy = false;
        }
        if (!gamesClientImpl.zzaZB.zzaYy && !gamesClientImpl.zzaZB.zzaYG) {
            com.google.android.gms.games.internal.zzj zzj3 = zzj2;
            GamesClientImpl gamesClientImpl2 = gamesClientImpl;
            try {
                zzbo zzbo2 = new zzbo(gamesClientImpl2.zzaZx);
                zzj3.zza(zzbo2, gamesClientImpl2.zzaZA);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.games.internal.IGamesService");
        if (iInterface instanceof com.google.android.gms.games.internal.zzj) {
            return (com.google.android.gms.games.internal.zzj)iInterface;
        }
        return new com.google.android.gms.games.internal.zzk(iBinder2);
    }

    static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final Status mStatus;
        private final String zzD;

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getUrl() {
            return this.zzD;
        }
    }

    static final class zzo
    implements Videos.CaptureStateResult {
        private final Status mStatus;
        private final CaptureState zzaZK;

        zzo(Status status, CaptureState captureState) {
            this.mStatus = status;
            this.zzaZK = captureState;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final CaptureState getCaptureState() {
            return this.zzaZK;
        }
    }

    static final class zzk
    implements Videos.CaptureCapabilitiesResult {
        private final Status mStatus;
        private final VideoCapabilities zzaZI;

        zzk(Status status, VideoCapabilities videoCapabilities) {
            this.mStatus = status;
            this.zzaZI = videoCapabilities;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final VideoCapabilities getCapabilities() {
            return this.zzaZI;
        }
    }

    static final class zzi
    implements Videos.CaptureAvailableResult {
        private final Status mStatus;
        private final boolean zzaZH;

        zzi(Status status, boolean bl) {
            this.mStatus = status;
            this.zzaZH = bl;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final boolean isAvailable() {
            return this.zzaZH;
        }
    }

    static final class zzs
    implements Snapshots.DeleteSnapshotResult {
        private final Status mStatus;
        private final String zzaZN;

        zzs(int n, String string) {
            this.mStatus = GamesStatusCodes.zzaY(n);
            this.zzaZN = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getSnapshotId() {
            return this.zzaZN;
        }
    }

    static final class zzq
    extends zzw
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzaZM;

        zzq(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzaZM = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
                return;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public final SnapshotMetadata getSnapshotMetadata() {
            return this.zzaZM;
        }
    }

    static final class zzbc
    extends zzw
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzbag;
        private final String zzbah;
        private final Snapshot zzbai;
        private final com.google.android.gms.drive.zzc zzbaj;
        private final SnapshotContents zzbak;

        zzbc(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this(dataHolder, null, zzc2, null, null);
        }

        zzbc(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzbag = null;
                    this.zzbai = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.zzc.zzae((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzbag = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    this.zzbai = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzbag = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.zzbai = new SnapshotEntity(snapshotMetadataEntity2, new com.google.android.gms.games.snapshot.zza(zzc3));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzbah = string;
            this.zzbaj = zzc4;
            this.zzbak = new com.google.android.gms.games.snapshot.zza(zzc4);
        }

        @Override
        public final Snapshot getSnapshot() {
            return this.zzbag;
        }

        @Override
        public final String getConflictId() {
            return this.zzbah;
        }

        @Override
        public final Snapshot getConflictingSnapshot() {
            return this.zzbai;
        }

        @Override
        public final SnapshotContents getResolutionSnapshotContents() {
            return this.zzbak;
        }
    }

    static final class zzax
    extends zzw
    implements Snapshots.LoadSnapshotsResult {
        zzax(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzaCZ);
        }
    }

    static final class zzas
    extends zzw
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzaZY;

        zzas(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzaZY = playerStatsBuffer.getCount() > 0 ? new com.google.android.gms.games.stats.zza((PlayerStats)playerStatsBuffer.get(0)) : null;
                return;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public final PlayerStats getPlayerStats() {
            return this.zzaZY;
        }
    }

    static final class zzp
    extends zzw
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzaZL;
        private final Quest zzaZF;

        zzp(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzaZF = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzaZF.zzvs();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.zzaZL = list.get(i);
                        return;
                    }
                    this.zzaZL = null;
                } else {
                    this.zzaZL = null;
                    this.zzaZF = null;
                }
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Milestone getMilestone() {
            return this.zzaZL;
        }

        @Override
        public final Quest getQuest() {
            return this.zzaZF;
        }
    }

    static final class zzd
    extends zzw
    implements Quests.AcceptQuestResult {
        private final Quest zzaZF;

        zzd(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzaZF = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Quest getQuest() {
            return this.zzaZF;
        }
    }

    static final class zzau
    extends zzw
    implements Quests.LoadQuestsResult {
        private final DataHolder zzaCZ;

        zzau(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaCZ = dataHolder;
        }

        @Override
        public final QuestBuffer getQuests() {
            return new QuestBuffer(this.zzaCZ);
        }
    }

    static final class zzav
    implements Requests.LoadRequestsResult {
        private final Status mStatus;
        private final Bundle zzbaa;

        zzav(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzbaa = bundle;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final GameRequestBuffer getRequests(int n) {
            String string;
            switch (n) {
                case 1: {
                    String string2 = "GIFT";
                    break;
                }
                case 2: {
                    String string2 = "WISH";
                    break;
                }
                default: {
                    com.google.android.gms.games.internal.zze.zzz("RequestType", new StringBuilder(33).append("Unknown request type: ").append(n).toString());
                    String string2 = string = "UNKNOWN_TYPE";
                }
            }
            if (!this.zzbaa.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzbaa.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public final void release() {
            for (String string : this.zzbaa.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzbaa.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    static final class zzcw
    extends zzw
    implements Requests.UpdateRequestsResult {
        private final zzcby zzbaJ;

        zzcw(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbaJ = zzcby.zzN(dataHolder);
        }

        @Override
        public final int getRequestOutcome(String string) {
            return this.zzbaJ.getRequestOutcome(string);
        }

        @Override
        public final Set<String> getRequestIds() {
            return this.zzbaJ.getRequestIds();
        }
    }

    static final class zzz
    implements Games.GetServerAuthCodeResult {
        private final Status mStatus;
        private final String zzaZO;

        zzz(Status status, String string) {
            this.mStatus = status;
            this.zzaZO = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getCode() {
            return this.zzaZO;
        }
    }

    static final class zzg
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status mStatus;
        private final String zzaZG;

        zzg(Status status, String string) {
            this.mStatus = status;
            this.zzaZG = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMatchId() {
            return this.zzaZG;
        }
    }

    static final class zzaj
    extends zzcr
    implements TurnBasedMultiplayer.LeaveMatchResult {
        zzaj(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzcv
    extends zzcr
    implements TurnBasedMultiplayer.UpdateMatchResult {
        zzcv(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzaa
    extends zzcr
    implements TurnBasedMultiplayer.InitiateMatchResult {
        zzaa(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzap
    extends zzcr
    implements TurnBasedMultiplayer.LoadMatchResult {
        zzap(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static abstract class zzcr
    extends zzw {
        private TurnBasedMatch zzbae;

        zzcr(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzbae = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzbae;
        }
    }

    static final class zzcm
    extends zzw
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzbaC;

        public zzcm(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzbaC = new ScoreSubmissionData(dataHolder);
                return;
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public final ScoreSubmissionData getScoreData() {
            return this.zzbaC;
        }
    }

    static final class zzat
    extends zzw
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzaZZ;

        zzat(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZZ = new PlayerBuffer(dataHolder);
        }

        @Override
        public final PlayerBuffer getPlayers() {
            return this.zzaZZ;
        }
    }

    static final class zzaq
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status mStatus;
        private final LoadMatchesResponse zzaZW;

        zzaq(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzaZW = new LoadMatchesResponse(bundle);
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final LoadMatchesResponse getMatches() {
            return this.zzaZW;
        }

        public final void release() {
            this.zzaZW.release();
        }
    }

    static final class zzao
    extends zzw
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzaZV;

        zzao(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZV = new InvitationBuffer(dataHolder);
        }

        @Override
        public final InvitationBuffer getInvitations() {
            return this.zzaZV;
        }
    }

    static final class zzar
    extends zzw
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzaZX;

        zzar(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.zzaZX = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public final LeaderboardScore getScore() {
            return this.zzaZX;
        }
    }

    static final class zzaw
    extends zzw
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzbab;
        private final LeaderboardScoreBuffer zzbac;

        zzaw(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.zzbab = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzbac = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public final Leaderboard getLeaderboard() {
            return this.zzbab;
        }

        @Override
        public final LeaderboardScoreBuffer getScores() {
            return this.zzbac;
        }
    }

    static final class zzag
    extends zzw
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzaZQ;

        zzag(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZQ = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public final LeaderboardBuffer getLeaderboards() {
            return this.zzaZQ;
        }
    }

    static final class zzan
    extends zzw
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzaZU;

        zzan(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZU = new GameBuffer(dataHolder);
        }

        @Override
        public final GameBuffer getGames() {
            return this.zzaZU;
        }
    }

    static final class zzam
    extends zzw
    implements Events.LoadEventsResult {
        private final EventBuffer zzaZT;

        zzam(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZT = new EventBuffer(dataHolder);
        }

        @Override
        public final EventBuffer getEvents() {
            return this.zzaZT;
        }
    }

    static final class zzcu
    implements Achievements.UpdateAchievementResult {
        private final Status mStatus;
        private final String zzaZf;

        zzcu(int n, String string) {
            this.mStatus = GamesStatusCodes.zzaY(n);
            this.zzaZf = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getAchievementId() {
            return this.zzaZf;
        }
    }

    static final class zzal
    extends zzw
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzaZS;

        zzal(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZS = new AchievementBuffer(dataHolder);
        }

        @Override
        public final AchievementBuffer getAchievements() {
            return this.zzaZS;
        }
    }

    static abstract class zzw
    extends zzbdk {
        protected zzw(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzaY(dataHolder.getStatusCode()));
        }
    }

    static final class zzbu
    implements zzbfl<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzaxw;
        private final String zzbaq;
        private final int zzbar;

        zzbu(int n, int n2, String string) {
            this.zzaxw = n;
            this.zzbar = n2;
            this.zzbaq = string;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback = (RealTimeMultiplayer.ReliableMessageSentCallback)object;
            zzbu zzbu2 = this;
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(zzbu2.zzaxw, zzbu2.zzbar, zzbu2.zzbaq);
            }
        }
    }

    static final class zzbb
    implements zzbfl<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzbaf;

        zzbb(RealTimeMessage realTimeMessage) {
            this.zzbaf = realTimeMessage;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RealTimeMessageReceivedListener realTimeMessageReceivedListener = (RealTimeMessageReceivedListener)object;
            zzbb zzbb2 = this;
            realTimeMessageReceivedListener.onRealTimeMessageReceived(zzbb2.zzbaf);
        }
    }

    static final class zzbe
    implements zzbfl<RoomStatusUpdateListener> {
        private final String zzbal;

        zzbe(String string) {
            this.zzbal = string;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbe zzbe2 = this;
            roomStatusUpdateListener.onP2PDisconnected(zzbe2.zzbal);
        }
    }

    static final class zzbd
    implements zzbfl<RoomStatusUpdateListener> {
        private final String zzbal;

        zzbd(String string) {
            this.zzbal = string;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbd zzbd2 = this;
            roomStatusUpdateListener.onP2PConnected(zzbd2.zzbal);
        }
    }

    static final class zzbh
    extends zza {
        zzbh(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    static final class zzbf
    extends zza {
        zzbf(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    static final class zzbg
    extends zza {
        zzbg(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    static final class zzbk
    extends zza {
        zzbk(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    static final class zzbj
    extends zza {
        zzbj(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    static final class zzbi
    extends zza {
        zzbi(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    static final class zzt
    extends zzc {
        zzt(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    static final class zzr
    extends zzc {
        zzr(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    static final class zzcb
    extends zzc {
        zzcb(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    static final class zzce
    extends zzc {
        zzce(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    static final class zzcd
    extends zzb {
        zzcd(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    static final class zzak
    implements zzbfl<RoomUpdateListener> {
        private final int zzaxw;
        private final String zzaZR;

        zzak(int n, String string) {
            this.zzaxw = n;
            this.zzaZR = string;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            zzak zzak2 = this;
            roomUpdateListener.onLeftRoom(zzak2.zzaxw, zzak2.zzaZR);
        }
    }

    static final class zzaf
    extends zzb {
        public zzaf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    static final class zzcf
    extends zzb {
        public zzcf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    static abstract class zza
    extends zzc {
        private final ArrayList<String> zzaZE = new ArrayList();

        zza(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzaZE.add(stringArray[i]);
            }
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzaZE);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    static abstract class zzc
    extends zzbdj<RoomStatusUpdateListener> {
        zzc(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzK(dataHolder2));
        }
    }

    static abstract class zzb
    extends zzbdj<RoomUpdateListener> {
        zzb(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            this.zza(roomUpdateListener, GamesClientImpl.zzK(dataHolder2), dataHolder2.getStatusCode());
        }
    }

    static final class zzby
    implements zzbfl<OnRequestReceivedListener> {
        private final String zzQz;

        zzby(String string) {
            this.zzQz = string;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzby zzby2 = this;
            onRequestReceivedListener.onRequestRemoved(zzby2.zzQz);
        }
    }

    static final class zzbx
    implements zzbfl<OnRequestReceivedListener> {
        private final GameRequest zzbat;

        zzbx(GameRequest gameRequest) {
            this.zzbat = gameRequest;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzbx zzbx2 = this;
            onRequestReceivedListener.onRequestReceived(zzbx2.zzbat);
        }
    }

    static final class zzbq
    implements zzbfl<QuestUpdateListener> {
        private final Quest zzaZF;

        zzbq(Quest quest) {
            this.zzaZF = quest;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            QuestUpdateListener questUpdateListener = (QuestUpdateListener)object;
            zzbq zzbq2 = this;
            questUpdateListener.onQuestCompleted(zzbq2.zzaZF);
        }
    }

    static final class zzay
    implements zzbfl<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzbad;

        zzay(String string) {
            this.zzbad = string;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzay zzay2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(zzay2.zzbad);
        }
    }

    static final class zzba
    implements zzbfl<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzbae;

        zzba(TurnBasedMatch turnBasedMatch) {
            this.zzbae = turnBasedMatch;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzba zzba2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(zzba2.zzbae);
        }
    }

    static final class zzad
    implements zzbfl<OnInvitationReceivedListener> {
        private final String zzajZ;

        zzad(String string) {
            this.zzajZ = string;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzad zzad2 = this;
            onInvitationReceivedListener.onInvitationRemoved(zzad2.zzajZ);
        }
    }

    static final class zzac
    implements zzbfl<OnInvitationReceivedListener> {
        private final Invitation zzaZP;

        zzac(Invitation invitation) {
            this.zzaZP = invitation;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzac zzac2 = this;
            onInvitationReceivedListener.onInvitationReceived(zzac2.zzaZP);
        }
    }

    static final class zzm
    implements zzbfl<Videos.CaptureOverlayStateListener> {
        private final int zzaZJ;

        zzm(int n) {
            this.zzaZJ = n;
        }

        public final void zzpR() {
        }

        public final /* synthetic */ void zzq(Object object) {
            Videos.CaptureOverlayStateListener captureOverlayStateListener = (Videos.CaptureOverlayStateListener)object;
            zzm zzm2 = this;
            captureOverlayStateListener.onCaptureOverlayStateChanged(zzm2.zzaZJ);
        }
    }

    static final class zzn
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Videos.CaptureStateResult> zzaIB;

        public zzn(zzbcl<Videos.CaptureStateResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzd(int n, Bundle bundle) {
            this.zzaIB.setResult((Object)new zzo(new Status(n), CaptureState.zzs(bundle)));
        }
    }

    static final class zzl
    extends com.google.android.gms.games.internal.zza {
        private final zzbfi<Videos.CaptureOverlayStateListener> zzaOs;

        zzl(zzbfi<Videos.CaptureOverlayStateListener> zzbfi2) {
            this.zzaOs = (zzbfi)com.google.android.gms.common.internal.zzbr.zzb(zzbfi2, (Object)"Callback must not be null");
        }

        @Override
        public final void onCaptureOverlayStateChanged(int n) {
            this.zzaOs.zza((zzbfl)new zzm(n));
        }
    }

    static final class zzj
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Videos.CaptureCapabilitiesResult> zzaIB;

        zzj(zzbcl<Videos.CaptureCapabilitiesResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(int n, VideoCapabilities videoCapabilities) {
            this.zzaIB.setResult((Object)new zzk(new Status(n), videoCapabilities));
        }
    }

    static final class zzh
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Videos.CaptureAvailableResult> zzaIB;

        zzh(zzbcl<Videos.CaptureAvailableResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(int n, boolean bl) {
            this.zzaIB.setResult((Object)new zzi(new Status(n), bl));
        }
    }

    static final class zzci
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Snapshots.DeleteSnapshotResult> zzaIB;

        public zzci(zzbcl<Snapshots.DeleteSnapshotResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(int n, String string) {
            this.zzaIB.setResult((Object)new zzs(n, string));
        }
    }

    static final class zzch
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Snapshots.CommitSnapshotResult> zzbaz;

        public zzch(zzbcl<Snapshots.CommitSnapshotResult> zzbcl2) {
            this.zzbaz = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzE(DataHolder dataHolder) {
            this.zzbaz.setResult((Object)new zzq(dataHolder));
        }
    }

    static final class zzcj
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Snapshots.OpenSnapshotResult> zzbaA;

        public zzcj(zzbcl<Snapshots.OpenSnapshotResult> zzbcl2) {
            this.zzbaA = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this.zzbaA.setResult((Object)new zzbc(dataHolder, zzc2));
        }

        @Override
        public final void zza(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            this.zzbaA.setResult((Object)new zzbc(dataHolder, string, zzc2, zzc3, zzc4));
        }
    }

    static final class zzck
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Snapshots.LoadSnapshotsResult> zzbaB;

        public zzck(zzbcl<Snapshots.LoadSnapshotsResult> zzbcl2) {
            this.zzbaB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzD(DataHolder dataHolder) {
            this.zzbaB.setResult((Object)new zzax(dataHolder));
        }
    }

    static final class zzbm
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Stats.LoadPlayerStatsResult> zzaIB;

        public zzbm(zzbcl<Stats.LoadPlayerStatsResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzJ(DataHolder dataHolder) {
            this.zzaIB.setResult((Object)new zzas(dataHolder));
        }
    }

    static final class zzbt
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Quests.LoadQuestsResult> zzbap;

        public zzbt(zzbcl<Quests.LoadQuestsResult> zzbcl2) {
            this.zzbap = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzI(DataHolder dataHolder) {
            this.zzbap.setResult((Object)new zzau(dataHolder));
        }
    }

    static final class zzbr
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Quests.ClaimMilestoneResult> zzban;
        private final String zzbao;

        public zzbr(zzbcl<Quests.ClaimMilestoneResult> zzbcl2, String string) {
            this.zzban = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
            this.zzbao = (String)com.google.android.gms.common.internal.zzbr.zzb((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public final void zzF(DataHolder dataHolder) {
            this.zzban.setResult((Object)new zzp(dataHolder, this.zzbao));
        }
    }

    static final class zzbp
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Quests.AcceptQuestResult> zzbam;

        public zzbp(zzbcl<Quests.AcceptQuestResult> zzbcl2) {
            this.zzbam = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzG(DataHolder dataHolder) {
            this.zzbam.setResult((Object)new zzd(dataHolder));
        }
    }

    static final class zzbz
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Requests.LoadRequestsResult> zzbau;

        public zzbz(zzbcl<Requests.LoadRequestsResult> zzbcl2) {
            this.zzbau = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzaY(n);
            this.zzbau.setResult((Object)new zzav(status, bundle));
        }
    }

    static final class zzca
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Requests.UpdateRequestsResult> zzbav;

        public zzca(zzbcl<Requests.UpdateRequestsResult> zzbcl2) {
            this.zzbav = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzC(DataHolder dataHolder) {
            this.zzbav.setResult((Object)new zzcw(dataHolder));
        }
    }

    static final class zzbo
    extends com.google.android.gms.games.internal.zzb {
        private final com.google.android.gms.games.internal.zzn zzaZx;

        public zzbo(com.google.android.gms.games.internal.zzn zzn2) {
            this.zzaZx = zzn2;
        }

        @Override
        public final com.google.android.gms.games.internal.zzl zzuq() {
            return new com.google.android.gms.games.internal.zzl(this.zzaZx.zzbaP);
        }
    }

    static final class zzy
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Games.GetServerAuthCodeResult> zzaIB;

        public zzy(zzbcl<Games.GetServerAuthCodeResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(int n, String string) {
            Status status = GamesStatusCodes.zzaY(n);
            this.zzaIB.setResult((Object)new zzz(status, string));
        }
    }

    static final class zzcg
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Status> zzaIB;

        public zzcg(zzbcl<Status> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzup() {
            Status status = GamesStatusCodes.zzaY(0);
            this.zzaIB.setResult((Object)status);
        }
    }

    static final class zzbv
    extends com.google.android.gms.games.internal.zza {
        private zzbfi<RealTimeMultiplayer.ReliableMessageSentCallback> zzbas;

        public zzbv(zzbfi<RealTimeMultiplayer.ReliableMessageSentCallback> zzbfi2) {
            this.zzbas = zzbfi2;
        }

        @Override
        public final void zzb(int n, int n2, String string) {
            if (this.zzbas != null) {
                this.zzbas.zza((zzbfl)new zzbu(n, n2, string));
            }
        }
    }

    static final class zzcc
    extends com.google.android.gms.games.internal.zza {
        private final zzbfi<? extends RoomUpdateListener> zzbaw;
        private final zzbfi<? extends RoomStatusUpdateListener> zzbax;
        private final zzbfi<RealTimeMessageReceivedListener> zzbay;

        public zzcc(zzbfi<RoomUpdateListener> zzbfi2) {
            this.zzbaw = (zzbfi)com.google.android.gms.common.internal.zzbr.zzb(zzbfi2, (Object)"Callbacks must not be null");
            this.zzbax = null;
            this.zzbay = null;
        }

        public zzcc(zzbfi<? extends RoomUpdateListener> zzbfi2, zzbfi<? extends RoomStatusUpdateListener> zzbfi3, zzbfi<RealTimeMessageReceivedListener> zzbfi4) {
            this.zzbaw = (zzbfi)com.google.android.gms.common.internal.zzbr.zzb(zzbfi2, (Object)"Callbacks must not be null");
            this.zzbax = zzbfi3;
            this.zzbay = zzbfi4;
        }

        @Override
        public final void zzu(DataHolder dataHolder) {
            this.zzbaw.zza((zzbfl)new zzcf(dataHolder));
        }

        @Override
        public final void zzv(DataHolder dataHolder) {
            this.zzbaw.zza((zzbfl)new zzaf(dataHolder));
        }

        @Override
        public final void onLeftRoom(int n, String string) {
            this.zzbaw.zza((zzbfl)new zzak(n, string));
        }

        @Override
        public final void zzy(DataHolder dataHolder) {
            this.zzbaw.zza((zzbfl)new zzcd(dataHolder));
        }

        @Override
        public final void zzw(DataHolder dataHolder) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzce(dataHolder));
            }
        }

        @Override
        public final void zzx(DataHolder dataHolder) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzcb(dataHolder));
            }
        }

        @Override
        public final void zzz(DataHolder dataHolder) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzr(dataHolder));
            }
        }

        @Override
        public final void zzA(DataHolder dataHolder) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzt(dataHolder));
            }
        }

        @Override
        public final void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzbf(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzbh(dataHolder, stringArray));
            }
        }

        @Override
        public final void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzbi(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzbj(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzbk(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzbg(dataHolder, stringArray));
            }
        }

        @Override
        public final void onP2PConnected(String string) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzbd(string));
            }
        }

        @Override
        public final void onP2PDisconnected(String string) {
            if (this.zzbax != null) {
                this.zzbax.zza((zzbfl)new zzbe(string));
            }
        }

        @Override
        public final void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.zzbay != null) {
                this.zzbay.zza((zzbfl)new zzbb(realTimeMessage));
            }
        }
    }

    static final class zzcn
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<TurnBasedMultiplayer.CancelMatchResult> zzbaD;

        public zzcn(zzbcl<TurnBasedMultiplayer.CancelMatchResult> zzbcl2) {
            this.zzbaD = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzaY(n);
            this.zzbaD.setResult((Object)new zzg(status, string));
        }
    }

    static final class zzcp
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<TurnBasedMultiplayer.LeaveMatchResult> zzbaF;

        public zzcp(zzbcl<TurnBasedMultiplayer.LeaveMatchResult> zzbcl2) {
            this.zzbaF = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzs(DataHolder dataHolder) {
            this.zzbaF.setResult((Object)new zzaj(dataHolder));
        }
    }

    static final class zzcs
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<TurnBasedMultiplayer.UpdateMatchResult> zzbaH;

        public zzcs(zzbcl<TurnBasedMultiplayer.UpdateMatchResult> zzbcl2) {
            this.zzbaH = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzr(DataHolder dataHolder) {
            this.zzbaH.setResult((Object)new zzcv(dataHolder));
        }
    }

    static final class zzco
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<TurnBasedMultiplayer.InitiateMatchResult> zzbaE;

        public zzco(zzbcl<TurnBasedMultiplayer.InitiateMatchResult> zzbcl2) {
            this.zzbaE = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzq(DataHolder dataHolder) {
            this.zzbaE.setResult((Object)new zzaa(dataHolder));
        }
    }

    static final class zzcq
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<TurnBasedMultiplayer.LoadMatchResult> zzbaG;

        public zzcq(zzbcl<TurnBasedMultiplayer.LoadMatchResult> zzbcl2) {
            this.zzbaG = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzp(DataHolder dataHolder) {
            this.zzbaG.setResult((Object)new zzap(dataHolder));
        }
    }

    static final class zzct
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<TurnBasedMultiplayer.LoadMatchesResult> zzbaI;

        public zzct(zzbcl<TurnBasedMultiplayer.LoadMatchesResult> zzbcl2) {
            this.zzbaI = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzb(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzaY(n);
            this.zzbaI.setResult((Object)new zzaq(status, bundle));
        }
    }

    static final class zzcl
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Leaderboards.SubmitScoreResult> zzaIB;

        public zzcl(zzbcl<Leaderboards.SubmitScoreResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(DataHolder dataHolder) {
            this.zzaIB.setResult((Object)new zzcm(dataHolder));
        }
    }

    static final class zzbn
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Players.LoadPlayersResult> zzaIB;

        zzbn(zzbcl<Players.LoadPlayersResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(DataHolder dataHolder) {
            this.zzaIB.setResult((Object)new zzat(dataHolder));
        }

        @Override
        public final void zzk(DataHolder dataHolder) {
            this.zzaIB.setResult((Object)new zzat(dataHolder));
        }
    }

    static final class zzbw
    extends com.google.android.gms.games.internal.zza {
        private final zzbfi<OnRequestReceivedListener> zzaOs;

        zzbw(zzbfi<OnRequestReceivedListener> zzbfi2) {
            this.zzaOs = zzbfi2;
        }

        @Override
        public final void zzo(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzaOs.zza((zzbfl)new zzbx(gameRequest));
            }
        }

        @Override
        public final void onRequestRemoved(String string) {
            this.zzaOs.zza((zzbfl)new zzby(string));
        }
    }

    static final class zzbs
    extends com.google.android.gms.games.internal.zza {
        private final zzbfi<QuestUpdateListener> zzaOs;

        zzbs(zzbfi<QuestUpdateListener> zzbfi2) {
            this.zzaOs = zzbfi2;
        }

        @Override
        public final void zzH(DataHolder dataHolder) {
            Quest quest = zzbs.zzM(dataHolder);
            if (quest != null) {
                this.zzaOs.zza((zzbfl)new zzbq(quest));
            }
        }

        private static Quest zzM(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    static final class zzaz
    extends com.google.android.gms.games.internal.zza {
        private final zzbfi<OnTurnBasedMatchUpdateReceivedListener> zzaOs;

        zzaz(zzbfi<OnTurnBasedMatchUpdateReceivedListener> zzbfi2) {
            this.zzaOs = zzbfi2;
        }

        @Override
        public final void zzt(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzaOs.zza((zzbfl)new zzba(turnBasedMatch));
            }
        }

        @Override
        public final void onTurnBasedMatchRemoved(String string) {
            this.zzaOs.zza((zzbfl)new zzay(string));
        }
    }

    static final class zzab
    extends com.google.android.gms.games.internal.zza {
        private final zzbfi<OnInvitationReceivedListener> zzaOs;

        zzab(zzbfi<OnInvitationReceivedListener> zzbfi2) {
            this.zzaOs = zzbfi2;
        }

        @Override
        public final void zzn(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzaOs.zza((zzbfl)new zzac(invitation));
            }
        }

        @Override
        public final void onInvitationRemoved(String string) {
            this.zzaOs.zza((zzbfl)new zzad(string));
        }
    }

    static final class zzae
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Invitations.LoadInvitationsResult> zzaIB;

        zzae(zzbcl<Invitations.LoadInvitationsResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzm(DataHolder dataHolder) {
            this.zzaIB.setResult((Object)new zzao(dataHolder));
        }
    }

    static final class zzbl
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Leaderboards.LoadPlayerScoreResult> zzaIB;

        zzbl(zzbcl<Leaderboards.LoadPlayerScoreResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzB(DataHolder dataHolder) {
            this.zzaIB.setResult((Object)new zzar(dataHolder));
        }
    }

    static final class zzah
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Leaderboards.LoadScoresResult> zzaIB;

        zzah(zzbcl<Leaderboards.LoadScoresResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzaIB.setResult((Object)new zzaw(dataHolder, dataHolder2));
        }
    }

    static final class zzai
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Leaderboards.LeaderboardMetadataResult> zzaIB;

        zzai(zzbcl<Leaderboards.LeaderboardMetadataResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(DataHolder dataHolder) {
            this.zzaIB.setResult((Object)new zzag(dataHolder));
        }
    }

    static final class zzu
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Events.LoadEventsResult> zzaIB;

        zzu(zzbcl<Events.LoadEventsResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(DataHolder dataHolder) {
            this.zzaIB.setResult((Object)new zzam(dataHolder));
        }
    }

    static final class zzx
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<GamesMetadata.LoadGamesResult> zzaIB;

        zzx(zzbcl<GamesMetadata.LoadGamesResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzl(DataHolder dataHolder) {
            this.zzaIB.setResult((Object)new zzan(dataHolder));
        }
    }

    static final class zze
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Achievements.UpdateAchievementResult> zzaIB;

        zze(zzbcl<Achievements.UpdateAchievementResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(int n, String string) {
            this.zzaIB.setResult((Object)new zzcu(n, string));
        }
    }

    static final class zzf
    extends com.google.android.gms.games.internal.zza {
        private final zzbcl<Achievements.LoadAchievementsResult> zzaIB;

        zzf(zzbcl<Achievements.LoadAchievementsResult> zzbcl2) {
            this.zzaIB = (zzbcl)com.google.android.gms.common.internal.zzbr.zzb(zzbcl2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzf(DataHolder dataHolder) {
            this.zzaIB.setResult((Object)new zzal(dataHolder));
        }
    }

    final class zzv
    extends zzcbv {
        private /* synthetic */ GamesClientImpl zzaZD;

        public zzv(GamesClientImpl gamesClientImpl) {
            this.zzaZD = gamesClientImpl;
            super(gamesClientImpl.getContext().getMainLooper(), 1000);
        }

        @Override
        protected final void zzq(String string, int n) {
            try {
                if (this.zzaZD.isConnected()) {
                    ((com.google.android.gms.games.internal.zzj)this.zzaZD.zzrd()).zzn(string, n);
                    return;
                }
                com.google.android.gms.games.internal.zze.zzz("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
                return;
            }
        }
    }
}

