/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;
import java.util.Arrays;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new zza();
    private final GameEntity zzbbR;
    private final String zzajZ;
    private final long mCreationTimestamp;
    private final int zzbdv;
    private final ParticipantEntity zzbdw;
    private final ArrayList<ParticipantEntity> zzbdx;
    private final int zzbdy;
    private final int zzbdz;

    InvitationEntity(Invitation invitation) {
        this.zzbbR = new GameEntity(invitation.getGame());
        this.zzajZ = invitation.getInvitationId();
        this.mCreationTimestamp = invitation.getCreationTimestamp();
        this.zzbdv = invitation.getInvitationType();
        this.zzbdy = invitation.getVariant();
        this.zzbdz = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.zzbdx = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.zzbdx.add((ParticipantEntity)participant2.freeze());
        }
        zzbr.zzb(participant, (Object)"Must have a valid inviter!");
        this.zzbdw = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(GameEntity gameEntity, String string, long l, int n, ParticipantEntity participantEntity, ArrayList<ParticipantEntity> arrayList, int n2, int n3) {
        this.zzbbR = gameEntity;
        this.zzajZ = string;
        this.mCreationTimestamp = l;
        this.zzbdv = n;
        this.zzbdw = participantEntity;
        this.zzbdx = arrayList;
        this.zzbdy = n2;
        this.zzbdz = n3;
    }

    @Override
    public final Game getGame() {
        return this.zzbbR;
    }

    @Override
    public final String getInvitationId() {
        return this.zzajZ;
    }

    @Override
    public final Participant getInviter() {
        return this.zzbdw;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzbdx);
    }

    @Override
    public final int getInvitationType() {
        return this.zzbdv;
    }

    @Override
    public final int getVariant() {
        return this.zzbdy;
    }

    @Override
    public final int getAvailableAutoMatchSlots() {
        return this.zzbdz;
    }

    public final Invitation freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return Arrays.hashCode(new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public final boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzbh.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzbh.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzbh.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzbh.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzbh.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzbh.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzbh.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzbh.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public final String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzbh.zzt((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        InvitationEntity invitationEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)invitationEntity.getGame(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)invitationEntity.getInvitationId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)invitationEntity.getCreationTimestamp());
        zzd.zzc((Parcel)parcel2, (int)4, (int)invitationEntity.getInvitationType());
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)invitationEntity.getInviter(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)6, invitationEntity.getParticipants(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)invitationEntity.getVariant());
        zzd.zzc((Parcel)parcel2, (int)8, (int)invitationEntity.getAvailableAutoMatchSlots());
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends com.google.android.gms.games.multiplayer.zza {
        zza() {
        }

        @Override
        public final InvitationEntity zzh(Parcel parcel) {
            if (InvitationEntity.zze(InvitationEntity.zzrv()) || InvitationEntity.zzcA((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzh(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n2 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new InvitationEntity(gameEntity, string, l, n, participantEntity, arrayList, -1, 0);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzh(parcel);
        }
    }
}

