/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.zzc;
import com.google.android.gms.games.multiplayer.realtime.zzd;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class RoomConfig {
    protected RoomConfig() {
    }

    public abstract RoomUpdateListener getRoomUpdateListener();

    public abstract String getInvitationId();

    public abstract RoomStatusUpdateListener getRoomStatusUpdateListener();

    public abstract RealTimeMessageReceivedListener getMessageReceivedListener();

    public abstract int getVariant();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder(RoomUpdateListener roomUpdateListener) {
        return new Builder(roomUpdateListener, null);
    }

    public static Bundle createAutoMatchCriteria(int n, int n2, long l) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", n);
        bundle.putInt("max_automatch_players", n2);
        bundle.putLong("exclusive_bit_mask", l);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener zzbdG;
        RoomStatusUpdateListener zzbdH;
        RealTimeMessageReceivedListener zzbdI;
        String zzbdJ = null;
        int zzbdu = -1;
        ArrayList<String> zzbdK = new ArrayList();
        Bundle zzbdL;

        private Builder(RoomUpdateListener roomUpdateListener) {
            this.zzbdG = (RoomUpdateListener)zzbo.zzb((Object)roomUpdateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public final Builder setInvitationIdToAccept(String string) {
            zzbo.zzu((Object)string);
            this.zzbdJ = string;
            return this;
        }

        public final Builder setRoomStatusUpdateListener(RoomStatusUpdateListener roomStatusUpdateListener) {
            this.zzbdH = roomStatusUpdateListener;
            return this;
        }

        public final Builder setMessageReceivedListener(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.zzbdI = realTimeMessageReceivedListener;
            return this;
        }

        public final Builder addPlayersToInvite(String ... stringArray) {
            zzbo.zzu((Object)stringArray);
            this.zzbdK.addAll(Arrays.asList(stringArray));
            return this;
        }

        public final Builder addPlayersToInvite(ArrayList<String> arrayList) {
            zzbo.zzu(arrayList);
            this.zzbdK.addAll(arrayList);
            return this;
        }

        public final Builder setVariant(int n) {
            zzbo.zzb((n == -1 || n > 0 ? 1 : 0) != 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.zzbdu = n;
            return this;
        }

        public final Builder setAutoMatchCriteria(Bundle bundle) {
            this.zzbdL = bundle;
            return this;
        }

        public final RoomConfig build() {
            return new zzd(this);
        }

        /* synthetic */ Builder(RoomUpdateListener roomUpdateListener, zzc zzc2) {
            this(roomUpdateListener);
        }
    }
}

