/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.zza;
import java.util.Arrays;

public final class VideoCapabilities
extends zzc {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new zza();
    private final boolean zzbfd;
    private final boolean zzbfe;
    private final boolean zzbff;
    private final boolean[] zzbfg;
    private final boolean[] zzbfh;

    public VideoCapabilities(boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.zzbfd = bl;
        this.zzbfe = bl2;
        this.zzbff = bl3;
        this.zzbfg = blArray;
        this.zzbfh = blArray2;
    }

    public final boolean isMicSupported() {
        return this.zzbfe;
    }

    public final boolean isCameraSupported() {
        return this.zzbfd;
    }

    public final boolean isWriteStorageSupported() {
        return this.zzbff;
    }

    public final boolean[] getSupportedCaptureModes() {
        return this.zzbfg;
    }

    public final boolean[] getSupportedQualityLevels() {
        return this.zzbfh;
    }

    public final boolean supportsCaptureMode(int n) {
        zzbo.zzae((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.zzbfg[n];
    }

    public final boolean supportsQualityLevel(int n) {
        zzbo.zzae((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.zzbfh[n];
    }

    public final boolean isFullySupported(int n, int n2) {
        return this.zzbfd && this.zzbfe && this.zzbff && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.getSupportedCaptureModes(), this.getSupportedQualityLevels(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzbe.equal((Object)videoCapabilities.getSupportedCaptureModes(), (Object)this.getSupportedCaptureModes()) && zzbe.equal((Object)videoCapabilities.getSupportedQualityLevels(), (Object)this.getSupportedQualityLevels()) && zzbe.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzbe.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzbe.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public final String toString() {
        return zzbe.zzt((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.getSupportedCaptureModes()).zzg("SupportedQualityLevels", (Object)this.getSupportedQualityLevels()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoCapabilities videoCapabilities = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (boolean)videoCapabilities.isCameraSupported());
        zzd.zza((Parcel)parcel2, (int)2, (boolean)videoCapabilities.isMicSupported());
        zzd.zza((Parcel)parcel2, (int)3, (boolean)videoCapabilities.isWriteStorageSupported());
        zzd.zza((Parcel)parcel2, (int)4, (boolean[])videoCapabilities.getSupportedCaptureModes(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (boolean[])videoCapabilities.getSupportedQualityLevels(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

