/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.zzb;
import com.google.android.gms.games.zzg;
import java.util.Arrays;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new zza();
    private String zzaxn;
    private String zzalP;
    private final Uri zzaXU;
    private final Uri zzaXV;
    private final long zzaYE;
    private final int zzaYF;
    private final long zzaYG;
    private final String zzaYf;
    private final String zzaYg;
    private final String zzaoy;
    private final zzb zzaYH;
    private final PlayerLevelInfo zzaYI;
    private final boolean zzaYJ;
    private final boolean zzaYK;
    private final String zzaYL;
    private final String mName;
    private final Uri zzaYM;
    private final String zzaYN;
    private final Uri zzaYO;
    private final String zzaYP;
    private final int zzaYQ;
    private final long zzaYR;
    private final boolean zzacy;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    private PlayerEntity(Player player, boolean bl) {
        this.zzaxn = player.getPlayerId();
        this.zzalP = player.getDisplayName();
        this.zzaXU = player.getIconImageUri();
        this.zzaYf = player.getIconImageUrl();
        this.zzaXV = player.getHiResImageUri();
        this.zzaYg = player.getHiResImageUrl();
        this.zzaYE = player.getRetrievedTimestamp();
        this.zzaYF = player.zzul();
        this.zzaYG = player.getLastPlayedWithTimestamp();
        this.zzaoy = player.getTitle();
        this.zzaYJ = player.zzum();
        com.google.android.gms.games.internal.player.zza zza2 = player.zzun();
        this.zzaYH = zza2 == null ? null : new zzb(zza2);
        this.zzaYI = player.getLevelInfo();
        this.zzaYK = player.zzuk();
        this.zzaYL = player.zzuj();
        this.mName = player.getName();
        this.zzaYM = player.getBannerImageLandscapeUri();
        this.zzaYN = player.getBannerImageLandscapeUrl();
        this.zzaYO = player.getBannerImagePortraitUri();
        this.zzaYP = player.getBannerImagePortraitUrl();
        this.zzaYQ = player.zzuo();
        this.zzaYR = player.zzup();
        this.zzacy = player.isMuted();
        zzc.zzr((Object)this.zzaxn);
        zzc.zzr((Object)this.zzalP);
        zzc.zzae((this.zzaYE > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(String string, String string2, Uri uri, Uri uri2, long l, int n, long l2, String string3, String string4, String string5, zzb zzb2, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n2, long l3, boolean bl3) {
        this.zzaxn = string;
        this.zzalP = string2;
        this.zzaXU = uri;
        this.zzaYf = string3;
        this.zzaXV = uri2;
        this.zzaYg = string4;
        this.zzaYE = l;
        this.zzaYF = n;
        this.zzaYG = l2;
        this.zzaoy = string5;
        this.zzaYJ = bl;
        this.zzaYH = zzb2;
        this.zzaYI = playerLevelInfo;
        this.zzaYK = bl2;
        this.zzaYL = string6;
        this.mName = string7;
        this.zzaYM = uri3;
        this.zzaYN = string8;
        this.zzaYO = uri4;
        this.zzaYP = string9;
        this.zzaYQ = n2;
        this.zzaYR = l3;
        this.zzacy = bl3;
    }

    @Override
    public final String getPlayerId() {
        return this.zzaxn;
    }

    @Override
    public final String getDisplayName() {
        return this.zzalP;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzalP, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String zzuj() {
        return this.zzaYL;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final boolean zzuk() {
        return this.zzaYK;
    }

    @Override
    public final boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzaXU;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzaYf;
    }

    @Override
    public final boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzaXV;
    }

    @Override
    public final String getHiResImageUrl() {
        return this.zzaYg;
    }

    @Override
    public final long getRetrievedTimestamp() {
        return this.zzaYE;
    }

    @Override
    public final long getLastPlayedWithTimestamp() {
        return this.zzaYG;
    }

    @Override
    public final int zzul() {
        return this.zzaYF;
    }

    @Override
    public final boolean zzum() {
        return this.zzaYJ;
    }

    @Override
    public final String getTitle() {
        return this.zzaoy;
    }

    @Override
    public final void getTitle(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzaoy, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final PlayerLevelInfo getLevelInfo() {
        return this.zzaYI;
    }

    @Override
    public final com.google.android.gms.games.internal.player.zza zzun() {
        return this.zzaYH;
    }

    @Override
    public final Uri getBannerImageLandscapeUri() {
        return this.zzaYM;
    }

    @Override
    public final String getBannerImageLandscapeUrl() {
        return this.zzaYN;
    }

    @Override
    public final Uri getBannerImagePortraitUri() {
        return this.zzaYO;
    }

    @Override
    public final String getBannerImagePortraitUrl() {
        return this.zzaYP;
    }

    @Override
    public final int zzuo() {
        return this.zzaYQ;
    }

    @Override
    public final long zzup() {
        return this.zzaYR;
    }

    @Override
    public final boolean isMuted() {
        return this.zzacy;
    }

    public final Player freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return Arrays.hashCode(new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzuk(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzuj(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzuo(), player.zzup(), player.isMuted()});
    }

    public final boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzbe.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzbe.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzbe.equal((Object)player2.zzuk(), (Object)player.zzuk()) && zzbe.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzbe.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzbe.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzbe.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzbe.equal((Object)((Object)player2.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && zzbe.equal((Object)player2.zzuj(), (Object)player.zzuj()) && zzbe.equal((Object)player2.getName(), (Object)player.getName()) && zzbe.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzbe.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzbe.equal((Object)player2.zzuo(), (Object)player.zzuo()) && zzbe.equal((Object)player2.zzup(), (Object)player.zzup()) && zzbe.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public final String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzbe.zzt((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzuk()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzuj()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzuo()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzup()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlayerEntity playerEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)playerEntity.getPlayerId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)playerEntity.getDisplayName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)playerEntity.getIconImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)playerEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (long)playerEntity.getRetrievedTimestamp());
        zzd.zzc((Parcel)parcel2, (int)6, (int)playerEntity.zzaYF);
        zzd.zza((Parcel)parcel2, (int)7, (long)playerEntity.getLastPlayedWithTimestamp());
        zzd.zza((Parcel)parcel2, (int)8, (String)playerEntity.getIconImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)playerEntity.getHiResImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)14, (String)playerEntity.getTitle(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)15, (Parcelable)playerEntity.zzaYH, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)16, (Parcelable)playerEntity.getLevelInfo(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)18, (boolean)playerEntity.zzaYJ);
        zzd.zza((Parcel)parcel2, (int)19, (boolean)playerEntity.zzaYK);
        zzd.zza((Parcel)parcel2, (int)20, (String)playerEntity.zzaYL, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)21, (String)playerEntity.mName, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)22, (Parcelable)playerEntity.getBannerImageLandscapeUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)23, (String)playerEntity.getBannerImageLandscapeUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)24, (Parcelable)playerEntity.getBannerImagePortraitUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)25, (String)playerEntity.getBannerImagePortraitUrl(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)26, (int)playerEntity.zzaYQ);
        zzd.zza((Parcel)parcel2, (int)27, (long)playerEntity.zzaYR);
        zzd.zza((Parcel)parcel2, (int)28, (boolean)playerEntity.zzacy);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzg {
        zza() {
        }

        @Override
        public final PlayerEntity zzg(Parcel parcel) {
            if (PlayerEntity.zze(PlayerEntity.zzrx()) || PlayerEntity.zzcA((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzg(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzg(parcel);
        }
    }
}

