/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class QuestEntity
extends com.google.android.gms.games.internal.zzc
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new zzc();
    private final GameEntity zzbbN;
    private final String zzbei;
    private final long zzbej;
    private final Uri zzbek;
    private final String zzbel;
    private final String zzafa;
    private final long zzbem;
    private final long zzaZl;
    private final Uri zzben;
    private final String zzbeo;
    private final String mName;
    private final long zzbep;
    private final long zzbeq;
    private final int mState;
    private final int zzamr;
    private final ArrayList<MilestoneEntity> zzber;

    public QuestEntity(Quest quest) {
        this.zzbbN = new GameEntity(quest.getGame());
        this.zzbei = quest.getQuestId();
        this.zzbej = quest.getAcceptedTimestamp();
        this.zzafa = quest.getDescription();
        this.zzbek = quest.getBannerImageUri();
        this.zzbel = quest.getBannerImageUrl();
        this.zzbem = quest.getEndTimestamp();
        this.zzben = quest.getIconImageUri();
        this.zzbeo = quest.getIconImageUrl();
        this.zzaZl = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzbep = quest.zzvu();
        this.zzbeq = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzamr = quest.getType();
        List<Milestone> list = quest.zzvt();
        int n = list.size();
        this.zzber = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzber.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n, int n2, ArrayList<MilestoneEntity> arrayList) {
        this.zzbbN = gameEntity;
        this.zzbei = string;
        this.zzbej = l;
        this.zzbek = uri;
        this.zzbel = string2;
        this.zzafa = string3;
        this.zzbem = l2;
        this.zzaZl = l3;
        this.zzben = uri2;
        this.zzbeo = string4;
        this.mName = string5;
        this.zzbep = l4;
        this.zzbeq = l5;
        this.mState = n;
        this.zzamr = n2;
        this.zzber = arrayList;
    }

    @Override
    public final String getQuestId() {
        return this.zzbei;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzafa;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzafa, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzben;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzbeo;
    }

    @Override
    public final Uri getBannerImageUri() {
        return this.zzbek;
    }

    @Override
    public final String getBannerImageUrl() {
        return this.zzbel;
    }

    @Override
    public final Milestone getCurrentMilestone() {
        return this.zzvt().get(0);
    }

    @Override
    public final List<Milestone> zzvt() {
        return new ArrayList<Milestone>(this.zzber);
    }

    @Override
    public final Game getGame() {
        return this.zzbbN;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getType() {
        return this.zzamr;
    }

    @Override
    public final long getAcceptedTimestamp() {
        return this.zzbej;
    }

    @Override
    public final long getEndTimestamp() {
        return this.zzbem;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzaZl;
    }

    @Override
    public final long zzvu() {
        return this.zzbep;
    }

    @Override
    public final long getStartTimestamp() {
        return this.zzbeq;
    }

    @Override
    public final boolean isEndingSoon() {
        return this.zzbep <= System.currentTimeMillis() + 1800000L;
    }

    public final Quest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return Arrays.hashCode(new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzvt(), quest.getName(), quest.zzvu(), quest.getStartTimestamp(), quest.getState()});
    }

    public final boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzbe.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzbe.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzbe.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzbe.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzbe.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzbe.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzbe.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzbe.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzbe.equal(quest2.zzvt(), quest.zzvt()) && zzbe.equal((Object)quest2.getName(), (Object)quest.getName()) && zzbe.equal((Object)quest2.zzvu(), (Object)quest.zzvu()) && zzbe.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzbe.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public final String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzbe.zzt((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzvt()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzvu()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        QuestEntity questEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)questEntity.getGame(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)questEntity.getQuestId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)questEntity.getAcceptedTimestamp());
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)questEntity.getBannerImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)questEntity.getBannerImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)questEntity.getDescription(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (long)questEntity.getEndTimestamp());
        zzd.zza((Parcel)parcel2, (int)8, (long)questEntity.getLastUpdatedTimestamp());
        zzd.zza((Parcel)parcel2, (int)9, (Parcelable)questEntity.getIconImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)10, (String)questEntity.getIconImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)12, (String)questEntity.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)13, (long)questEntity.zzbep);
        zzd.zza((Parcel)parcel2, (int)14, (long)questEntity.getStartTimestamp());
        zzd.zzc((Parcel)parcel2, (int)15, (int)questEntity.getState());
        zzd.zzc((Parcel)parcel2, (int)16, (int)questEntity.zzamr);
        zzd.zzc((Parcel)parcel2, (int)17, questEntity.zzvt(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

