/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.zzc;
import java.util.Arrays;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new zza();
    private final String zzhfq;
    private final String zzeby;
    private final Uri zzhbd;
    private final Uri zzhbe;
    private final int zzbyx;
    private final String zzhmg;
    private final boolean zzhmh;
    private final PlayerEntity zzhdr;
    private final int zzeit;
    private final ParticipantResult zzhmi;
    private final String zzhbo;
    private final String zzhbp;

    public ParticipantEntity(Participant participant) {
        this.zzhfq = participant.getParticipantId();
        this.zzeby = participant.getDisplayName();
        this.zzhbd = participant.getIconImageUri();
        this.zzhbe = participant.getHiResImageUri();
        this.zzbyx = participant.getStatus();
        this.zzhmg = participant.zzaru();
        this.zzhmh = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzhdr = player == null ? null : new PlayerEntity(player);
        this.zzeit = participant.getCapabilities();
        this.zzhmi = participant.getResult();
        this.zzhbo = participant.getIconImageUrl();
        this.zzhbp = participant.getHiResImageUrl();
    }

    ParticipantEntity(String string, String string2, Uri uri, Uri uri2, int n, String string3, boolean bl, PlayerEntity playerEntity, int n2, ParticipantResult participantResult, String string4, String string5) {
        this.zzhfq = string;
        this.zzeby = string2;
        this.zzhbd = uri;
        this.zzhbe = uri2;
        this.zzbyx = n;
        this.zzhmg = string3;
        this.zzhmh = bl;
        this.zzhdr = playerEntity;
        this.zzeit = n2;
        this.zzhmi = participantResult;
        this.zzhbo = string4;
        this.zzhbp = string5;
    }

    @Override
    public final int getStatus() {
        return this.zzbyx;
    }

    @Override
    public final String zzaru() {
        return this.zzhmg;
    }

    @Override
    public final boolean isConnectedToRoom() {
        return this.zzhmh;
    }

    @Override
    public final String getDisplayName() {
        if (this.zzhdr == null) {
            return this.zzeby;
        }
        return this.zzhdr.getDisplayName();
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhdr == null) {
            zzg.zzb((String)this.zzeby, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzhdr.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        if (this.zzhdr == null) {
            return this.zzhbd;
        }
        return this.zzhdr.getIconImageUri();
    }

    @Override
    public final String getIconImageUrl() {
        if (this.zzhdr == null) {
            return this.zzhbo;
        }
        return this.zzhdr.getIconImageUrl();
    }

    @Override
    public final Uri getHiResImageUri() {
        if (this.zzhdr == null) {
            return this.zzhbe;
        }
        return this.zzhdr.getHiResImageUri();
    }

    @Override
    public final String getHiResImageUrl() {
        if (this.zzhdr == null) {
            return this.zzhbp;
        }
        return this.zzhdr.getHiResImageUrl();
    }

    @Override
    public final String getParticipantId() {
        return this.zzhfq;
    }

    @Override
    public final Player getPlayer() {
        return this.zzhdr;
    }

    @Override
    public final ParticipantResult getResult() {
        return this.zzhmi;
    }

    @Override
    public final int getCapabilities() {
        return this.zzeit;
    }

    public final Participant freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return Arrays.hashCode(new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzaru(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public final boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzbf.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzbf.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzbf.equal((Object)participant2.zzaru(), (Object)participant.zzaru()) && zzbf.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzbf.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzbf.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzbf.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzbf.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzbf.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzbf.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public final String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzbf.zzt((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzaru()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ParticipantEntity participantEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)participantEntity.getParticipantId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)participantEntity.getDisplayName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)participantEntity.getIconImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)participantEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, (int)participantEntity.getStatus());
        zzd.zza((Parcel)parcel2, (int)6, (String)participantEntity.zzhmg, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)participantEntity.isConnectedToRoom());
        zzd.zza((Parcel)parcel2, (int)8, (Parcelable)participantEntity.getPlayer(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)9, (int)participantEntity.zzeit);
        zzd.zza((Parcel)parcel2, (int)10, (Parcelable)participantEntity.getResult(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)11, (String)participantEntity.getIconImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)12, (String)participantEntity.getHiResImageUrl(), (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzc {
        zza() {
        }

        @Override
        public final ParticipantEntity zzl(Parcel parcel) {
            if (ParticipantEntity.zze(ParticipantEntity.zzakc()) || ParticipantEntity.zzga((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzl(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl = parcel.readInt() > 0;
            PlayerEntity playerEntity = parcel.readInt() > 0 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(string, string2, uri, uri2, n, string5, bl, playerEntity, 7, null, null, null);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzc)this).zzl(parcel);
        }
    }
}

