/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new zza();
    private final String zzehx;
    private final String zzebw;
    private final String zzhbi;
    private final String zzhbj;
    private final String zzdmt;
    private final String zzhbk;
    private final Uri zzhbl;
    private final Uri zzhbm;
    private final Uri zzhbn;
    private final boolean zzhbo;
    private final boolean zzhbp;
    private final String zzhbq;
    private final int zzhbr;
    private final int zzhbs;
    private final int zzhbt;
    private final boolean zzhbu;
    private final boolean zzhbv;
    private final String zzhbw;
    private final String zzhbx;
    private final String zzhby;
    private final boolean zzckl;
    private final boolean zzhbz;
    private final boolean zzhca;
    private final String zzhcb;
    private final boolean zzhcc;

    public GameEntity(Game game) {
        this.zzehx = game.getApplicationId();
        this.zzhbi = game.getPrimaryCategory();
        this.zzhbj = game.getSecondaryCategory();
        this.zzdmt = game.getDescription();
        this.zzhbk = game.getDeveloperName();
        this.zzebw = game.getDisplayName();
        this.zzhbl = game.getIconImageUri();
        this.zzhbw = game.getIconImageUrl();
        this.zzhbm = game.getHiResImageUri();
        this.zzhbx = game.getHiResImageUrl();
        this.zzhbn = game.getFeaturedImageUri();
        this.zzhby = game.getFeaturedImageUrl();
        this.zzhbo = game.zzapi();
        this.zzhbp = game.zzapk();
        this.zzhbq = game.zzapl();
        this.zzhbr = 1;
        this.zzhbs = game.getAchievementTotalCount();
        this.zzhbt = game.getLeaderboardCount();
        this.zzhbu = game.isRealTimeMultiplayerEnabled();
        this.zzhbv = game.isTurnBasedMultiplayerEnabled();
        this.zzckl = game.isMuted();
        this.zzhbz = game.zzapj();
        this.zzhca = game.areSnapshotsEnabled();
        this.zzhcb = game.getThemeColor();
        this.zzhcc = game.hasGamepadSupport();
    }

    GameEntity(String string, String string2, String string3, String string4, String string5, String string6, Uri uri, Uri uri2, Uri uri3, boolean bl, boolean bl2, String string7, int n, int n2, int n3, boolean bl3, boolean bl4, String string8, String string9, String string10, boolean bl5, boolean bl6, boolean bl7, String string11, boolean bl8) {
        this.zzehx = string;
        this.zzebw = string2;
        this.zzhbi = string3;
        this.zzhbj = string4;
        this.zzdmt = string5;
        this.zzhbk = string6;
        this.zzhbl = uri;
        this.zzhbw = string8;
        this.zzhbm = uri2;
        this.zzhbx = string9;
        this.zzhbn = uri3;
        this.zzhby = string10;
        this.zzhbo = bl;
        this.zzhbp = bl2;
        this.zzhbq = string7;
        this.zzhbr = n;
        this.zzhbs = n2;
        this.zzhbt = n3;
        this.zzhbu = bl3;
        this.zzhbv = bl4;
        this.zzckl = bl5;
        this.zzhbz = bl6;
        this.zzhca = bl7;
        this.zzhcb = string11;
        this.zzhcc = bl8;
    }

    @Override
    public final String getApplicationId() {
        return this.zzehx;
    }

    @Override
    public final String getDisplayName() {
        return this.zzebw;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzebw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getPrimaryCategory() {
        return this.zzhbi;
    }

    @Override
    public final String getSecondaryCategory() {
        return this.zzhbj;
    }

    @Override
    public final String getDescription() {
        return this.zzdmt;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdmt, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDeveloperName() {
        return this.zzhbk;
    }

    @Override
    public final void getDeveloperName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhbk, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhbl;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhbw;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzhbm;
    }

    @Override
    public final String getHiResImageUrl() {
        return this.zzhbx;
    }

    @Override
    public final Uri getFeaturedImageUri() {
        return this.zzhbn;
    }

    @Override
    public final String getFeaturedImageUrl() {
        return this.zzhby;
    }

    @Override
    public final boolean isMuted() {
        return this.zzckl;
    }

    @Override
    public final boolean zzapj() {
        return this.zzhbz;
    }

    @Override
    public final boolean zzapi() {
        return this.zzhbo;
    }

    @Override
    public final boolean zzapk() {
        return this.zzhbp;
    }

    @Override
    public final String zzapl() {
        return this.zzhbq;
    }

    @Override
    public final int getAchievementTotalCount() {
        return this.zzhbs;
    }

    @Override
    public final int getLeaderboardCount() {
        return this.zzhbt;
    }

    @Override
    public final boolean isRealTimeMultiplayerEnabled() {
        return this.zzhbu;
    }

    @Override
    public final boolean isTurnBasedMultiplayerEnabled() {
        return this.zzhbv;
    }

    @Override
    public final boolean areSnapshotsEnabled() {
        return this.zzhca;
    }

    @Override
    public final String getThemeColor() {
        return this.zzhcb;
    }

    @Override
    public final boolean hasGamepadSupport() {
        return this.zzhcc;
    }

    public final Game freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return Arrays.hashCode(new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzapi(), game.zzapk(), game.zzapl(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzapj(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public final boolean equals(Object object) {
        return GameEntity.zza(this, object);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzbf.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzbf.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzbf.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzbf.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzbf.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzbf.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzbf.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzbf.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzbf.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzbf.equal((Object)game2.zzapi(), (Object)game.zzapi()) && zzbf.equal((Object)game2.zzapk(), (Object)game.zzapk()) && zzbf.equal((Object)game2.zzapl(), (Object)game.zzapl()) && zzbf.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzbf.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzbf.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzbf.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzbf.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzbf.equal((Object)game2.zzapj(), (Object)game.zzapj()) ? 1 : 0)) && zzbf.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzbf.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzbf.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public final String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzbf.zzt((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzapi()).zzg("InstanceInstalled", (Object)game.zzapk()).zzg("InstancePackageName", (Object)game.zzapl()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GameEntity gameEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (String)gameEntity.getApplicationId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)gameEntity.getDisplayName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (String)gameEntity.getPrimaryCategory(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (String)gameEntity.getSecondaryCategory(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (String)gameEntity.getDescription(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (String)gameEntity.getDeveloperName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)gameEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (Parcelable)gameEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)9, (Parcelable)gameEntity.getFeaturedImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)10, (boolean)gameEntity.zzhbo);
        zzbcn.zza((Parcel)parcel2, (int)11, (boolean)gameEntity.zzhbp);
        zzbcn.zza((Parcel)parcel2, (int)12, (String)gameEntity.zzhbq, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)13, (int)gameEntity.zzhbr);
        zzbcn.zzc((Parcel)parcel2, (int)14, (int)gameEntity.getAchievementTotalCount());
        zzbcn.zzc((Parcel)parcel2, (int)15, (int)gameEntity.getLeaderboardCount());
        zzbcn.zza((Parcel)parcel2, (int)16, (boolean)gameEntity.isRealTimeMultiplayerEnabled());
        zzbcn.zza((Parcel)parcel2, (int)17, (boolean)gameEntity.isTurnBasedMultiplayerEnabled());
        zzbcn.zza((Parcel)parcel2, (int)18, (String)gameEntity.getIconImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)19, (String)gameEntity.getHiResImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)20, (String)gameEntity.getFeaturedImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)21, (boolean)gameEntity.zzckl);
        zzbcn.zza((Parcel)parcel2, (int)22, (boolean)gameEntity.zzhbz);
        zzbcn.zza((Parcel)parcel2, (int)23, (boolean)gameEntity.areSnapshotsEnabled());
        zzbcn.zza((Parcel)parcel2, (int)24, (String)gameEntity.getThemeColor(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)25, (boolean)gameEntity.hasGamepadSupport());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends com.google.android.gms.games.zza {
        zza() {
        }

        @Override
        public final GameEntity zzi(Parcel parcel) {
            if (GameEntity.zze(GameEntity.zzakd()) || GameEntity.zzgb((String)GameEntity.class.getCanonicalName())) {
                return super.zzi(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl = parcel.readInt() > 0;
            boolean bl2 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            return new GameEntity(string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl, bl2, string10, n, n2, n3, false, false, null, null, null, false, false, false, null, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((com.google.android.gms.games.zza)this).zzi(parcel);
        }
    }
}

