/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.zzb;
import java.util.ArrayList;
import java.util.Arrays;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzhlc;
    private final String zzebw;
    private final Uri zzhbl;
    private final int zzhld;
    private final ArrayList<zzb> zzhle;
    private final Game zzhlf;
    private final String zzhbw;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzhlc = leaderboard.getLeaderboardId();
        this.zzebw = leaderboard.getDisplayName();
        this.zzhbl = leaderboard.getIconImageUri();
        this.zzhbw = leaderboard.getIconImageUrl();
        this.zzhld = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzhlf = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzhle = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzhle.add((zzb)arrayList.get(i).freeze());
        }
    }

    @Override
    public final String getLeaderboardId() {
        return this.zzhlc;
    }

    @Override
    public final String getDisplayName() {
        return this.zzebw;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzebw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhbl;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhbw;
    }

    @Override
    public final int getScoreOrder() {
        return this.zzhld;
    }

    @Override
    public final ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzhle);
    }

    @Override
    public final Game getGame() {
        return this.zzhlf;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return Arrays.hashCode(new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public final boolean equals(Object object) {
        return LeaderboardEntity.zza(this, object);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzbf.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzbf.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzbf.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzbf.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzbf.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public final String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzbf.zzt((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }
}

