/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.zzbcn;
import java.util.ArrayList;
import java.util.Arrays;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new zza();
    private final GameEntity zzhje;
    private final String zzdwu;
    private final long mCreationTimestamp;
    private final int zzhmi;
    private final ParticipantEntity zzhmj;
    private final ArrayList<ParticipantEntity> zzhmk;
    private final int zzhml;
    private final int zzhmm;

    InvitationEntity(Invitation invitation) {
        this.zzhje = new GameEntity(invitation.getGame());
        this.zzdwu = invitation.getInvitationId();
        this.mCreationTimestamp = invitation.getCreationTimestamp();
        this.zzhmi = invitation.getInvitationType();
        this.zzhml = invitation.getVariant();
        this.zzhmm = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.zzhmk = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.zzhmk.add((ParticipantEntity)participant2.freeze());
        }
        zzbp.zzb(participant, (Object)"Must have a valid inviter!");
        this.zzhmj = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(GameEntity gameEntity, String string, long l, int n, ParticipantEntity participantEntity, ArrayList<ParticipantEntity> arrayList, int n2, int n3) {
        this.zzhje = gameEntity;
        this.zzdwu = string;
        this.mCreationTimestamp = l;
        this.zzhmi = n;
        this.zzhmj = participantEntity;
        this.zzhmk = arrayList;
        this.zzhml = n2;
        this.zzhmm = n3;
    }

    @Override
    public final Game getGame() {
        return this.zzhje;
    }

    @Override
    public final String getInvitationId() {
        return this.zzdwu;
    }

    @Override
    public final Participant getInviter() {
        return this.zzhmj;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzhmk);
    }

    @Override
    public final int getInvitationType() {
        return this.zzhmi;
    }

    @Override
    public final int getVariant() {
        return this.zzhml;
    }

    @Override
    public final int getAvailableAutoMatchSlots() {
        return this.zzhmm;
    }

    public final Invitation freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return Arrays.hashCode(new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public final boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzbf.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzbf.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzbf.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzbf.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzbf.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzbf.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzbf.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzbf.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public final String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzbf.zzt((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        InvitationEntity invitationEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (Parcelable)invitationEntity.getGame(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)invitationEntity.getInvitationId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (long)invitationEntity.getCreationTimestamp());
        zzbcn.zzc((Parcel)parcel2, (int)4, (int)invitationEntity.getInvitationType());
        zzbcn.zza((Parcel)parcel2, (int)5, (Parcelable)invitationEntity.getInviter(), (int)n, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)6, invitationEntity.getParticipants(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)7, (int)invitationEntity.getVariant());
        zzbcn.zzc((Parcel)parcel2, (int)8, (int)invitationEntity.getAvailableAutoMatchSlots());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends com.google.android.gms.games.multiplayer.zza {
        zza() {
        }

        @Override
        public final InvitationEntity zzk(Parcel parcel) {
            if (InvitationEntity.zze(InvitationEntity.zzakd()) || InvitationEntity.zzgb((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzk(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n2 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new InvitationEntity(gameEntity, string, l, n, participantEntity, arrayList, -1, 0);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((com.google.android.gms.games.multiplayer.zza)this).zzk(parcel);
        }
    }
}

