/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.zza;
import com.google.android.gms.internal.zzbcn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class GameRequestEntity
extends zzc
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new zza();
    private final GameEntity zzhjf;
    private final PlayerEntity zzhok;
    private final byte[] zzhnq;
    private final String zzcjw;
    private final ArrayList<PlayerEntity> zzhol;
    private final int zzecz;
    private final long mCreationTimestamp;
    private final long zzhom;
    private final Bundle zzhon;
    private final int zzbyz;

    public GameRequestEntity(GameRequest gameRequest) {
        this.zzhjf = new GameEntity(gameRequest.getGame());
        this.zzhok = new PlayerEntity(gameRequest.getSender());
        this.zzcjw = gameRequest.getRequestId();
        this.zzecz = gameRequest.getType();
        this.mCreationTimestamp = gameRequest.getCreationTimestamp();
        this.zzhom = gameRequest.getExpirationTimestamp();
        this.zzbyz = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.zzhnq = null;
        } else {
            this.zzhnq = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzhnq, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.zzhol = new ArrayList(n);
        this.zzhon = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzhol.add((PlayerEntity)player);
            this.zzhon.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n, long l, long l2, Bundle bundle, int n2) {
        this.zzhjf = gameEntity;
        this.zzhok = playerEntity;
        this.zzhnq = byArray;
        this.zzcjw = string;
        this.zzhol = arrayList;
        this.zzecz = n;
        this.mCreationTimestamp = l;
        this.zzhom = l2;
        this.zzhon = bundle;
        this.zzbyz = n2;
    }

    @Override
    public final String getRequestId() {
        return this.zzcjw;
    }

    @Override
    public final Game getGame() {
        return this.zzhjf;
    }

    @Override
    public final Player getSender() {
        return this.zzhok;
    }

    @Override
    public final List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzhol);
    }

    @Override
    public final boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public final byte[] getData() {
        return this.zzhnq;
    }

    @Override
    public final int getType() {
        return this.zzecz;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final long getExpirationTimestamp() {
        return this.zzhom;
    }

    @Override
    public final int getRecipientStatus(String string) {
        return this.zzhon.getInt(string, 0);
    }

    @Override
    public final int getStatus() {
        return this.zzbyz;
    }

    public final GameRequest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return Arrays.hashCode(new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public final boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzbf.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzbf.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzbf.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzbf.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzbf.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzbf.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzbf.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public final String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzbf.zzt((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GameRequestEntity gameRequestEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (Parcelable)gameRequestEntity.getGame(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (Parcelable)gameRequestEntity.getSender(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (byte[])gameRequestEntity.getData(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (String)gameRequestEntity.getRequestId(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)5, gameRequestEntity.getRecipients(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)7, (int)gameRequestEntity.getType());
        zzbcn.zza((Parcel)parcel2, (int)9, (long)gameRequestEntity.getCreationTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)10, (long)gameRequestEntity.getExpirationTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)11, (Bundle)gameRequestEntity.zzhon, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)12, (int)gameRequestEntity.getStatus());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }
}

