/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import java.util.Arrays;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzhtz;
    private final String zzhua;
    private final String zzhub;
    private final long zzhuc;
    private final long zzhud;
    private final String zzhue;
    private final Uri zzhuf;
    private final Uri zzhug;
    private final PlayerEntity zzhuh;
    private final String zzhui;
    private final String zzhuj;
    private final String zzhuk;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zzhtz = leaderboardScore.getRank();
        this.zzhua = (String)zzbq.checkNotNull((Object)leaderboardScore.getDisplayRank());
        this.zzhub = (String)zzbq.checkNotNull((Object)leaderboardScore.getDisplayScore());
        this.zzhuc = leaderboardScore.getRawScore();
        this.zzhud = leaderboardScore.getTimestampMillis();
        this.zzhue = leaderboardScore.getScoreHolderDisplayName();
        this.zzhuf = leaderboardScore.getScoreHolderIconImageUri();
        this.zzhug = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zzhuh = player == null ? null : (PlayerEntity)player.freeze();
        this.zzhui = leaderboardScore.getScoreTag();
        this.zzhuj = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzhuk = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public final long getRank() {
        return this.zzhtz;
    }

    @Override
    public final String getDisplayRank() {
        return this.zzhua;
    }

    @Override
    public final void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhua, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDisplayScore() {
        return this.zzhub;
    }

    @Override
    public final void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhub, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getRawScore() {
        return this.zzhuc;
    }

    @Override
    public final long getTimestampMillis() {
        return this.zzhud;
    }

    @Override
    public final String getScoreHolderDisplayName() {
        if (this.zzhuh == null) {
            return this.zzhue;
        }
        return this.zzhuh.getDisplayName();
    }

    @Override
    public final void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhuh == null) {
            zzg.zzb((String)this.zzhue, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzhuh.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getScoreHolderIconImageUri() {
        if (this.zzhuh == null) {
            return this.zzhuf;
        }
        return this.zzhuh.getIconImageUri();
    }

    @Override
    public final String getScoreHolderIconImageUrl() {
        if (this.zzhuh == null) {
            return this.zzhuj;
        }
        return this.zzhuh.getIconImageUrl();
    }

    @Override
    public final Uri getScoreHolderHiResImageUri() {
        if (this.zzhuh == null) {
            return this.zzhug;
        }
        return this.zzhuh.getHiResImageUri();
    }

    @Override
    public final String getScoreHolderHiResImageUrl() {
        if (this.zzhuh == null) {
            return this.zzhuk;
        }
        return this.zzhuh.getHiResImageUrl();
    }

    @Override
    public final Player getScoreHolder() {
        return this.zzhuh;
    }

    @Override
    public final String getScoreTag() {
        return this.zzhui;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return Arrays.hashCode(new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public final boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzbg.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzbg.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzbg.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzbg.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzbg.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzbg.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzbg.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzbg.zzw((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }
}

