/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantRef;
import java.util.ArrayList;

public final class zzb
extends zzc
implements Invitation {
    private final Game zzhtw;
    private final ParticipantRef zzhve;
    private final ArrayList<Participant> zzhvb;

    zzb(DataHolder dataHolder, int n, int n2) {
        super(dataHolder, n);
        this.zzhtw = new GameRef(dataHolder, n);
        this.zzhvb = new ArrayList(n2);
        ParticipantRef participantRef = null;
        String string = this.getString("external_inviter_id");
        for (int i = 0; i < n2; ++i) {
            ParticipantRef participantRef2 = new ParticipantRef(this.zzfoj, this.zzftn + i);
            if (participantRef2.getParticipantId().equals(string)) {
                participantRef = participantRef2;
            }
            this.zzhvb.add(participantRef2);
        }
        this.zzhve = (ParticipantRef)zzbq.checkNotNull(participantRef, (Object)"Must have a valid inviter!");
    }

    @Override
    public final Game getGame() {
        return this.zzhtw;
    }

    @Override
    public final String getInvitationId() {
        return this.getString("external_invitation_id");
    }

    @Override
    public final Participant getInviter() {
        return this.zzhve;
    }

    @Override
    public final long getCreationTimestamp() {
        long l = this.getLong("creation_timestamp");
        long l2 = this.getLong("last_modified_timestamp");
        return Math.max(l, l2);
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return this.zzhvb;
    }

    @Override
    public final int getInvitationType() {
        return this.getInteger("type");
    }

    @Override
    public final int getVariant() {
        return this.getInteger("variant");
    }

    @Override
    public final int getAvailableAutoMatchSlots() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return 0;
        }
        return this.getInteger("automatch_max_players");
    }

    public final int hashCode() {
        return InvitationEntity.zza(this);
    }

    public final boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    public final String toString() {
        return InvitationEntity.zzb(this);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        ((InvitationEntity)((Invitation)this.freeze())).writeToParcel(parcel, n);
    }

    public final /* synthetic */ Object freeze() {
        zzb zzb2 = this;
        return new InvitationEntity(zzb2);
    }
}

