/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.games.video.zzb;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class VideoConfiguration
extends zzbej {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new zzb();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int zzhyv;
    private final int zzhyo;
    private final String zzhyw;
    private final String zzhyx;
    private final String zzhyy;
    private final String zzhyz;
    private final boolean zzhza;

    public VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        zzbq.checkArgument((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        zzbq.checkArgument((boolean)VideoConfiguration.isValidCaptureMode(n2, false));
        this.zzhyv = n;
        this.zzhyo = n2;
        this.zzhza = bl;
        if (n2 == 1) {
            this.zzhyx = string2;
            this.zzhyw = string;
            this.zzhyy = string3;
            this.zzhyz = string4;
            return;
        }
        zzbq.checkArgument((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
        zzbq.checkArgument((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
        zzbq.checkArgument((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
        zzbq.checkArgument((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
        this.zzhyx = null;
        this.zzhyw = null;
        this.zzhyy = null;
        this.zzhyz = null;
    }

    public final int getQualityLevel() {
        return this.zzhyv;
    }

    public final int getCaptureMode() {
        return this.zzhyo;
    }

    public final String getStreamUrl() {
        return this.zzhyw;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoConfiguration videoConfiguration = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)1, (int)videoConfiguration.getQualityLevel());
        zzbem.zzc((Parcel)parcel2, (int)2, (int)videoConfiguration.getCaptureMode());
        zzbem.zza((Parcel)parcel2, (int)3, (String)videoConfiguration.getStreamUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (String)videoConfiguration.zzhyx, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (String)videoConfiguration.zzhyy, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, (String)videoConfiguration.zzhyz, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (boolean)videoConfiguration.zzhza);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zzhyv;
        private int zzhyo;
        private boolean zzhza;
        private String zzhyw;
        private String zzhyx;
        private String zzhyy;
        private String zzhyz;

        public Builder(int n, int n2) {
            this.zzhyv = n;
            this.zzhyo = n2;
            this.zzhza = true;
            this.zzhyw = null;
            this.zzhyx = null;
            this.zzhyy = null;
            this.zzhyz = null;
        }

        public final Builder setQualityLevel(int n) {
            this.zzhyv = n;
            return this;
        }

        public final Builder setCaptureMode(int n) {
            this.zzhyo = n;
            return this;
        }

        public final VideoConfiguration build() {
            return new VideoConfiguration(this.zzhyv, this.zzhyo, null, null, null, null, this.zzhza);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ValidCaptureModes {
    }
}

