/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.games.AchievementsClient;
import com.google.android.gms.games.EventsClient;
import com.google.android.gms.games.GamesClient;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesMetadataClient;
import com.google.android.gms.games.InvitationsClient;
import com.google.android.gms.games.LeaderboardsClient;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.NotificationsClient;
import com.google.android.gms.games.PlayerStatsClient;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.PlayersClient;
import com.google.android.gms.games.RealTimeMultiplayerClient;
import com.google.android.gms.games.SnapshotsClient;
import com.google.android.gms.games.TurnBasedMultiplayerClient;
import com.google.android.gms.games.VideosClient;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.zzad;
import com.google.android.gms.games.internal.api.zzah;
import com.google.android.gms.games.internal.api.zzax;
import com.google.android.gms.games.internal.api.zzay;
import com.google.android.gms.games.internal.api.zzaz;
import com.google.android.gms.games.internal.api.zzbj;
import com.google.android.gms.games.internal.api.zzbu;
import com.google.android.gms.games.internal.api.zzbv;
import com.google.android.gms.games.internal.api.zzcd;
import com.google.android.gms.games.internal.api.zzcr;
import com.google.android.gms.games.internal.api.zzcs;
import com.google.android.gms.games.internal.api.zzcw;
import com.google.android.gms.games.internal.api.zzdt;
import com.google.android.gms.games.internal.api.zzo;
import com.google.android.gms.games.internal.api.zzq;
import com.google.android.gms.games.internal.api.zzy;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.games.zzi;
import com.google.android.gms.games.zzj;
import com.google.android.gms.games.zzk;
import com.google.android.gms.games.zzl;
import com.google.android.gms.games.zzm;
import com.google.android.gms.internal.zzcaa;
import com.google.android.gms.internal.zzcai;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@KeepForSdk
public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    public static final String EXTRA_STATUS = "status";
    static final Api.zzf<GamesClientImpl> zzdyh = new Api.zzf();
    private static final Api.zza<GamesClientImpl, GamesOptions> zzdyi = new zzi();
    private static final Api.zza<GamesClientImpl, GamesOptions> zzhhn = new zzj();
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Scope SCOPE_GAMES_LITE = new Scope("https://www.googleapis.com/auth/games_lite");
    @Deprecated
    public static final Api<GamesOptions> API = new Api("Games.API", zzdyi, zzdyh);
    public static final Scope zzhho = new Scope("https://www.googleapis.com/auth/games.firstparty");
    private static Api<GamesOptions> zzhhp = new Api("Games.API_1P", zzhhn, zzdyh);
    @Deprecated
    public static final GamesMetadata GamesMetadata = new zzy();
    @Deprecated
    public static final Achievements Achievements = new com.google.android.gms.games.internal.api.zza();
    private static zzcaa zzhhq = new zzo();
    @Deprecated
    public static final Events Events = new zzq();
    @Deprecated
    public static final Leaderboards Leaderboards = new zzah();
    @Deprecated
    public static final Invitations Invitations = new zzad();
    @Deprecated
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new zzcw();
    @Deprecated
    public static final RealTimeMultiplayer RealTimeMultiplayer = new zzbu();
    private static Multiplayer zzhhr = new zzax();
    @Deprecated
    public static final Players Players = new zzaz();
    @Deprecated
    public static final Notifications Notifications = new zzay();
    @Deprecated
    public static final Quests Quests = new zzbj();
    @Deprecated
    public static final Requests Requests = new zzbv();
    @Deprecated
    public static final Snapshots Snapshots = new zzcd();
    @Deprecated
    public static final Stats Stats = new zzcs();
    @Deprecated
    public static final Videos Videos = new zzdt();
    private static zzcai zzhhs = new zzcr();

    private Games() {
    }

    public static GamesClientImpl zzg(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true);
    }

    public static GamesClientImpl zza(GoogleApiClient googleApiClient, boolean bl) {
        zzbq.checkArgument((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzbq.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return Games.zzb(googleApiClient, bl);
    }

    public static GamesClientImpl zzb(GoogleApiClient googleApiClient, boolean bl) {
        zzbq.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Games.API and is not connected to Games. Use GoogleApiClient.hasConnectedApi(Games.API) to guard this call.");
        }
        if (bl2) {
            return (GamesClientImpl)googleApiClient.zza(zzdyh);
        }
        return null;
    }

    @Deprecated
    public static void setGravityForPopups(GoogleApiClient googleApiClient, int n) {
        GamesClientImpl gamesClientImpl = Games.zza(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzdi(n);
        }
    }

    @Deprecated
    public static void setViewForPopups(GoogleApiClient googleApiClient, View view) {
        zzbq.checkNotNull((Object)view);
        GamesClientImpl gamesClientImpl = Games.zza(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzu(view);
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    public static String getCurrentAccountName(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzarh();
    }

    @Deprecated
    @KeepForSdk
    public static PendingResult<GetServerAuthCodeResult> getGamesServerAuthCode(GoogleApiClient googleApiClient, String string) {
        zzbq.zzh((String)string, (Object)"Please provide a valid serverClientId");
        return googleApiClient.zze((com.google.android.gms.common.api.internal.zzm)new zzk(googleApiClient, string));
    }

    @Deprecated
    public static String getAppId(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzasc();
    }

    @Deprecated
    public static Intent getSettingsIntent(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzarz();
    }

    @Deprecated
    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.zze((com.google.android.gms.common.api.internal.zzm)new zzl(googleApiClient));
    }

    public static GamesMetadataClient getGamesMetadataClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new GamesMetadataClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static GamesMetadataClient getGamesMetadataClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new GamesMetadataClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static AchievementsClient getAchievementsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new AchievementsClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static AchievementsClient getAchievementsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new AchievementsClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static EventsClient getEventsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new EventsClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static EventsClient getEventsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new EventsClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static LeaderboardsClient getLeaderboardsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new LeaderboardsClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static LeaderboardsClient getLeaderboardsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new LeaderboardsClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static InvitationsClient getInvitationsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new InvitationsClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static InvitationsClient getInvitationsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new InvitationsClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static TurnBasedMultiplayerClient getTurnBasedMultiplayerClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new TurnBasedMultiplayerClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static TurnBasedMultiplayerClient getTurnBasedMultiplayerClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new TurnBasedMultiplayerClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static RealTimeMultiplayerClient getRealTimeMultiplayerClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new RealTimeMultiplayerClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static RealTimeMultiplayerClient getRealTimeMultiplayerClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new RealTimeMultiplayerClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static PlayersClient getPlayersClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new PlayersClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static PlayersClient getPlayersClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new PlayersClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static NotificationsClient getNotificationsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new NotificationsClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static NotificationsClient getNotificationsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new NotificationsClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static SnapshotsClient getSnapshotsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new SnapshotsClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static SnapshotsClient getSnapshotsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new SnapshotsClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static PlayerStatsClient getPlayerStatsClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new PlayerStatsClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static PlayerStatsClient getPlayerStatsClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new PlayerStatsClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static VideosClient getVideosClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new VideosClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static VideosClient getVideosClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new VideosClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static GamesClient getGamesClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new GamesClient(activity, GamesOptions.zza(googleSignInAccount, null).build());
    }

    public static GamesClient getGamesClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount, (Object)"GoogleSignInAccount must not be null");
        return new GamesClient(context, GamesOptions.zza(googleSignInAccount, null).build());
    }

    @Deprecated
    public static int getSdkVariant(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzasb();
    }

    static abstract class zzd
    extends zza<Status> {
        private zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public final /* synthetic */ Result zzb(Status status) {
            return status;
        }

        /* synthetic */ zzd(GoogleApiClient googleApiClient, zzi zzi2) {
            this(googleApiClient);
        }
    }

    static abstract class zzc
    extends zza<GetServerAuthCodeResult> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            zzc zzc2 = this;
            return new zzm(zzc2, status2);
        }

        /* synthetic */ zzc(GoogleApiClient googleApiClient, zzi zzi2) {
            this(googleApiClient);
        }
    }

    @Deprecated
    @KeepForSdk
    public static interface GetServerAuthCodeResult
    extends Result {
        @KeepForSdk
        public String getCode();
    }

    public static abstract class zza<R extends Result>
    extends com.google.android.gms.common.api.internal.zzm<R, GamesClientImpl> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzdyh, googleApiClient);
        }
    }

    static abstract class zzb
    extends Api.zza<GamesClientImpl, GamesOptions> {
        private zzb() {
        }

        public final int getPriority() {
            return 1;
        }

        public final /* synthetic */ Api.zze zza(Context context, Looper looper, zzr zzr2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
            GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
            GamesOptions gamesOptions = (GamesOptions)object;
            zzr zzr3 = zzr2;
            Looper looper2 = looper;
            Context context2 = context;
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions.Builder(null).build();
            }
            return new GamesClientImpl(context2, looper2, zzr3, gamesOptions, connectionCallbacks2, onConnectionFailedListener2);
        }

        /* synthetic */ zzb(zzi zzi2) {
            this();
        }
    }

    @Deprecated
    public static final class GamesOptions
    implements GoogleSignInOptionsExtension,
    Api.ApiOptions.HasGoogleSignInAccountOptions,
    Api.ApiOptions.Optional {
        public final boolean zzhhu;
        public final boolean zzhhv;
        public final int zzhhw;
        public final boolean zzhhx;
        public final int zzhhy;
        public final String zzhhz;
        public final ArrayList<String> zzhia;
        public final boolean zzhib;
        public final boolean zzhic;
        public final boolean zzhid;
        public final GoogleSignInAccount zzhie;

        private GamesOptions(boolean bl, boolean bl2, int n, boolean bl3, int n2, String string, ArrayList<String> arrayList, boolean bl4, boolean bl5, boolean bl6, GoogleSignInAccount googleSignInAccount) {
            this.zzhhu = bl;
            this.zzhhv = bl2;
            this.zzhhw = n;
            this.zzhhx = bl3;
            this.zzhhy = n2;
            this.zzhhz = string;
            this.zzhia = arrayList;
            this.zzhib = bl4;
            this.zzhic = bl5;
            this.zzhid = bl6;
            this.zzhie = googleSignInAccount;
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof GamesOptions)) {
                return false;
            }
            GamesOptions gamesOptions = (GamesOptions)object;
            return this.zzhhu == gamesOptions.zzhhu && this.zzhhv == gamesOptions.zzhhv && this.zzhhw == gamesOptions.zzhhw && this.zzhhx == gamesOptions.zzhhx && this.zzhhy == gamesOptions.zzhhy && (this.zzhhz == null ? gamesOptions.zzhhz == null : this.zzhhz.equals(gamesOptions.zzhhz)) && this.zzhia.equals(gamesOptions.zzhia) && this.zzhib == gamesOptions.zzhib && this.zzhic == gamesOptions.zzhic && this.zzhid == gamesOptions.zzhid && (this.zzhie == null ? gamesOptions.zzhie == null : this.zzhie.equals((Object)gamesOptions.zzhie));
        }

        public final int hashCode() {
            int n = 527 + (this.zzhhu ? 1 : 0);
            n = n * 31 + (this.zzhhv ? 1 : 0);
            n = n * 31 + this.zzhhw;
            n = n * 31 + (this.zzhhx ? 1 : 0);
            n = n * 31 + this.zzhhy;
            n = n * 31 + (this.zzhhz == null ? 0 : this.zzhhz.hashCode());
            n = n * 31 + this.zzhia.hashCode();
            n = n * 31 + (this.zzhib ? 1 : 0);
            n = n * 31 + (this.zzhic ? 1 : 0);
            n = n * 31 + (this.zzhid ? 1 : 0);
            return n * 31 + (this.zzhie == null ? 0 : this.zzhie.hashCode());
        }

        public final int getExtensionType() {
            return 1;
        }

        public final List<Scope> getImpliedScopes() {
            if (this.zzhib) {
                return Collections.singletonList(SCOPE_GAMES);
            }
            return Collections.singletonList(SCOPE_GAMES_LITE);
        }

        public final Bundle toBundle() {
            return this.zzaqw();
        }

        public final Bundle zzaqw() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.zzhhu);
            bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.zzhhv);
            bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.zzhhw);
            bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.zzhhx);
            bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.zzhhy);
            bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.zzhhz);
            bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.zzhia);
            bundle.putBoolean("com.google.android.gms.games.key.requireGooglePlus", this.zzhib);
            bundle.putBoolean("com.google.android.gms.games.key.unauthenticated", this.zzhic);
            bundle.putBoolean("com.google.android.gms.games.key.skipWelcomePopup", this.zzhid);
            return bundle;
        }

        public static Builder builder() {
            return new Builder(null);
        }

        public static Builder zza(@NonNull GoogleSignInAccount googleSignInAccount, @Nullable GamesOptions gamesOptions) {
            GoogleSignInAccount googleSignInAccount2 = googleSignInAccount;
            Builder builder = new Builder(null, null);
            new Builder(null, null).zzhie = googleSignInAccount2;
            return builder;
        }

        public final GoogleSignInAccount getGoogleSignInAccount() {
            return this.zzhie;
        }

        /* synthetic */ GamesOptions(boolean bl, boolean bl2, int n, boolean bl3, int n2, String string, ArrayList arrayList, boolean bl4, boolean bl5, boolean bl6, GoogleSignInAccount googleSignInAccount, zzi zzi2) {
            this(bl, bl2, n, bl3, n2, string, arrayList, bl4, bl5, bl6, googleSignInAccount);
        }

        @Deprecated
        public static final class Builder {
            private boolean zzhhu = false;
            private boolean zzhhv = true;
            private int zzhhw = 17;
            private boolean zzhhx = false;
            private int zzhhy = 4368;
            private String zzhhz = null;
            private ArrayList<String> zzhia = new ArrayList();
            private boolean zzhib = false;
            private boolean zzhic = false;
            private boolean zzhid = false;
            GoogleSignInAccount zzhie = null;

            private Builder() {
            }

            private Builder(GamesOptions gamesOptions) {
                if (gamesOptions != null) {
                    this.zzhhu = gamesOptions.zzhhu;
                    this.zzhhv = gamesOptions.zzhhv;
                    this.zzhhw = gamesOptions.zzhhw;
                    this.zzhhx = gamesOptions.zzhhx;
                    this.zzhhy = gamesOptions.zzhhy;
                    this.zzhhz = gamesOptions.zzhhz;
                    this.zzhia = gamesOptions.zzhia;
                    this.zzhib = gamesOptions.zzhib;
                    this.zzhic = gamesOptions.zzhic;
                    this.zzhid = gamesOptions.zzhid;
                    this.zzhie = gamesOptions.zzhie;
                }
            }

            public final Builder setShowConnectingPopup(boolean bl) {
                this.zzhhv = bl;
                this.zzhhw = 17;
                return this;
            }

            public final Builder setShowConnectingPopup(boolean bl, int n) {
                this.zzhhv = bl;
                this.zzhhw = n;
                return this;
            }

            public final Builder setSdkVariant(int n) {
                this.zzhhy = n;
                return this;
            }

            public final GamesOptions build() {
                return new GamesOptions(this.zzhhu, this.zzhhv, this.zzhhw, this.zzhhx, this.zzhhy, this.zzhhz, this.zzhia, this.zzhib, this.zzhic, this.zzhid, this.zzhie, null);
            }

            /* synthetic */ Builder(zzi zzi2) {
                this();
            }

            /* synthetic */ Builder(GamesOptions gamesOptions, zzi zzi2) {
                this((GamesOptions)null);
            }
        }
    }
}

