/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.zzb;
import java.util.ArrayList;
import java.util.Arrays;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzhtj;
    private final String zzedu;
    private final Uri zzhgv;
    private final int zzhtk;
    private final ArrayList<zzb> zzhtl;
    private final Game zzhtm;
    private final String zzhhg;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzhtj = leaderboard.getLeaderboardId();
        this.zzedu = leaderboard.getDisplayName();
        this.zzhgv = leaderboard.getIconImageUri();
        this.zzhhg = leaderboard.getIconImageUrl();
        this.zzhtk = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzhtm = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzhtl = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzhtl.add((zzb)arrayList.get(i).freeze());
        }
    }

    @Override
    public final String getLeaderboardId() {
        return this.zzhtj;
    }

    @Override
    public final String getDisplayName() {
        return this.zzedu;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzedu, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhgv;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhhg;
    }

    @Override
    public final int getScoreOrder() {
        return this.zzhtk;
    }

    @Override
    public final ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzhtl);
    }

    @Override
    public final Game getGame() {
        return this.zzhtm;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return Arrays.hashCode(new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public final boolean equals(Object object) {
        return LeaderboardEntity.zza(this, object);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzbg.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzbg.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzbg.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzbg.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzbg.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public final String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzbg.zzw((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }
}

