/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.zza;
import com.google.android.gms.internal.zzbem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class GameRequestEntity
extends zzc
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new zza();
    private final GameEntity zzhrl;
    private final PlayerEntity zzhwv;
    private final byte[] zzhwb;
    private final String zzcqb;
    private final ArrayList<PlayerEntity> zzhww;
    private final int zzefe;
    private final long mCreationTimestamp;
    private final long zzhwx;
    private final Bundle zzhwy;
    private final int zzbzn;

    public GameRequestEntity(GameRequest gameRequest) {
        this.zzhrl = new GameEntity(gameRequest.getGame());
        this.zzhwv = new PlayerEntity(gameRequest.getSender());
        this.zzcqb = gameRequest.getRequestId();
        this.zzefe = gameRequest.getType();
        this.mCreationTimestamp = gameRequest.getCreationTimestamp();
        this.zzhwx = gameRequest.getExpirationTimestamp();
        this.zzbzn = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.zzhwb = null;
        } else {
            this.zzhwb = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzhwb, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.zzhww = new ArrayList(n);
        this.zzhwy = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzhww.add((PlayerEntity)player);
            this.zzhwy.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n, long l, long l2, Bundle bundle, int n2) {
        this.zzhrl = gameEntity;
        this.zzhwv = playerEntity;
        this.zzhwb = byArray;
        this.zzcqb = string;
        this.zzhww = arrayList;
        this.zzefe = n;
        this.mCreationTimestamp = l;
        this.zzhwx = l2;
        this.zzhwy = bundle;
        this.zzbzn = n2;
    }

    @Override
    public final String getRequestId() {
        return this.zzcqb;
    }

    @Override
    public final Game getGame() {
        return this.zzhrl;
    }

    @Override
    public final Player getSender() {
        return this.zzhwv;
    }

    @Override
    public final List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzhww);
    }

    @Override
    public final boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public final byte[] getData() {
        return this.zzhwb;
    }

    @Override
    public final int getType() {
        return this.zzefe;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final long getExpirationTimestamp() {
        return this.zzhwx;
    }

    @Override
    public final int getRecipientStatus(String string) {
        return this.zzhwy.getInt(string, 0);
    }

    @Override
    public final int getStatus() {
        return this.zzbzn;
    }

    public final GameRequest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return Arrays.hashCode(new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public final boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzbg.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzbg.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzbg.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzbg.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzbg.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzbg.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzbg.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public final String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzbg.zzw((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GameRequestEntity gameRequestEntity = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (Parcelable)gameRequestEntity.getGame(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)2, (Parcelable)gameRequestEntity.getSender(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (byte[])gameRequestEntity.getData(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (String)gameRequestEntity.getRequestId(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)5, gameRequestEntity.getRecipients(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)7, (int)gameRequestEntity.getType());
        zzbem.zza((Parcel)parcel2, (int)9, (long)gameRequestEntity.getCreationTimestamp());
        zzbem.zza((Parcel)parcel2, (int)10, (long)gameRequestEntity.getExpirationTimestamp());
        zzbem.zza((Parcel)parcel2, (int)11, (Bundle)gameRequestEntity.zzhwy, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)12, (int)gameRequestEntity.getStatus());
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }
}

