/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.zze;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new zze();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzaua();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzdou;
        private Long zzhxc;
        private Long zzhxd;
        private BitmapTeleporter zzhxe;
        private Uri zzhxf;

        public Builder() {
        }

        public final Builder setDescription(String string) {
            this.zzdou = string;
            return this;
        }

        public final Builder setPlayedTimeMillis(long l) {
            this.zzhxc = l;
            return this;
        }

        public final Builder setProgressValue(long l) {
            this.zzhxd = l;
            return this;
        }

        public final Builder setCoverImage(Bitmap bitmap) {
            this.zzhxe = new BitmapTeleporter(bitmap);
            this.zzhxf = null;
            return this;
        }

        public final Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzdou = snapshotMetadata.getDescription();
            this.zzhxc = snapshotMetadata.getPlayedTime();
            this.zzhxd = snapshotMetadata.getProgressValue();
            if (this.zzhxc == -1L) {
                this.zzhxc = null;
            }
            this.zzhxf = snapshotMetadata.getCoverImageUri();
            if (this.zzhxf != null) {
                this.zzhxe = null;
            }
            return this;
        }

        public final SnapshotMetadataChange build() {
            return new zze(this.zzdou, this.zzhxc, this.zzhxe, this.zzhxf, this.zzhxd);
        }
    }
}

