/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.zzh;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new zza();
    private final String zzenh;
    private final String zzegt;
    private final String zzhjn;
    private final String zzhjo;
    private final String zzdrs;
    private final String zzhjp;
    private final Uri zzhjq;
    private final Uri zzhjr;
    private final Uri zzhjs;
    private final boolean zzhjt;
    private final boolean zzhju;
    private final String zzhjv;
    private final int zzhjw;
    private final int zzhjx;
    private final int zzhjy;
    private final boolean zzhjz;
    private final boolean zzhka;
    private final String zzhkb;
    private final String zzhkc;
    private final String zzhkd;
    private final boolean zzdjt;
    private final boolean zzhke;
    private final boolean zzhkf;
    private final String zzhkg;
    private final boolean zzhkh;

    public GameEntity(Game game) {
        this.zzenh = game.getApplicationId();
        this.zzhjn = game.getPrimaryCategory();
        this.zzhjo = game.getSecondaryCategory();
        this.zzdrs = game.getDescription();
        this.zzhjp = game.getDeveloperName();
        this.zzegt = game.getDisplayName();
        this.zzhjq = game.getIconImageUri();
        this.zzhkb = game.getIconImageUrl();
        this.zzhjr = game.getHiResImageUri();
        this.zzhkc = game.getHiResImageUrl();
        this.zzhjs = game.getFeaturedImageUri();
        this.zzhkd = game.getFeaturedImageUrl();
        this.zzhjt = game.zzard();
        this.zzhju = game.zzarf();
        this.zzhjv = game.zzarg();
        this.zzhjw = 1;
        this.zzhjx = game.getAchievementTotalCount();
        this.zzhjy = game.getLeaderboardCount();
        this.zzhjz = game.isRealTimeMultiplayerEnabled();
        this.zzhka = game.isTurnBasedMultiplayerEnabled();
        this.zzdjt = game.isMuted();
        this.zzhke = game.zzare();
        this.zzhkf = game.areSnapshotsEnabled();
        this.zzhkg = game.getThemeColor();
        this.zzhkh = game.hasGamepadSupport();
    }

    GameEntity(String string, String string2, String string3, String string4, String string5, String string6, Uri uri, Uri uri2, Uri uri3, boolean bl, boolean bl2, String string7, int n, int n2, int n3, boolean bl3, boolean bl4, String string8, String string9, String string10, boolean bl5, boolean bl6, boolean bl7, String string11, boolean bl8) {
        this.zzenh = string;
        this.zzegt = string2;
        this.zzhjn = string3;
        this.zzhjo = string4;
        this.zzdrs = string5;
        this.zzhjp = string6;
        this.zzhjq = uri;
        this.zzhkb = string8;
        this.zzhjr = uri2;
        this.zzhkc = string9;
        this.zzhjs = uri3;
        this.zzhkd = string10;
        this.zzhjt = bl;
        this.zzhju = bl2;
        this.zzhjv = string7;
        this.zzhjw = n;
        this.zzhjx = n2;
        this.zzhjy = n3;
        this.zzhjz = bl3;
        this.zzhka = bl4;
        this.zzdjt = bl5;
        this.zzhke = bl6;
        this.zzhkf = bl7;
        this.zzhkg = string11;
        this.zzhkh = bl8;
    }

    @Override
    public final String getApplicationId() {
        return this.zzenh;
    }

    @Override
    public final String getDisplayName() {
        return this.zzegt;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzegt, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getPrimaryCategory() {
        return this.zzhjn;
    }

    @Override
    public final String getSecondaryCategory() {
        return this.zzhjo;
    }

    @Override
    public final String getDescription() {
        return this.zzdrs;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdrs, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDeveloperName() {
        return this.zzhjp;
    }

    @Override
    public final void getDeveloperName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhjp, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhjq;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhkb;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzhjr;
    }

    @Override
    public final String getHiResImageUrl() {
        return this.zzhkc;
    }

    @Override
    public final Uri getFeaturedImageUri() {
        return this.zzhjs;
    }

    @Override
    public final String getFeaturedImageUrl() {
        return this.zzhkd;
    }

    @Override
    public final boolean isMuted() {
        return this.zzdjt;
    }

    @Override
    public final boolean zzare() {
        return this.zzhke;
    }

    @Override
    public final boolean zzard() {
        return this.zzhjt;
    }

    @Override
    public final boolean zzarf() {
        return this.zzhju;
    }

    @Override
    public final String zzarg() {
        return this.zzhjv;
    }

    @Override
    public final int getAchievementTotalCount() {
        return this.zzhjx;
    }

    @Override
    public final int getLeaderboardCount() {
        return this.zzhjy;
    }

    @Override
    public final boolean isRealTimeMultiplayerEnabled() {
        return this.zzhjz;
    }

    @Override
    public final boolean isTurnBasedMultiplayerEnabled() {
        return this.zzhka;
    }

    @Override
    public final boolean areSnapshotsEnabled() {
        return this.zzhkf;
    }

    @Override
    public final String getThemeColor() {
        return this.zzhkg;
    }

    @Override
    public final boolean hasGamepadSupport() {
        return this.zzhkh;
    }

    public final Game freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return Arrays.hashCode(new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzard(), game.zzarf(), game.zzarg(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzare(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public final boolean equals(Object object) {
        return GameEntity.zza(this, object);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzbg.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzbg.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzbg.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzbg.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzbg.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzbg.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzbg.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzbg.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzbg.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzbg.equal((Object)game2.zzard(), (Object)game.zzard()) && zzbg.equal((Object)game2.zzarf(), (Object)game.zzarf()) && zzbg.equal((Object)game2.zzarg(), (Object)game.zzarg()) && zzbg.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzbg.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzbg.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzbg.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzbg.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzbg.equal((Object)game2.zzare(), (Object)game.zzare()) ? 1 : 0)) && zzbg.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzbg.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzbg.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public final String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzbg.zzx((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzard()).zzg("InstanceInstalled", (Object)game.zzarf()).zzg("InstancePackageName", (Object)game.zzarg()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GameEntity gameEntity = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (String)gameEntity.getApplicationId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)gameEntity.getDisplayName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (String)gameEntity.getPrimaryCategory(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (String)gameEntity.getSecondaryCategory(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (String)gameEntity.getDescription(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (String)gameEntity.getDeveloperName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (Parcelable)gameEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)8, (Parcelable)gameEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)9, (Parcelable)gameEntity.getFeaturedImageUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)10, (boolean)gameEntity.zzhjt);
        zzbfp.zza((Parcel)parcel2, (int)11, (boolean)gameEntity.zzhju);
        zzbfp.zza((Parcel)parcel2, (int)12, (String)gameEntity.zzhjv, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)13, (int)gameEntity.zzhjw);
        zzbfp.zzc((Parcel)parcel2, (int)14, (int)gameEntity.getAchievementTotalCount());
        zzbfp.zzc((Parcel)parcel2, (int)15, (int)gameEntity.getLeaderboardCount());
        zzbfp.zza((Parcel)parcel2, (int)16, (boolean)gameEntity.isRealTimeMultiplayerEnabled());
        zzbfp.zza((Parcel)parcel2, (int)17, (boolean)gameEntity.isTurnBasedMultiplayerEnabled());
        zzbfp.zza((Parcel)parcel2, (int)18, (String)gameEntity.getIconImageUrl(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)19, (String)gameEntity.getHiResImageUrl(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)20, (String)gameEntity.getFeaturedImageUrl(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)21, (boolean)gameEntity.zzdjt);
        zzbfp.zza((Parcel)parcel2, (int)22, (boolean)gameEntity.zzhke);
        zzbfp.zza((Parcel)parcel2, (int)23, (boolean)gameEntity.areSnapshotsEnabled());
        zzbfp.zza((Parcel)parcel2, (int)24, (String)gameEntity.getThemeColor(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)25, (boolean)gameEntity.hasGamepadSupport());
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzh {
        zza() {
        }

        @Override
        public final GameEntity zzi(Parcel parcel) {
            if (GameEntity.zze(GameEntity.zzalg()) || GameEntity.zzgh((String)GameEntity.class.getCanonicalName())) {
                return super.zzi(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl = parcel.readInt() > 0;
            boolean bl2 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            return new GameEntity(string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl, bl2, string10, n, n2, n3, false, false, null, null, null, false, false, false, null, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzh)this).zzi(parcel);
        }
    }
}

