/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.zzg;
import com.google.android.gms.games.internal.zzo;
import com.google.android.gms.games.internal.zzp;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.zzab;
import com.google.android.gms.games.zzac;
import com.google.android.gms.games.zzad;
import com.google.android.gms.games.zzae;
import com.google.android.gms.games.zzaf;
import com.google.android.gms.games.zzag;
import com.google.android.gms.games.zzah;
import com.google.android.gms.games.zzai;
import com.google.android.gms.games.zzaj;
import com.google.android.gms.games.zzak;
import com.google.android.gms.games.zzal;
import com.google.android.gms.games.zzam;
import com.google.android.gms.games.zzan;
import com.google.android.gms.tasks.Task;

public class LeaderboardsClient
extends com.google.android.gms.games.internal.api.zzp {
    private static final zzbo<Leaderboards.LeaderboardMetadataResult, LeaderboardBuffer> zzhlg = new zzal();
    private static final zzbo<Leaderboards.LeaderboardMetadataResult, Leaderboard> zzhlh = new zzam();
    private static final zzo<Leaderboards.LeaderboardMetadataResult> zzhli = new zzan();
    private static final zzbo<Leaderboards.LoadPlayerScoreResult, LeaderboardScore> zzhlj = new zzac();
    private static final zzp zzhlk = new zzad();
    private static final zzbo<Leaderboards.SubmitScoreResult, ScoreSubmissionData> zzhll = new zzae();
    private static final zzbo<Leaderboards.LoadScoresResult, LeaderboardScores> zzhlm = new zzaf();

    LeaderboardsClient(@NonNull Context context, @NonNull Games.GamesOptions gamesOptions) {
        super(context, gamesOptions);
    }

    LeaderboardsClient(@NonNull Activity activity, @NonNull Games.GamesOptions gamesOptions) {
        super(activity, gamesOptions);
    }

    public Task<Intent> getAllLeaderboardsIntent() {
        return this.zza(new zzab(this));
    }

    public Task<Intent> getLeaderboardIntent(@NonNull String string) {
        return this.zza(new zzag(this, string));
    }

    public Task<Intent> getLeaderboardIntent(@NonNull String string, int n) {
        return this.zza(new zzah(this, string, n));
    }

    public Task<Intent> getLeaderboardIntent(@NonNull String string, int n, int n2) {
        return this.zza(new zzai(this, string, n, n2));
    }

    public Task<AnnotatedData<LeaderboardBuffer>> loadLeaderboardMetadata(boolean bl) {
        return zzg.zzc(Games.Leaderboards.loadLeaderboardMetadata(this.zzago(), bl), zzhlg);
    }

    public Task<AnnotatedData<Leaderboard>> loadLeaderboardMetadata(@NonNull String string, boolean bl) {
        return zzg.zza(Games.Leaderboards.loadLeaderboardMetadata(this.zzago(), string, bl), zzhlh, zzhli);
    }

    public Task<AnnotatedData<LeaderboardScore>> loadCurrentPlayerLeaderboardScore(@NonNull String string, int n, int n2) {
        return zzg.zzb(Games.Leaderboards.loadCurrentPlayerLeaderboardScore(this.zzago(), string, n, n2), zzhlj);
    }

    public Task<AnnotatedData<LeaderboardScores>> loadTopScores(@NonNull String string, int n, int n2, @IntRange(from=1L, to=25L) int n3) {
        return zzg.zzc(Games.Leaderboards.loadTopScores(this.zzago(), string, n, n2, n3), zzhlm);
    }

    public Task<AnnotatedData<LeaderboardScores>> loadTopScores(@NonNull String string, int n, int n2, @IntRange(from=1L, to=25L) int n3, boolean bl) {
        return zzg.zzc(Games.Leaderboards.loadTopScores(this.zzago(), string, n, n2, n3, bl), zzhlm);
    }

    public Task<AnnotatedData<LeaderboardScores>> loadPlayerCenteredScores(@NonNull String string, int n, int n2, @IntRange(from=1L, to=25L) int n3) {
        return zzg.zzc(Games.Leaderboards.loadPlayerCenteredScores(this.zzago(), string, n, n2, n3), zzhlm);
    }

    public Task<AnnotatedData<LeaderboardScores>> loadPlayerCenteredScores(@NonNull String string, int n, int n2, @IntRange(from=1L, to=25L) int n3, boolean bl) {
        return zzg.zzc(Games.Leaderboards.loadPlayerCenteredScores(this.zzago(), string, n, n2, n3, bl), zzhlm);
    }

    public Task<AnnotatedData<LeaderboardScores>> loadMoreScores(@NonNull LeaderboardScoreBuffer leaderboardScoreBuffer, @IntRange(from=1L, to=25L) int n, int n2) {
        return zzg.zzc(Games.Leaderboards.loadMoreScores(this.zzago(), leaderboardScoreBuffer, n, n2), zzhlm);
    }

    public void submitScore(@NonNull String string, long l) {
        this.zzb(new zzaj(this, string, l));
    }

    public void submitScore(@NonNull String string, long l, @NonNull String string2) {
        this.zzb(new zzak(this, string, l, string2));
    }

    public Task<ScoreSubmissionData> submitScoreImmediate(@NonNull String string, long l) {
        return zzg.zza(Games.Leaderboards.submitScoreImmediate(this.zzago(), string, l), zzhlk, zzhll);
    }

    public Task<ScoreSubmissionData> submitScoreImmediate(@NonNull String string, long l, @NonNull String string2) {
        return zzg.zza(Games.Leaderboards.submitScoreImmediate(this.zzago(), string, l, string2), zzhlk, zzhll);
    }

    public static class LeaderboardScores
    implements Releasable {
        private final Leaderboard zzhls;
        private final LeaderboardScoreBuffer zzhlt;

        LeaderboardScores(@Nullable Leaderboard leaderboard, @NonNull LeaderboardScoreBuffer leaderboardScoreBuffer) {
            this.zzhls = leaderboard;
            this.zzhlt = leaderboardScoreBuffer;
        }

        @Nullable
        public Leaderboard getLeaderboard() {
            return this.zzhls;
        }

        @NonNull
        public LeaderboardScoreBuffer getScores() {
            return this.zzhlt;
        }

        public void release() {
            if (this.zzhlt != null) {
                this.zzhlt.release();
            }
        }
    }
}

