/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.zzb;
import com.google.android.gms.games.zzap;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new zza();
    private String zzffb;
    private String zzegt;
    private final Uri zzhjq;
    private final Uri zzhjr;
    private final long zzhlv;
    private final int zzhlw;
    private final long zzhlx;
    private final String zzhkb;
    private final String zzhkc;
    private final String zzemt;
    private final zzb zzhly;
    private final PlayerLevelInfo zzhlz;
    private final boolean zzhma;
    private final boolean zzhmb;
    private final String zzhmc;
    private final String mName;
    private final Uri zzhmd;
    private final String zzhme;
    private final Uri zzhmf;
    private final String zzhmg;
    private final int zzhmh;
    private final long zzhmi;
    private final boolean zzhmj;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    private PlayerEntity(Player player, boolean bl) {
        this.zzffb = player.getPlayerId();
        this.zzegt = player.getDisplayName();
        this.zzhjq = player.getIconImageUri();
        this.zzhkb = player.getIconImageUrl();
        this.zzhjr = player.getHiResImageUri();
        this.zzhkc = player.getHiResImageUrl();
        this.zzhlv = player.getRetrievedTimestamp();
        this.zzhlw = player.zzarl();
        this.zzhlx = player.getLastPlayedWithTimestamp();
        this.zzemt = player.getTitle();
        this.zzhma = player.zzarm();
        com.google.android.gms.games.internal.player.zza zza2 = player.zzarn();
        this.zzhly = zza2 == null ? null : new zzb(zza2);
        this.zzhlz = player.getLevelInfo();
        this.zzhmb = player.zzark();
        this.zzhmc = player.zzarj();
        this.mName = player.getName();
        this.zzhmd = player.getBannerImageLandscapeUri();
        this.zzhme = player.getBannerImageLandscapeUrl();
        this.zzhmf = player.getBannerImagePortraitUri();
        this.zzhmg = player.getBannerImagePortraitUrl();
        this.zzhmh = player.zzaro();
        this.zzhmi = player.zzarp();
        this.zzhmj = player.isMuted();
        zzc.zzv((Object)this.zzffb);
        zzc.zzv((Object)this.zzegt);
        zzc.checkState((this.zzhlv > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(String string, String string2, Uri uri, Uri uri2, long l, int n, long l2, String string3, String string4, String string5, zzb zzb2, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n2, long l3, boolean bl3) {
        this.zzffb = string;
        this.zzegt = string2;
        this.zzhjq = uri;
        this.zzhkb = string3;
        this.zzhjr = uri2;
        this.zzhkc = string4;
        this.zzhlv = l;
        this.zzhlw = n;
        this.zzhlx = l2;
        this.zzemt = string5;
        this.zzhma = bl;
        this.zzhly = zzb2;
        this.zzhlz = playerLevelInfo;
        this.zzhmb = bl2;
        this.zzhmc = string6;
        this.mName = string7;
        this.zzhmd = uri3;
        this.zzhme = string8;
        this.zzhmf = uri4;
        this.zzhmg = string9;
        this.zzhmh = n2;
        this.zzhmi = l3;
        this.zzhmj = bl3;
    }

    @Override
    public final String getPlayerId() {
        return this.zzffb;
    }

    @Override
    public final String getDisplayName() {
        return this.zzegt;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzegt, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String zzarj() {
        return this.zzhmc;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final boolean zzark() {
        return this.zzhmb;
    }

    @Override
    public final boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhjq;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhkb;
    }

    @Override
    public final boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzhjr;
    }

    @Override
    public final String getHiResImageUrl() {
        return this.zzhkc;
    }

    @Override
    public final long getRetrievedTimestamp() {
        return this.zzhlv;
    }

    @Override
    public final long getLastPlayedWithTimestamp() {
        return this.zzhlx;
    }

    @Override
    public final int zzarl() {
        return this.zzhlw;
    }

    @Override
    public final boolean zzarm() {
        return this.zzhma;
    }

    @Override
    public final String getTitle() {
        return this.zzemt;
    }

    @Override
    public final void getTitle(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzemt, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final PlayerLevelInfo getLevelInfo() {
        return this.zzhlz;
    }

    @Override
    public final com.google.android.gms.games.internal.player.zza zzarn() {
        return this.zzhly;
    }

    @Override
    public final Uri getBannerImageLandscapeUri() {
        return this.zzhmd;
    }

    @Override
    public final String getBannerImageLandscapeUrl() {
        return this.zzhme;
    }

    @Override
    public final Uri getBannerImagePortraitUri() {
        return this.zzhmf;
    }

    @Override
    public final String getBannerImagePortraitUrl() {
        return this.zzhmg;
    }

    @Override
    public final int zzaro() {
        return this.zzhmh;
    }

    @Override
    public final long zzarp() {
        return this.zzhmi;
    }

    @Override
    public final boolean isMuted() {
        return this.zzhmj;
    }

    public final Player freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return Arrays.hashCode(new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzark(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzarj(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzaro(), player.zzarp(), player.isMuted()});
    }

    public final boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzbg.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzbg.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzbg.equal((Object)player2.zzark(), (Object)player.zzark()) && zzbg.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzbg.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzbg.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzbg.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzbg.equal((Object)((Object)player2.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && zzbg.equal((Object)player2.zzarj(), (Object)player.zzarj()) && zzbg.equal((Object)player2.getName(), (Object)player.getName()) && zzbg.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzbg.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzbg.equal((Object)player2.zzaro(), (Object)player.zzaro()) && zzbg.equal((Object)player2.zzarp(), (Object)player.zzarp()) && zzbg.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public final String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzbg.zzx((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzark()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzarj()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzaro()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzarp()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlayerEntity playerEntity = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (String)playerEntity.getPlayerId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)playerEntity.getDisplayName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (Parcelable)playerEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (Parcelable)playerEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (long)playerEntity.getRetrievedTimestamp());
        zzbfp.zzc((Parcel)parcel2, (int)6, (int)playerEntity.zzhlw);
        zzbfp.zza((Parcel)parcel2, (int)7, (long)playerEntity.getLastPlayedWithTimestamp());
        zzbfp.zza((Parcel)parcel2, (int)8, (String)playerEntity.getIconImageUrl(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)9, (String)playerEntity.getHiResImageUrl(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)14, (String)playerEntity.getTitle(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)15, (Parcelable)playerEntity.zzhly, (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)16, (Parcelable)playerEntity.getLevelInfo(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)18, (boolean)playerEntity.zzhma);
        zzbfp.zza((Parcel)parcel2, (int)19, (boolean)playerEntity.zzhmb);
        zzbfp.zza((Parcel)parcel2, (int)20, (String)playerEntity.zzhmc, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)21, (String)playerEntity.mName, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)22, (Parcelable)playerEntity.getBannerImageLandscapeUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)23, (String)playerEntity.getBannerImageLandscapeUrl(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)24, (Parcelable)playerEntity.getBannerImagePortraitUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)25, (String)playerEntity.getBannerImagePortraitUrl(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)26, (int)playerEntity.zzhmh);
        zzbfp.zza((Parcel)parcel2, (int)27, (long)playerEntity.zzhmi);
        zzbfp.zza((Parcel)parcel2, (int)28, (boolean)playerEntity.zzhmj);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzap {
        zza() {
        }

        @Override
        public final PlayerEntity zzj(Parcel parcel) {
            if (PlayerEntity.zze(PlayerEntity.zzalg()) || PlayerEntity.zzgh((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzj(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzap)this).zzj(parcel);
        }
    }
}

