/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.zzg;
import com.google.android.gms.games.internal.zzn;
import com.google.android.gms.games.internal.zzp;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.zzbr;
import com.google.android.gms.games.zzbs;
import com.google.android.gms.games.zzbt;
import com.google.android.gms.games.zzbu;
import com.google.android.gms.games.zzbv;
import com.google.android.gms.games.zzbw;
import com.google.android.gms.games.zzbx;
import com.google.android.gms.games.zzby;
import com.google.android.gms.games.zzbz;
import com.google.android.gms.games.zzca;
import com.google.android.gms.games.zzcb;
import com.google.android.gms.tasks.Task;

public class SnapshotsClient
extends com.google.android.gms.games.internal.api.zzp {
    public static final String EXTRA_SNAPSHOT_METADATA = "com.google.android.gms.games.SNAPSHOT_METADATA";
    public static final String EXTRA_SNAPSHOT_NEW = "com.google.android.gms.games.SNAPSHOT_NEW";
    public static final int DISPLAY_LIMIT_NONE = -1;
    public static final int RESOLUTION_POLICY_MANUAL = -1;
    public static final int RESOLUTION_POLICY_LONGEST_PLAYTIME = 1;
    public static final int RESOLUTION_POLICY_LAST_KNOWN_GOOD = 2;
    public static final int RESOLUTION_POLICY_MOST_RECENTLY_MODIFIED = 3;
    public static final int RESOLUTION_POLICY_HIGHEST_PROGRESS = 4;
    private static final zzn<Snapshots.OpenSnapshotResult> zzhnn = new zzbx();
    private static final zzbo<Snapshots.DeleteSnapshotResult, String> zzhno = new zzby();
    private static final zzbo<Snapshots.CommitSnapshotResult, SnapshotMetadata> zzhnp = new zzbz();
    private static final zzbo<Snapshots.OpenSnapshotResult, Snapshots.OpenSnapshotResult> zzhnq = new zzca();
    private static final zzp zzhnr = new zzcb();
    private static final zzbo<Snapshots.OpenSnapshotResult, DataOrConflict<Snapshot>> zzhns = new zzbs();
    private static final zzbo<Snapshots.LoadSnapshotsResult, SnapshotMetadataBuffer> zzhnt = new zzbt();

    SnapshotsClient(@NonNull Context context, @NonNull Games.GamesOptions gamesOptions) {
        super(context, gamesOptions);
    }

    SnapshotsClient(@NonNull Activity activity, @NonNull Games.GamesOptions gamesOptions) {
        super(activity, gamesOptions);
    }

    public Task<Integer> getMaxDataSize() {
        return this.zza(new zzbr(this));
    }

    public Task<Integer> getMaxCoverImageSize() {
        return this.zza(new zzbu(this));
    }

    public Task<Intent> getSelectSnapshotIntent(@NonNull String string, boolean bl, boolean bl2, int n) {
        return this.zza(new zzbv(this, string, bl, bl2, n));
    }

    public Task<AnnotatedData<SnapshotMetadataBuffer>> load(boolean bl) {
        return zzg.zzc(Games.Snapshots.load(this.zzago(), bl), zzhnt);
    }

    public Task<DataOrConflict<Snapshot>> open(@NonNull String string, boolean bl) {
        return SnapshotsClient.zze(Games.Snapshots.open(this.zzago(), string, bl));
    }

    public Task<DataOrConflict<Snapshot>> open(@NonNull String string, boolean bl, int n) {
        return SnapshotsClient.zze(Games.Snapshots.open(this.zzago(), string, bl, n));
    }

    public Task<DataOrConflict<Snapshot>> open(@NonNull SnapshotMetadata snapshotMetadata) {
        return SnapshotsClient.zze(Games.Snapshots.open(this.zzago(), snapshotMetadata));
    }

    public Task<DataOrConflict<Snapshot>> open(@NonNull SnapshotMetadata snapshotMetadata, int n) {
        return SnapshotsClient.zze(Games.Snapshots.open(this.zzago(), snapshotMetadata, n));
    }

    public Task<SnapshotMetadata> commitAndClose(@NonNull Snapshot snapshot, @NonNull SnapshotMetadataChange snapshotMetadataChange) {
        return zzg.zza(Games.Snapshots.commitAndClose(this.zzago(), snapshot, snapshotMetadataChange), zzhnp);
    }

    public Task<Void> discardAndClose(@NonNull Snapshot snapshot) {
        return this.zzb(new zzbw(this, snapshot));
    }

    public Task<String> delete(@NonNull SnapshotMetadata snapshotMetadata) {
        return zzg.zza(Games.Snapshots.delete(this.zzago(), snapshotMetadata), zzhno);
    }

    @Nullable
    public static SnapshotMetadata getSnapshotFromBundle(@NonNull Bundle bundle) {
        return Games.Snapshots.getSnapshotFromBundle(bundle);
    }

    public Task<DataOrConflict<Snapshot>> resolveConflict(@NonNull String string, @NonNull Snapshot snapshot) {
        return SnapshotsClient.zze(Games.Snapshots.resolveConflict(this.zzago(), string, snapshot));
    }

    public Task<DataOrConflict<Snapshot>> resolveConflict(@NonNull String string, @NonNull String string2, @NonNull SnapshotMetadataChange snapshotMetadataChange, @NonNull SnapshotContents snapshotContents) {
        return SnapshotsClient.zze(Games.Snapshots.resolveConflict(this.zzago(), string, string2, snapshotMetadataChange, snapshotContents));
    }

    private static Task<DataOrConflict<Snapshot>> zze(@NonNull PendingResult<Snapshots.OpenSnapshotResult> pendingResult) {
        return zzg.zza(pendingResult, zzhnr, zzhns, zzhnq, zzhnn);
    }

    public static class SnapshotContentUnavailableApiException
    extends ApiException {
        protected final SnapshotMetadata metadata;

        SnapshotContentUnavailableApiException(@NonNull Status status, @NonNull SnapshotMetadata snapshotMetadata) {
            super(status);
            this.metadata = snapshotMetadata;
        }

        public SnapshotMetadata getSnapshotMetadata() {
            return this.metadata;
        }
    }

    public static class DataOrConflict<T> {
        private final T data;
        private final SnapshotConflict zzhnz;

        DataOrConflict(@Nullable T t, @Nullable SnapshotConflict snapshotConflict) {
            this.data = t;
            this.zzhnz = snapshotConflict;
        }

        public boolean isConflict() {
            return this.zzhnz != null;
        }

        @Nullable
        public T getData() {
            if (this.isConflict()) {
                throw new IllegalStateException("getData called when there is a conflict.");
            }
            return this.data;
        }

        @Nullable
        public SnapshotConflict getConflict() {
            if (!this.isConflict()) {
                throw new IllegalStateException("getConflict called when there is no conflict.");
            }
            return this.zzhnz;
        }
    }

    public static class SnapshotConflict {
        private final Snapshot zzhoa;
        private final String zzhob;
        private final Snapshot zzhoc;
        private final SnapshotContents zzhod;

        SnapshotConflict(@NonNull Snapshot snapshot, @NonNull String string, @NonNull Snapshot snapshot2, @NonNull SnapshotContents snapshotContents) {
            this.zzhoa = snapshot;
            this.zzhob = string;
            this.zzhoc = snapshot2;
            this.zzhod = snapshotContents;
        }

        public Snapshot getSnapshot() {
            return this.zzhoa;
        }

        public Snapshot getConflictingSnapshot() {
            return this.zzhoc;
        }

        public String getConflictId() {
            return this.zzhob;
        }

        public SnapshotContents getResolutionSnapshotContents() {
            return this.zzhod;
        }
    }
}

