/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesClientStatusCodes;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzcbf;
import com.google.android.gms.internal.zzcbh;
import com.google.android.gms.internal.zzcbi;
import com.google.android.gms.internal.zzcxn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GamesClientImpl
extends com.google.android.gms.common.internal.zzab<com.google.android.gms.games.internal.zzw> {
    private zzcbh zzhph = new com.google.android.gms.games.internal.zzd(this);
    private final String zzhpi;
    private PlayerEntity zzhpj;
    private GameEntity zzhpk;
    private final com.google.android.gms.games.internal.zzaa zzhpl;
    private boolean zzhpm = false;
    private final Binder zzhpn;
    private final long zzhpo;
    private final Games.GamesOptions zzhpp;
    private boolean zzhpq = false;
    private Bundle zzhpr;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzr zzr2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzhpi = zzr2.zzaky();
        this.zzhpn = new Binder();
        int n = zzr2.zzaku();
        GamesClientImpl gamesClientImpl = this;
        this.zzhpl = new com.google.android.gms.games.internal.zzad(gamesClientImpl, n);
        this.zzhpo = ((Object)((Object)this)).hashCode();
        this.zzhpp = gamesOptions;
        if (!this.zzhpp.zzhkx && (zzr2.zzala() != null || context instanceof Activity)) {
            this.zzz(zzr2.zzala());
        }
    }

    public final boolean zzaay() {
        return true;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzhpm = false;
    }

    public final void zzdi(int n) {
        int n2;
        this.zzhpl.zzhsm.gravity = n2 = n;
    }

    public final void zzz(View view) {
        this.zzhpl.zzaa(view);
    }

    protected final Set<Scope> zzb(Set<Scope> set) {
        HashSet<Scope> hashSet = new HashSet<Scope>(set);
        boolean bl = set.contains(Games.SCOPE_GAMES);
        boolean bl2 = set.contains(Games.SCOPE_GAMES_LITE);
        if (set.contains(Games.zzhkj)) {
            com.google.android.gms.common.internal.zzbq.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            com.google.android.gms.common.internal.zzbq.zza((bl || bl2 ? 1 : 0) != 0, (String)"Games APIs requires %s function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games_lite"});
            if (bl2 && bl) {
                hashSet.remove(Games.SCOPE_GAMES_LITE);
            }
        }
        return hashSet;
    }

    public final void zza(com.google.android.gms.common.internal.zzj zzj2) {
        GamesClientImpl gamesClientImpl = this;
        this.zzhpj = null;
        gamesClientImpl.zzhpk = null;
        super.zza(zzj2);
    }

    public final void disconnect() {
        this.zzhpm = false;
        if (this.isConnected()) {
            try {
                com.google.android.gms.games.internal.zzw zzw2 = (com.google.android.gms.games.internal.zzw)this.zzakn();
                zzw2.zzate();
                this.zzhph.flush();
                zzw2.zzac(this.zzhpo);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.games.internal.zzf.zzv("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected final String zzhi() {
        return "com.google.android.gms.games.service.START";
    }

    protected final String zzhj() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    public final Bundle zzafi() {
        try {
            Bundle bundle = ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzafi();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
                this.zzhpr = bundle;
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    @Nullable
    public final Bundle zzarr() {
        Bundle bundle = this.zzafi();
        if (bundle == null) {
            bundle = this.zzhpr;
        }
        this.zzhpr = null;
        return bundle;
    }

    protected final Bundle zzaap() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzhpp.zzari();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzhpi);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzhpl.zzhsm.zzhsn));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 6);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzcxn.zza((com.google.android.gms.common.internal.zzr)this.zzalh()));
        return bundle;
    }

    public final String zzars() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzars();
    }

    public final String zzart() {
        try {
            return this.zzars();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzb(String string, com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) throws RemoteException {
        com.google.android.gms.common.internal.zzbq.zzh((String)string, (Object)"Please provide a valid serverClientId");
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza(string, new zzy(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final String zzbh(boolean bl) throws RemoteException {
        if (this.zzhpj != null) {
            return this.zzhpj.getPlayerId();
        }
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzatg();
    }

    public final String zzbi(boolean bl) {
        try {
            return this.zzbh(true);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Player zzaru() throws RemoteException {
        this.zzakm();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzhpj == null) {
                PlayerBuffer playerBuffer = new PlayerBuffer(((com.google.android.gms.games.internal.zzw)this.zzakn()).zzath());
                try {
                    if (playerBuffer.getCount() > 0) {
                        this.zzhpj = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                    }
                }
                finally {
                    playerBuffer.release();
                }
            }
        }
        return this.zzhpj;
    }

    public final Player zzarv() {
        try {
            return this.zzaru();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Game zzarw() throws RemoteException {
        this.zzakm();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzhpk == null) {
                GameBuffer gameBuffer = new GameBuffer(((com.google.android.gms.games.internal.zzw)this.zzakn()).zzati());
                try {
                    if (gameBuffer.getCount() > 0) {
                        this.zzhpk = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                    }
                }
                finally {
                    gameBuffer.release();
                }
            }
        }
        return this.zzhpk;
    }

    public final Game zzarx() {
        try {
            return this.zzarw();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), string, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, int n, boolean bl, boolean bl2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), n, bl, bl2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), string, n, bl, bl2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzc((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzary() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzary();
    }

    public final Intent zzarz() {
        try {
            return this.zzary();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zzj(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzk(string, n, n2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb((com.google.android.gms.games.internal.zzs)new zzai(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, String string, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzai(zzn2), string, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2, String string, String string2, int n, int n2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzbl(zzn2), null, string2, n, n2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza(new zzah(zzn2), string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb(new zzah(zzn2), string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzah(zzn2), leaderboardScoreBuffer.zzaud().asBundle(), n, n2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2, String string, long l, String string2) throws RemoteException {
        zzcl zzcl2 = zzn2 == null ? null : new zzcl(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)zzcl2, string, l, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzasa() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzasa();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzf(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)zze2, string, this.zzhpl.zzhsm.zzhsn, this.zzhpl.zzhsm.zzatm());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb(zze2, string, this.zzhpl.zzhsm.zzhsn, this.zzhpl.zzhsm.zzatm());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)zze2, string, n, this.zzhpl.zzhsm.zzhsn, this.zzhpl.zzhsm.zzatm());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb(zze2, string, n, this.zzhpl.zzhsm.zzhsn, this.zzhpl.zzhsm.zzatm());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl) throws RemoteException {
        this.zzhph.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zze((com.google.android.gms.games.internal.zzs)new zzu(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzhph.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzu(zzn2), bl, stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzp(String string, int n) {
        this.zzhph.zzp(string, n);
    }

    public final Intent zzasb() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzasb();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzasc() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzasc();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zze(com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zzci2) throws RemoteException {
        zzab zzab2 = new zzab(zzci2);
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)zzab2, this.zzhpo);
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zzci2) {
        try {
            this.zze(zzci2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzasd() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzad(this.zzhpo);
    }

    public final void zzase() {
        try {
            this.zzasd();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zzci2) throws RemoteException {
        zzaz zzaz2 = new zzaz(zzci2);
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb((com.google.android.gms.games.internal.zzs)zzaz2, this.zzhpo);
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zzci2) {
        try {
            this.zzg(zzci2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzasf() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzae(this.zzhpo);
    }

    public final void zzasg() {
        try {
            this.zzasf();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzci<QuestUpdateListener> zzci2) {
        try {
            zzbs zzbs2 = new zzbs(zzci2);
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzd((com.google.android.gms.games.internal.zzs)zzbs2, this.zzhpo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzash() {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzag(this.zzhpo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzj(com.google.android.gms.common.api.internal.zzci<OnRequestReceivedListener> zzci2) {
        try {
            zzbw zzbw2 = new zzbw(zzci2);
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzc((com.google.android.gms.games.internal.zzs)zzbw2, this.zzhpo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzasi() {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzaf(this.zzhpo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zza(PlayerEntity playerEntity) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza(playerEntity);
    }

    public final Intent zzb(PlayerEntity playerEntity) {
        try {
            return this.zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zzasj() {
        try {
            return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzatj();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zza(Room room, int n) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((RoomEntity)room.freeze(), n);
    }

    public final Intent zzb(Room room, int n) {
        try {
            return this.zza(room, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zzask() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzask();
    }

    public final Intent zzasl() {
        try {
            return this.zzask();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb(new zzx(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(@NonNull com.google.android.gms.common.internal.zzp zzp2) {
        try {
            this.zzg(new com.google.android.gms.games.internal.zze(this, zzp2));
            return;
        }
        catch (RemoteException remoteException) {
            zzp2.zzajf();
            return;
        }
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzn<Status> zzn2) throws RemoteException {
        this.zzhph.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza(new zzcg(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final int zzasm() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzasm();
    }

    public final int zzasn() {
        try {
            return this.zzasm();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return 4368;
        }
    }

    public final String getAppId() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).getAppId();
    }

    public final String zzaso() {
        try {
            return this.getAppId();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzae(zzn2), n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzq(String string, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzq(string, n);
    }

    public final void zzr(String string, int n) {
        try {
            this.zzq(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzs(String string, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzs(string, n);
    }

    public final void zzt(String string, int n) {
        try {
            this.zzs(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzb(int n, int n2, boolean bl) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb(n, n2, bl);
    }

    public final Intent zzc(int n, int n2, boolean bl) {
        try {
            return this.zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzco(zzn2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzauj(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb((com.google.android.gms.games.internal.zzs)new zzco(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzc((com.google.android.gms.games.internal.zzs)new zzco(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final int zzasp() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzasp();
    }

    public final int zzasq() {
        try {
            return this.zzasp();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzcs(zzn2), string, byArray, string2, participantResultArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzcs(zzn2), string, byArray, participantResultArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zze((com.google.android.gms.games.internal.zzs)new zzcp(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string, String string2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzcp(zzn2), string, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzd((com.google.android.gms.games.internal.zzs)new zzcn(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzhq(String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzhu(string);
    }

    public final void zzhr(String string) {
        try {
            this.zzhq(string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2, int n, int[] nArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzct(zzn2), n, nArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzf((com.google.android.gms.games.internal.zzs)new zzcq(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzd(int n, int n2, boolean bl) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzd(n, n2, bl);
    }

    public final Intent zze(int n, int n2, boolean bl) {
        try {
            return this.zzd(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) throws RemoteException {
        zzcc zzcc2 = new zzcc(zzci2, zzci3, zzci4);
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza(zzcc2, (IBinder)this.zzhpn, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzhpo);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) {
        try {
            this.zza(zzci2, zzci3, zzci4, roomConfig);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) throws RemoteException {
        zzcc zzcc2 = new zzcc(zzci2, zzci3, zzci4);
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)zzcc2, (IBinder)this.zzhpn, roomConfig.getInvitationId(), false, this.zzhpo);
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) {
        try {
            this.zzc(zzci2, zzci3, zzci4, roomConfig);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, String string) {
        try {
            String string2 = string;
            com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci3 = zzci2;
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzcc(zzci3), string2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zza(com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zzci2, byte[] byArray, String string, String string2) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzbv(zzci2), byArray, string, string2);
    }

    public final int zzb(com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zzci2, byte[] byArray, String string, String string2) {
        try {
            return this.zza(zzci2, byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zza(byte[] byArray, String string, String[] stringArray) {
        com.google.android.gms.common.internal.zzbq.checkNotNull((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            String[] stringArray2 = stringArray;
            String string2 = string;
            byte[] byArray2 = byArray;
            GamesClientImpl gamesClientImpl = this;
            com.google.android.gms.common.internal.zzbq.checkNotNull((Object)stringArray2, (Object)"Participant IDs must not be null");
            return ((com.google.android.gms.games.internal.zzw)gamesClientImpl.zzakn()).zzb(byArray2, string2, stringArray2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zzd(byte[] byArray, String string) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb(byArray, string, null);
    }

    public final int zze(byte[] byArray, String string) {
        try {
            return this.zzd(byArray, string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final void zzdj(int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzdj(n);
    }

    public final void zzdk(int n) {
        try {
            this.zzdj(n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzasr() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzasr();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza(n, byArray, n2, string);
            com.google.android.gms.common.internal.zzbq.checkNotNull((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final int zzass() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzass();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final int zzast() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzast();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzca(zzn2), stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb((com.google.android.gms.games.internal.zzs)new zzca(zzn2), stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2, int n, int n2, int n3) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzbz(zzn2), n, n2, n3);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzf((com.google.android.gms.games.internal.zzs)new zzbm(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzc(int[] nArray) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzc(nArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzhs(String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzhs(string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2, String string) throws RemoteException {
        this.zzhph.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzh(new zzbp(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string, String string2) throws RemoteException {
        this.zzhph.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb((com.google.android.gms.games.internal.zzs)new zzbr(zzn2, string2), string, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzhph.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzbt(zzn2), nArray, n, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzhph.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzbt(zzn2), stringArray, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzht(String string) {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza(string, this.zzhpl.zzhsm.zzhsn, this.zzhpl.zzhsm.zzatm());
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zzasu() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzasu();
    }

    public final int zzasv() {
        try {
            return this.zzasu();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zzasw() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzasw();
    }

    public final int zzasx() {
        try {
            return this.zzasw();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final Intent zza(String string, boolean bl, boolean bl2, int n) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza(string, bl, bl2, n);
    }

    public final Intent zzb(String string, boolean bl, boolean bl2, int n) {
        try {
            return this.zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzd((com.google.android.gms.games.internal.zzs)new zzck(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, boolean bl, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzcj(zzn2), string, bl, n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzaum();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzaob();
        snapshotContents.close();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzch(zzn2), snapshot.getMetadata().getSnapshotId(), (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(Snapshot snapshot) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzaob();
        snapshotContents.close();
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza(zzc2);
    }

    public final void zzb(Snapshot snapshot) {
        try {
            this.zza(snapshot);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzg(new zzci(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzaum();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzaob();
        snapshotContents.close();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza((com.google.android.gms.games.internal.zzs)new zzcj(zzn2), string, string2, (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzc(new zzj(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzasy() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzatk();
    }

    public final Intent zzasz() {
        try {
            return this.zzasy();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzd(new zzn(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzb((com.google.android.gms.games.internal.zzs)new zzh(zzn2), n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final boolean zzata() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzata();
    }

    public final boolean zzatb() {
        try {
            return this.zzata();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return false;
        }
    }

    public final void zzk(com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zzci2) throws RemoteException {
        zzl zzl2 = new zzl(zzci2);
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zze((com.google.android.gms.games.internal.zzs)zzl2, this.zzhpo);
    }

    public final void zzl(com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zzci2) {
        try {
            this.zzk(zzci2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzatc() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzah(this.zzhpo);
    }

    public final void zzatd() {
        try {
            this.zzatc();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzw)this.zzakn()).zza(iBinder, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    public final void zzate() {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzw)this.zzakn()).zzate();
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    private static void zzd(RemoteException remoteException) {
        com.google.android.gms.games.internal.zzf.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static void zza(SecurityException securityException) {
        com.google.android.gms.games.internal.zzf.zzd("GamesClientImpl", "Is player signed out?", securityException);
    }

    private static <R> void zza(com.google.android.gms.common.api.internal.zzn<R> zzn2, SecurityException securityException) {
        if (zzn2 != null) {
            zzn2.zzu(GamesClientStatusCodes.zzdg(4));
        }
    }

    private static Room zzak(DataHolder dataHolder) {
        com.google.android.gms.games.multiplayer.realtime.zzb zzb2 = new com.google.android.gms.games.multiplayer.realtime.zzb(dataHolder);
        Room room = null;
        try {
            if (zzb2.getCount() > 0) {
                room = (Room)((Room)zzb2.get(0)).freeze();
            }
        }
        finally {
            zzb2.release();
        }
        return room;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzhpq = this.zzhpm = bundle.getBoolean("show_welcome_popup");
            this.zzhpj = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzhpk = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final /* synthetic */ void zza(@NonNull IInterface iInterface) {
        com.google.android.gms.games.internal.zzw zzw2 = (com.google.android.gms.games.internal.zzw)iInterface;
        GamesClientImpl gamesClientImpl = this;
        super.zza((IInterface)zzw2);
        if (gamesClientImpl.zzhpm) {
            gamesClientImpl.zzhpl.zzatl();
            gamesClientImpl.zzhpm = false;
        }
        if (!gamesClientImpl.zzhpp.zzhkp && !gamesClientImpl.zzhpp.zzhkx) {
            com.google.android.gms.games.internal.zzw zzw3 = zzw2;
            GamesClientImpl gamesClientImpl2 = gamesClientImpl;
            try {
                zzbo zzbo2 = new zzbo(gamesClientImpl2.zzhpl);
                zzw3.zza(zzbo2, gamesClientImpl2.zzhpo);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.games.internal.IGamesService");
        if (iInterface instanceof com.google.android.gms.games.internal.zzw) {
            return (com.google.android.gms.games.internal.zzw)iInterface;
        }
        return new com.google.android.gms.games.internal.zzx(iBinder2);
    }

    static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final String zzah;

        public final Status getStatus() {
            throw new NoSuchMethodError();
        }

        @Override
        public final String getUrl() {
            return this.zzah;
        }
    }

    static final class zzo
    implements Videos.CaptureStateResult {
        private final Status mStatus;
        private final CaptureState zzhqa;

        zzo(Status status, CaptureState captureState) {
            this.mStatus = status;
            this.zzhqa = captureState;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final CaptureState getCaptureState() {
            return this.zzhqa;
        }
    }

    static final class zzk
    implements Videos.CaptureCapabilitiesResult {
        private final Status mStatus;
        private final VideoCapabilities zzhpy;

        zzk(Status status, VideoCapabilities videoCapabilities) {
            this.mStatus = status;
            this.zzhpy = videoCapabilities;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final VideoCapabilities getCapabilities() {
            return this.zzhpy;
        }
    }

    static final class zzi
    implements Videos.CaptureAvailableResult {
        private final Status mStatus;
        private final boolean zzhpx;

        zzi(Status status, boolean bl) {
            this.mStatus = status;
            this.zzhpx = bl;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final boolean isAvailable() {
            return this.zzhpx;
        }
    }

    static final class zzs
    implements Snapshots.DeleteSnapshotResult {
        private final Status mStatus;
        private final String zzhqd;

        zzs(int n, String string) {
            this.mStatus = GamesStatusCodes.zzdg(n);
            this.zzhqd = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getSnapshotId() {
            return this.zzhqd;
        }
    }

    static final class zzq
    extends zzw
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzhqc;

        zzq(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzhqc = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
                return;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public final SnapshotMetadata getSnapshotMetadata() {
            return this.zzhqc;
        }
    }

    static final class zzbc
    extends zzw
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzhqw;
        private final String zzhqx;
        private final Snapshot zzhqy;
        private final com.google.android.gms.drive.zzc zzhqz;
        private final SnapshotContents zzhra;

        zzbc(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this(dataHolder, null, zzc2, null, null);
        }

        zzbc(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzhqw = null;
                    this.zzhqy = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.zzc.checkState((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzhqw = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    this.zzhqy = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzhqw = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.zzhqy = new SnapshotEntity(snapshotMetadataEntity2, new com.google.android.gms.games.snapshot.zza(zzc3));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzhqx = string;
            this.zzhqz = zzc4;
            this.zzhra = new com.google.android.gms.games.snapshot.zza(zzc4);
        }

        @Override
        public final Snapshot getSnapshot() {
            return this.zzhqw;
        }

        @Override
        public final String getConflictId() {
            return this.zzhqx;
        }

        @Override
        public final Snapshot getConflictingSnapshot() {
            return this.zzhqy;
        }

        @Override
        public final SnapshotContents getResolutionSnapshotContents() {
            return this.zzhra;
        }
    }

    static final class zzax
    extends zzw
    implements Snapshots.LoadSnapshotsResult {
        zzax(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzfqt);
        }
    }

    static final class zzas
    extends zzw
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzhqo;

        zzas(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzhqo = playerStatsBuffer.getCount() > 0 ? new com.google.android.gms.games.stats.zza((PlayerStats)playerStatsBuffer.get(0)) : null;
                return;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public final PlayerStats getPlayerStats() {
            return this.zzhqo;
        }
    }

    static final class zzp
    extends zzw
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzhqb;
        private final Quest zzhpv;

        zzp(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzhpv = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzhpv.zzauk();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.zzhqb = list.get(i);
                        return;
                    }
                    this.zzhqb = null;
                } else {
                    this.zzhqb = null;
                    this.zzhpv = null;
                }
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Milestone getMilestone() {
            return this.zzhqb;
        }

        @Override
        public final Quest getQuest() {
            return this.zzhpv;
        }
    }

    static final class zzd
    extends zzw
    implements Quests.AcceptQuestResult {
        private final Quest zzhpv;

        zzd(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzhpv = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Quest getQuest() {
            return this.zzhpv;
        }
    }

    static final class zzau
    extends zzw
    implements Quests.LoadQuestsResult {
        private final DataHolder zzfqt;

        zzau(DataHolder dataHolder) {
            super(dataHolder);
            this.zzfqt = dataHolder;
        }

        @Override
        public final QuestBuffer getQuests() {
            return new QuestBuffer(this.zzfqt);
        }
    }

    static final class zzav
    implements Requests.LoadRequestsResult {
        private final Status mStatus;
        private final Bundle zzhqq;

        zzav(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzhqq = bundle;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final GameRequestBuffer getRequests(int n) {
            String string;
            switch (n) {
                case 1: {
                    String string2 = "GIFT";
                    break;
                }
                case 2: {
                    String string2 = "WISH";
                    break;
                }
                default: {
                    com.google.android.gms.games.internal.zzf.zzw("RequestType", new StringBuilder(33).append("Unknown request type: ").append(n).toString());
                    String string2 = string = "UNKNOWN_TYPE";
                }
            }
            if (!this.zzhqq.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzhqq.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public final void release() {
            for (String string : this.zzhqq.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzhqq.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    static final class zzcw
    extends zzw
    implements Requests.UpdateRequestsResult {
        private final zzcbi zzhrz;

        zzcw(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhrz = zzcbi.zzan(dataHolder);
        }

        @Override
        public final int getRequestOutcome(String string) {
            return this.zzhrz.getRequestOutcome(string);
        }

        @Override
        public final Set<String> getRequestIds() {
            return this.zzhrz.getRequestIds();
        }
    }

    static final class zzz
    implements Games.GetServerAuthCodeResult {
        private final Status mStatus;
        private final String zzhqe;

        zzz(Status status, String string) {
            this.mStatus = status;
            this.zzhqe = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getCode() {
            return this.zzhqe;
        }
    }

    static final class zzg
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status mStatus;
        private final String zzhpw;

        zzg(Status status, String string) {
            this.mStatus = status;
            this.zzhpw = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMatchId() {
            return this.zzhpw;
        }
    }

    static final class zzaj
    extends zzcr
    implements TurnBasedMultiplayer.LeaveMatchResult {
        zzaj(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzcv
    extends zzcr
    implements TurnBasedMultiplayer.UpdateMatchResult {
        zzcv(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzaa
    extends zzcr
    implements TurnBasedMultiplayer.InitiateMatchResult {
        zzaa(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzap
    extends zzcr
    implements TurnBasedMultiplayer.LoadMatchResult {
        zzap(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static abstract class zzcr
    extends zzw {
        private TurnBasedMatch zzhqu;

        zzcr(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzhqu = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzhqu;
        }
    }

    static final class zzcm
    extends zzw
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzhrs;

        public zzcm(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzhrs = new ScoreSubmissionData(dataHolder);
                return;
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public final ScoreSubmissionData getScoreData() {
            return this.zzhrs;
        }
    }

    static final class zzat
    extends zzw
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzhqp;

        zzat(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhqp = new PlayerBuffer(dataHolder);
        }

        @Override
        public final PlayerBuffer getPlayers() {
            return this.zzhqp;
        }
    }

    static final class zzaq
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status mStatus;
        private final LoadMatchesResponse zzhqm;

        zzaq(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzhqm = new LoadMatchesResponse(bundle);
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final LoadMatchesResponse getMatches() {
            return this.zzhqm;
        }

        public final void release() {
            this.zzhqm.release();
        }
    }

    static final class zzao
    extends zzw
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzhql;

        zzao(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhql = new InvitationBuffer(dataHolder);
        }

        @Override
        public final InvitationBuffer getInvitations() {
            return this.zzhql;
        }
    }

    static final class zzar
    extends zzw
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzhqn;

        zzar(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.zzhqn = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public final LeaderboardScore getScore() {
            return this.zzhqn;
        }
    }

    static final class zzaw
    extends zzw
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzhqr;
        private final LeaderboardScoreBuffer zzhqs;

        zzaw(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.zzhqr = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzhqs = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public final Leaderboard getLeaderboard() {
            return this.zzhqr;
        }

        @Override
        public final LeaderboardScoreBuffer getScores() {
            return this.zzhqs;
        }
    }

    static final class zzag
    extends zzw
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzhqg;

        zzag(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhqg = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public final LeaderboardBuffer getLeaderboards() {
            return this.zzhqg;
        }
    }

    static final class zzan
    extends zzw
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzhqk;

        zzan(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhqk = new GameBuffer(dataHolder);
        }

        @Override
        public final GameBuffer getGames() {
            return this.zzhqk;
        }
    }

    static final class zzam
    extends zzw
    implements Events.LoadEventsResult {
        private final EventBuffer zzhqj;

        zzam(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhqj = new EventBuffer(dataHolder);
        }

        @Override
        public final EventBuffer getEvents() {
            return this.zzhqj;
        }
    }

    static final class zzcu
    implements Achievements.UpdateAchievementResult {
        private final Status mStatus;
        private final String zzhot;

        zzcu(int n, String string) {
            this.mStatus = GamesStatusCodes.zzdg(n);
            this.zzhot = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getAchievementId() {
            return this.zzhot;
        }
    }

    static final class zzal
    extends zzw
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzhqi;

        zzal(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhqi = new AchievementBuffer(dataHolder);
        }

        @Override
        public final AchievementBuffer getAchievements() {
            return this.zzhqi;
        }
    }

    static abstract class zzw
    extends com.google.android.gms.common.api.internal.zzaj {
        protected zzw(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzdg(dataHolder.getStatusCode()));
        }
    }

    static final class zzbu
    implements com.google.android.gms.common.api.internal.zzcl<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzcd;
        private final String zzhrg;
        private final int zzhrh;

        zzbu(int n, int n2, String string) {
            this.zzcd = n;
            this.zzhrh = n2;
            this.zzhrg = string;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback = (RealTimeMultiplayer.ReliableMessageSentCallback)object;
            zzbu zzbu2 = this;
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(zzbu2.zzcd, zzbu2.zzhrh, zzbu2.zzhrg);
            }
        }
    }

    static final class zzbb
    implements com.google.android.gms.common.api.internal.zzcl<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzhqv;

        zzbb(RealTimeMessage realTimeMessage) {
            this.zzhqv = realTimeMessage;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            RealTimeMessageReceivedListener realTimeMessageReceivedListener = (RealTimeMessageReceivedListener)object;
            zzbb zzbb2 = this;
            realTimeMessageReceivedListener.onRealTimeMessageReceived(zzbb2.zzhqv);
        }
    }

    static final class zzbe
    implements com.google.android.gms.common.api.internal.zzcl<RoomStatusUpdateListener> {
        private final String zzhrb;

        zzbe(String string) {
            this.zzhrb = string;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbe zzbe2 = this;
            roomStatusUpdateListener.onP2PDisconnected(zzbe2.zzhrb);
        }
    }

    static final class zzbd
    implements com.google.android.gms.common.api.internal.zzcl<RoomStatusUpdateListener> {
        private final String zzhrb;

        zzbd(String string) {
            this.zzhrb = string;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbd zzbd2 = this;
            roomStatusUpdateListener.onP2PConnected(zzbd2.zzhrb);
        }
    }

    static final class zzbh
    extends zza {
        zzbh(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    static final class zzbf
    extends zza {
        zzbf(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    static final class zzbg
    extends zza {
        zzbg(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    static final class zzbk
    extends zza {
        zzbk(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    static final class zzbj
    extends zza {
        zzbj(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    static final class zzbi
    extends zza {
        zzbi(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    static final class zzt
    extends zzc {
        zzt(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    static final class zzr
    extends zzc {
        zzr(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    static final class zzcb
    extends zzc {
        zzcb(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    static final class zzce
    extends zzc {
        zzce(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    static final class zzcd
    extends zzb {
        zzcd(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    static final class zzak
    implements com.google.android.gms.common.api.internal.zzcl<RoomUpdateListener> {
        private final int zzcd;
        private final String zzhqh;

        zzak(int n, String string) {
            this.zzcd = n;
            this.zzhqh = string;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            zzak zzak2 = this;
            roomUpdateListener.onLeftRoom(zzak2.zzcd, zzak2.zzhqh);
        }
    }

    static final class zzaf
    extends zzb {
        public zzaf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    static final class zzcf
    extends zzb {
        public zzcf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    static abstract class zza
    extends zzc {
        private final ArrayList<String> zzhpu = new ArrayList();

        zza(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzhpu.add(stringArray[i]);
            }
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzhpu);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    static abstract class zzc
    extends com.google.android.gms.common.api.internal.zzai<RoomStatusUpdateListener> {
        zzc(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzak(dataHolder2));
        }
    }

    static abstract class zzb
    extends com.google.android.gms.common.api.internal.zzai<RoomUpdateListener> {
        zzb(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            this.zza(roomUpdateListener, GamesClientImpl.zzak(dataHolder2), dataHolder2.getStatusCode());
        }
    }

    static final class zzby
    implements com.google.android.gms.common.api.internal.zzcl<OnRequestReceivedListener> {
        private final String zzcrt;

        zzby(String string) {
            this.zzcrt = string;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzby zzby2 = this;
            onRequestReceivedListener.onRequestRemoved(zzby2.zzcrt);
        }
    }

    static final class zzbx
    implements com.google.android.gms.common.api.internal.zzcl<OnRequestReceivedListener> {
        private final GameRequest zzhrj;

        zzbx(GameRequest gameRequest) {
            this.zzhrj = gameRequest;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzbx zzbx2 = this;
            onRequestReceivedListener.onRequestReceived(zzbx2.zzhrj);
        }
    }

    static final class zzbq
    implements com.google.android.gms.common.api.internal.zzcl<QuestUpdateListener> {
        private final Quest zzhpv;

        zzbq(Quest quest) {
            this.zzhpv = quest;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            QuestUpdateListener questUpdateListener = (QuestUpdateListener)object;
            zzbq zzbq2 = this;
            questUpdateListener.onQuestCompleted(zzbq2.zzhpv);
        }
    }

    static final class zzay
    implements com.google.android.gms.common.api.internal.zzcl<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzhqt;

        zzay(String string) {
            this.zzhqt = string;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzay zzay2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(zzay2.zzhqt);
        }
    }

    static final class zzba
    implements com.google.android.gms.common.api.internal.zzcl<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzhqu;

        zzba(TurnBasedMatch turnBasedMatch) {
            this.zzhqu = turnBasedMatch;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzba zzba2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(zzba2.zzhqu);
        }
    }

    static final class zzad
    implements com.google.android.gms.common.api.internal.zzcl<OnInvitationReceivedListener> {
        private final String zzebl;

        zzad(String string) {
            this.zzebl = string;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzad zzad2 = this;
            onInvitationReceivedListener.onInvitationRemoved(zzad2.zzebl);
        }
    }

    static final class zzac
    implements com.google.android.gms.common.api.internal.zzcl<OnInvitationReceivedListener> {
        private final Invitation zzhqf;

        zzac(Invitation invitation) {
            this.zzhqf = invitation;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzac zzac2 = this;
            onInvitationReceivedListener.onInvitationReceived(zzac2.zzhqf);
        }
    }

    static final class zzm
    implements com.google.android.gms.common.api.internal.zzcl<Videos.CaptureOverlayStateListener> {
        private final int zzhpz;

        zzm(int n) {
            this.zzhpz = n;
        }

        public final void zzahz() {
        }

        public final /* synthetic */ void zzu(Object object) {
            Videos.CaptureOverlayStateListener captureOverlayStateListener = (Videos.CaptureOverlayStateListener)object;
            zzm zzm2 = this;
            captureOverlayStateListener.onCaptureOverlayStateChanged(zzm2.zzhpz);
        }
    }

    static final class zzn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzgbw;

        public zzn(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzd(int n, Bundle bundle) {
            this.zzgbw.setResult((Object)new zzo(new Status(n), CaptureState.zzp(bundle)));
        }
    }

    static final class zzl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zzgoh;

        zzl(com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zzci2) {
            this.zzgoh = (com.google.android.gms.common.api.internal.zzci)com.google.android.gms.common.internal.zzbq.checkNotNull(zzci2, (Object)"Callback must not be null");
        }

        @Override
        public final void onCaptureOverlayStateChanged(int n) {
            this.zzgoh.zza((com.google.android.gms.common.api.internal.zzcl)new zzm(n));
        }
    }

    static final class zzj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzgbw;

        zzj(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(int n, VideoCapabilities videoCapabilities) {
            this.zzgbw.setResult((Object)new zzk(new Status(n), videoCapabilities));
        }
    }

    static final class zzh
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzgbw;

        zzh(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, boolean bl) {
            this.zzgbw.setResult((Object)new zzi(new Status(n), bl));
        }
    }

    static final class zzci
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzgbw;

        public zzci(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(int n, String string) {
            this.zzgbw.setResult((Object)new zzs(n, string));
        }
    }

    static final class zzch
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzhrp;

        public zzch(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2) {
            this.zzhrp = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzae(DataHolder dataHolder) {
            this.zzhrp.setResult((Object)new zzq(dataHolder));
        }
    }

    static final class zzcj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzhrq;

        public zzcj(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2) {
            this.zzhrq = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this.zzhrq.setResult((Object)new zzbc(dataHolder, zzc2));
        }

        @Override
        public final void zza(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            this.zzhrq.setResult((Object)new zzbc(dataHolder, string, zzc2, zzc3, zzc4));
        }
    }

    static final class zzck
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzhrr;

        public zzck(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2) {
            this.zzhrr = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzad(DataHolder dataHolder) {
            this.zzhrr.setResult((Object)new zzax(dataHolder));
        }
    }

    static final class zzbm
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzgbw;

        public zzbm(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzaj(DataHolder dataHolder) {
            this.zzgbw.setResult((Object)new zzas(dataHolder));
        }
    }

    static final class zzbt
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzhrf;

        public zzbt(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2) {
            this.zzhrf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzai(DataHolder dataHolder) {
            this.zzhrf.setResult((Object)new zzau(dataHolder));
        }
    }

    static final class zzbr
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzhrd;
        private final String zzhre;

        public zzbr(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string) {
            this.zzhrd = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
            this.zzhre = (String)com.google.android.gms.common.internal.zzbq.checkNotNull((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public final void zzaf(DataHolder dataHolder) {
            this.zzhrd.setResult((Object)new zzp(dataHolder, this.zzhre));
        }
    }

    static final class zzbp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzhrc;

        public zzbp(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2) {
            this.zzhrc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzag(DataHolder dataHolder) {
            this.zzhrc.setResult((Object)new zzd(dataHolder));
        }
    }

    static final class zzbz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzhrk;

        public zzbz(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2) {
            this.zzhrk = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzdg(n);
            this.zzhrk.setResult((Object)new zzav(status, bundle));
        }
    }

    static final class zzca
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzhrl;

        public zzca(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2) {
            this.zzhrl = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzac(DataHolder dataHolder) {
            this.zzhrl.setResult((Object)new zzcw(dataHolder));
        }
    }

    static final class zzbo
    extends com.google.android.gms.games.internal.zzb {
        private final com.google.android.gms.games.internal.zzaa zzhpl;

        public zzbo(com.google.android.gms.games.internal.zzaa zzaa2) {
            this.zzhpl = zzaa2;
        }

        @Override
        public final com.google.android.gms.games.internal.zzy zzarq() {
            return new com.google.android.gms.games.internal.zzy(this.zzhpl.zzhsm);
        }
    }

    static final class zzy
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzgbw;

        public zzy(com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(int n, String string) {
            Status status = GamesStatusCodes.zzdg(n);
            this.zzgbw.setResult((Object)new zzz(status, string));
        }
    }

    static final class zzcg
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Status> zzgbw;

        public zzcg(com.google.android.gms.common.api.internal.zzn<Status> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzajf() {
            Status status = GamesStatusCodes.zzdg(0);
            this.zzgbw.setResult((Object)status);
        }
    }

    static final class zzbv
    extends com.google.android.gms.games.internal.zza {
        private com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zzhri;

        public zzbv(com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zzci2) {
            this.zzhri = zzci2;
        }

        @Override
        public final void zzb(int n, int n2, String string) {
            if (this.zzhri != null) {
                this.zzhri.zza((com.google.android.gms.common.api.internal.zzcl)new zzbu(n, n2, string));
            }
        }
    }

    static final class zzcc
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzhrm;
        private final com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzhrn;
        private final com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzhro;

        public zzcc(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2) {
            this.zzhrm = (com.google.android.gms.common.api.internal.zzci)com.google.android.gms.common.internal.zzbq.checkNotNull(zzci2, (Object)"Callbacks must not be null");
            this.zzhrn = null;
            this.zzhro = null;
        }

        public zzcc(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4) {
            this.zzhrm = (com.google.android.gms.common.api.internal.zzci)com.google.android.gms.common.internal.zzbq.checkNotNull(zzci2, (Object)"Callbacks must not be null");
            this.zzhrn = zzci3;
            this.zzhro = zzci4;
        }

        @Override
        public final void zzu(DataHolder dataHolder) {
            this.zzhrm.zza((com.google.android.gms.common.api.internal.zzcl)new zzcf(dataHolder));
        }

        @Override
        public final void zzv(DataHolder dataHolder) {
            this.zzhrm.zza((com.google.android.gms.common.api.internal.zzcl)new zzaf(dataHolder));
        }

        @Override
        public final void onLeftRoom(int n, String string) {
            this.zzhrm.zza((com.google.android.gms.common.api.internal.zzcl)new zzak(n, string));
        }

        @Override
        public final void zzy(DataHolder dataHolder) {
            this.zzhrm.zza((com.google.android.gms.common.api.internal.zzcl)new zzcd(dataHolder));
        }

        @Override
        public final void zzw(DataHolder dataHolder) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzce(dataHolder));
            }
        }

        @Override
        public final void zzx(DataHolder dataHolder) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzcb(dataHolder));
            }
        }

        @Override
        public final void zzz(DataHolder dataHolder) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzr(dataHolder));
            }
        }

        @Override
        public final void zzaa(DataHolder dataHolder) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzt(dataHolder));
            }
        }

        @Override
        public final void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzbf(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzbh(dataHolder, stringArray));
            }
        }

        @Override
        public final void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzbi(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzbj(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzbk(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzbg(dataHolder, stringArray));
            }
        }

        @Override
        public final void onP2PConnected(String string) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzbd(string));
            }
        }

        @Override
        public final void onP2PDisconnected(String string) {
            if (this.zzhrn != null) {
                this.zzhrn.zza((com.google.android.gms.common.api.internal.zzcl)new zzbe(string));
            }
        }

        @Override
        public final void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.zzhro != null) {
                this.zzhro.zza((com.google.android.gms.common.api.internal.zzcl)new zzbb(realTimeMessage));
            }
        }
    }

    static final class zzcn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzhrt;

        public zzcn(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2) {
            this.zzhrt = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzdg(n);
            this.zzhrt.setResult((Object)new zzg(status, string));
        }
    }

    static final class zzcp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzhrv;

        public zzcp(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2) {
            this.zzhrv = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzs(DataHolder dataHolder) {
            this.zzhrv.setResult((Object)new zzaj(dataHolder));
        }
    }

    static final class zzcs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzhrx;

        public zzcs(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2) {
            this.zzhrx = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzr(DataHolder dataHolder) {
            this.zzhrx.setResult((Object)new zzcv(dataHolder));
        }
    }

    static final class zzco
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzhru;

        public zzco(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2) {
            this.zzhru = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzq(DataHolder dataHolder) {
            this.zzhru.setResult((Object)new zzaa(dataHolder));
        }
    }

    static final class zzcq
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzhrw;

        public zzcq(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2) {
            this.zzhrw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzp(DataHolder dataHolder) {
            this.zzhrw.setResult((Object)new zzap(dataHolder));
        }
    }

    static final class zzct
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzhry;

        public zzct(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2) {
            this.zzhry = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzb(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzdg(n);
            this.zzhry.setResult((Object)new zzaq(status, bundle));
        }
    }

    static final class zzcl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzgbw;

        public zzcl(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(DataHolder dataHolder) {
            this.zzgbw.setResult((Object)new zzcm(dataHolder));
        }
    }

    static final class zzbn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzgbw;

        zzbn(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(DataHolder dataHolder) {
            this.zzgbw.setResult((Object)new zzat(dataHolder));
        }

        @Override
        public final void zzk(DataHolder dataHolder) {
            this.zzgbw.setResult((Object)new zzat(dataHolder));
        }
    }

    static final class zzbw
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<OnRequestReceivedListener> zzgoh;

        zzbw(com.google.android.gms.common.api.internal.zzci<OnRequestReceivedListener> zzci2) {
            this.zzgoh = zzci2;
        }

        @Override
        public final void zzo(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzgoh.zza((com.google.android.gms.common.api.internal.zzcl)new zzbx(gameRequest));
            }
        }

        @Override
        public final void onRequestRemoved(String string) {
            this.zzgoh.zza((com.google.android.gms.common.api.internal.zzcl)new zzby(string));
        }
    }

    static final class zzbs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<QuestUpdateListener> zzgoh;

        zzbs(com.google.android.gms.common.api.internal.zzci<QuestUpdateListener> zzci2) {
            this.zzgoh = zzci2;
        }

        @Override
        public final void zzah(DataHolder dataHolder) {
            Quest quest = zzbs.zzam(dataHolder);
            if (quest != null) {
                this.zzgoh.zza((com.google.android.gms.common.api.internal.zzcl)new zzbq(quest));
            }
        }

        private static Quest zzam(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    static final class zzaz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zzgoh;

        zzaz(com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zzci2) {
            this.zzgoh = zzci2;
        }

        @Override
        public final void zzt(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzgoh.zza((com.google.android.gms.common.api.internal.zzcl)new zzba(turnBasedMatch));
            }
        }

        @Override
        public final void onTurnBasedMatchRemoved(String string) {
            this.zzgoh.zza((com.google.android.gms.common.api.internal.zzcl)new zzay(string));
        }
    }

    static final class zzab
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zzgoh;

        zzab(com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zzci2) {
            this.zzgoh = zzci2;
        }

        @Override
        public final void zzn(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzgoh.zza((com.google.android.gms.common.api.internal.zzcl)new zzac(invitation));
            }
        }

        @Override
        public final void onInvitationRemoved(String string) {
            this.zzgoh.zza((com.google.android.gms.common.api.internal.zzcl)new zzad(string));
        }
    }

    static final class zzae
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzgbw;

        zzae(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzm(DataHolder dataHolder) {
            this.zzgbw.setResult((Object)new zzao(dataHolder));
        }
    }

    static final class zzbl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzgbw;

        zzbl(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzab(DataHolder dataHolder) {
            this.zzgbw.setResult((Object)new zzar(dataHolder));
        }
    }

    static final class zzah
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzgbw;

        zzah(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzgbw.setResult((Object)new zzaw(dataHolder, dataHolder2));
        }
    }

    static final class zzai
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzgbw;

        zzai(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(DataHolder dataHolder) {
            this.zzgbw.setResult((Object)new zzag(dataHolder));
        }
    }

    static final class zzu
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzgbw;

        zzu(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(DataHolder dataHolder) {
            this.zzgbw.setResult((Object)new zzam(dataHolder));
        }
    }

    static final class zzx
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzgbw;

        zzx(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzl(DataHolder dataHolder) {
            this.zzgbw.setResult((Object)new zzan(dataHolder));
        }
    }

    static final class zze
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzgbw;

        zze(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(int n, String string) {
            this.zzgbw.setResult((Object)new zzcu(n, string));
        }
    }

    static final class zzf
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzgbw;

        zzf(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2) {
            this.zzgbw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzf(DataHolder dataHolder) {
            this.zzgbw.setResult((Object)new zzal(dataHolder));
        }
    }

    final class zzv
    extends zzcbf {
        private /* synthetic */ GamesClientImpl zzhps;

        public zzv(GamesClientImpl gamesClientImpl) {
            this.zzhps = gamesClientImpl;
            super(gamesClientImpl.getContext().getMainLooper(), 1000);
        }

        @Override
        protected final void zzu(String string, int n) {
            try {
                if (this.zzhps.isConnected()) {
                    ((com.google.android.gms.games.internal.zzw)this.zzhps.zzakn()).zzp(string, n);
                    return;
                }
                com.google.android.gms.games.internal.zzf.zzw("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
                return;
            }
            catch (SecurityException securityException) {
                GamesClientImpl.zza(securityException);
                return;
            }
        }
    }
}

