/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import java.util.Arrays;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzhwk;
    private final String zzhwl;
    private final String zzhwm;
    private final long zzhwn;
    private final long zzhwo;
    private final String zzhwp;
    private final Uri zzhwq;
    private final Uri zzhwr;
    private final PlayerEntity zzhws;
    private final String zzhwt;
    private final String zzhwu;
    private final String zzhwv;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zzhwk = leaderboardScore.getRank();
        this.zzhwl = (String)zzbq.checkNotNull((Object)leaderboardScore.getDisplayRank());
        this.zzhwm = (String)zzbq.checkNotNull((Object)leaderboardScore.getDisplayScore());
        this.zzhwn = leaderboardScore.getRawScore();
        this.zzhwo = leaderboardScore.getTimestampMillis();
        this.zzhwp = leaderboardScore.getScoreHolderDisplayName();
        this.zzhwq = leaderboardScore.getScoreHolderIconImageUri();
        this.zzhwr = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zzhws = player == null ? null : (PlayerEntity)player.freeze();
        this.zzhwt = leaderboardScore.getScoreTag();
        this.zzhwu = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzhwv = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public final long getRank() {
        return this.zzhwk;
    }

    @Override
    public final String getDisplayRank() {
        return this.zzhwl;
    }

    @Override
    public final void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhwl, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDisplayScore() {
        return this.zzhwm;
    }

    @Override
    public final void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhwm, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getRawScore() {
        return this.zzhwn;
    }

    @Override
    public final long getTimestampMillis() {
        return this.zzhwo;
    }

    @Override
    public final String getScoreHolderDisplayName() {
        if (this.zzhws == null) {
            return this.zzhwp;
        }
        return this.zzhws.getDisplayName();
    }

    @Override
    public final void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhws == null) {
            zzg.zzb((String)this.zzhwp, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzhws.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getScoreHolderIconImageUri() {
        if (this.zzhws == null) {
            return this.zzhwq;
        }
        return this.zzhws.getIconImageUri();
    }

    @Override
    public final String getScoreHolderIconImageUrl() {
        if (this.zzhws == null) {
            return this.zzhwu;
        }
        return this.zzhws.getIconImageUrl();
    }

    @Override
    public final Uri getScoreHolderHiResImageUri() {
        if (this.zzhws == null) {
            return this.zzhwr;
        }
        return this.zzhws.getHiResImageUri();
    }

    @Override
    public final String getScoreHolderHiResImageUrl() {
        if (this.zzhws == null) {
            return this.zzhwv;
        }
        return this.zzhws.getHiResImageUrl();
    }

    @Override
    public final Player getScoreHolder() {
        return this.zzhws;
    }

    @Override
    public final String getScoreTag() {
        return this.zzhwt;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return Arrays.hashCode(new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public final boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzbg.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzbg.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzbg.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzbg.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzbg.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzbg.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzbg.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzbg.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzbg.zzx((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }
}

