/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;

public final class LeaderboardScoreRef
extends zzc
implements LeaderboardScore {
    private final PlayerRef zzhww;

    LeaderboardScoreRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
        this.zzhww = new PlayerRef(dataHolder, n);
    }

    @Override
    public final long getRank() {
        return this.getLong("rank");
    }

    @Override
    public final String getDisplayRank() {
        return this.getString("display_rank");
    }

    @Override
    public final void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        this.zza("display_rank", charArrayBuffer);
    }

    @Override
    public final String getDisplayScore() {
        return this.getString("display_score");
    }

    @Override
    public final void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        this.zza("display_score", charArrayBuffer);
    }

    @Override
    public final long getRawScore() {
        return this.getLong("raw_score");
    }

    @Override
    public final long getTimestampMillis() {
        return this.getLong("achieved_timestamp");
    }

    @Override
    public final String getScoreHolderDisplayName() {
        if (this.zzgc("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.zzhww.getDisplayName();
    }

    @Override
    public final void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzgc("external_player_id")) {
            this.zza("default_display_name", charArrayBuffer);
            return;
        }
        this.zzhww.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getScoreHolderIconImageUri() {
        if (this.zzgc("external_player_id")) {
            return this.zzgb("default_display_image_uri");
        }
        return this.zzhww.getIconImageUri();
    }

    @Override
    public final String getScoreHolderIconImageUrl() {
        if (this.zzgc("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.zzhww.getIconImageUrl();
    }

    @Override
    public final Uri getScoreHolderHiResImageUri() {
        if (this.zzgc("external_player_id")) {
            return null;
        }
        return this.zzhww.getHiResImageUri();
    }

    @Override
    public final String getScoreHolderHiResImageUrl() {
        if (this.zzgc("external_player_id")) {
            return null;
        }
        return this.zzhww.getHiResImageUrl();
    }

    @Override
    public final Player getScoreHolder() {
        if (this.zzgc("external_player_id")) {
            return null;
        }
        return this.zzhww;
    }

    @Override
    public final String getScoreTag() {
        return this.getString("score_tag");
    }

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    public final boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    public final /* synthetic */ Object freeze() {
        LeaderboardScoreRef leaderboardScoreRef = this;
        return new LeaderboardScoreEntity(leaderboardScoreRef);
    }
}

