/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.api.zzp;
import com.google.android.gms.games.internal.zzg;
import com.google.android.gms.games.internal.zzn;
import com.google.android.gms.games.internal.zzo;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchUpdateCallback;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.zzcd;
import com.google.android.gms.games.zzce;
import com.google.android.gms.games.zzcf;
import com.google.android.gms.games.zzcg;
import com.google.android.gms.games.zzch;
import com.google.android.gms.games.zzci;
import com.google.android.gms.games.zzcj;
import com.google.android.gms.games.zzck;
import com.google.android.gms.games.zzcl;
import com.google.android.gms.games.zzcm;
import com.google.android.gms.games.zzcn;
import com.google.android.gms.games.zzco;
import com.google.android.gms.games.zzcp;
import com.google.android.gms.games.zzcq;
import com.google.android.gms.games.zzcr;
import com.google.android.gms.games.zzcs;
import com.google.android.gms.games.zzct;
import com.google.android.gms.games.zzcu;
import com.google.android.gms.games.zzcv;
import com.google.android.gms.tasks.Task;
import java.util.List;

public class TurnBasedMultiplayerClient
extends zzp {
    private static final zzn<TurnBasedMatch> zzb = new zzcv();
    private static final zzbo<TurnBasedMultiplayer.LoadMatchesResult, LoadMatchesResponse> zzc = new zzce();
    private static final zzo<TurnBasedMultiplayer.LoadMatchesResult> zzd = new zzcf();
    private static final zzbo<TurnBasedMultiplayer.LoadMatchResult, TurnBasedMatch> zze = new zzcg();
    private static final zzbo<TurnBasedMultiplayer.CancelMatchResult, String> zzf = new zzch();
    private static final com.google.android.gms.games.internal.zzp zzg = new zzci();
    private static final zzbo<TurnBasedMultiplayer.LeaveMatchResult, Void> zzh = new zzcj();
    private static final zzbo<TurnBasedMultiplayer.LeaveMatchResult, TurnBasedMatch> zzi = new zzck();
    private static final com.google.android.gms.games.internal.zzp zzj = new zzcl();
    private static final zzbo<TurnBasedMultiplayer.UpdateMatchResult, TurnBasedMatch> zzk = new zzcm();
    private static final zzbo<TurnBasedMultiplayer.InitiateMatchResult, TurnBasedMatch> zzl = new zzcn();

    @Hide
    TurnBasedMultiplayerClient(@NonNull Context context, @NonNull Games.GamesOptions gamesOptions) {
        super(context, gamesOptions);
    }

    @Hide
    TurnBasedMultiplayerClient(@NonNull Activity activity, @NonNull Games.GamesOptions gamesOptions) {
        super(activity, gamesOptions);
    }

    public Task<Intent> getInboxIntent() {
        return this.zza(new zzcd(this));
    }

    public Task<Void> registerTurnBasedMatchUpdateCallback(@NonNull TurnBasedMatchUpdateCallback turnBasedMatchUpdateCallback) {
        com.google.android.gms.common.api.internal.zzci zzci2 = this.zza(turnBasedMatchUpdateCallback, TurnBasedMatchUpdateCallback.class.getSimpleName());
        zzco zzco2 = new zzco(this, zzci2, zzci2);
        zzcp zzcp2 = new zzcp(this, zzci2.zzc());
        return this.zza(zzco2, zzcp2);
    }

    public Task<Boolean> unregisterTurnBasedMatchUpdateCallback(@NonNull TurnBasedMatchUpdateCallback turnBasedMatchUpdateCallback) {
        return this.zza(com.google.android.gms.common.api.internal.zzcm.zza((Object)turnBasedMatchUpdateCallback, (String)TurnBasedMatchUpdateCallback.class.getSimpleName()));
    }

    public Task<Intent> getSelectOpponentsIntent(@IntRange(from=1L) int n, @IntRange(from=1L) int n2) {
        return this.getSelectOpponentsIntent(n, n2, true);
    }

    public Task<Intent> getSelectOpponentsIntent(@IntRange(from=1L) int n, @IntRange(from=1L) int n2, boolean bl) {
        return this.zza(new zzcq(this, n, n2, bl));
    }

    public Task<TurnBasedMatch> createMatch(@NonNull TurnBasedMatchConfig turnBasedMatchConfig) {
        return com.google.android.gms.games.internal.zzg.zza(Games.TurnBasedMultiplayer.createMatch(this.zze(), turnBasedMatchConfig), zzl);
    }

    public Task<TurnBasedMatch> rematch(@NonNull String string) {
        return com.google.android.gms.games.internal.zzg.zza(Games.TurnBasedMultiplayer.rematch(this.zze(), string), zzl);
    }

    public Task<TurnBasedMatch> acceptInvitation(@NonNull String string) {
        return com.google.android.gms.games.internal.zzg.zza(Games.TurnBasedMultiplayer.acceptInvitation(this.zze(), string), zzl);
    }

    public Task<Void> declineInvitation(@NonNull String string) {
        return this.zzb(new zzcr(this, string));
    }

    public Task<Void> dismissInvitation(@NonNull String string) {
        return this.zzb(new zzcs(this, string));
    }

    public Task<Integer> getMaxMatchDataSize() {
        return this.zza(new zzct(this));
    }

    public Task<TurnBasedMatch> takeTurn(@NonNull String string, @Nullable byte[] byArray, @Nullable String string2) {
        return TurnBasedMultiplayerClient.zzb(Games.TurnBasedMultiplayer.takeTurn(this.zze(), string, byArray, string2));
    }

    public Task<TurnBasedMatch> takeTurn(@NonNull String string, @Nullable byte[] byArray, @Nullable String string2, ParticipantResult ... participantResultArray) {
        return TurnBasedMultiplayerClient.zzb(Games.TurnBasedMultiplayer.takeTurn(this.zze(), string, byArray, string2, participantResultArray));
    }

    public Task<TurnBasedMatch> takeTurn(@NonNull String string, @Nullable byte[] byArray, @Nullable String string2, @Nullable List<ParticipantResult> list) {
        return TurnBasedMultiplayerClient.zzb(Games.TurnBasedMultiplayer.takeTurn(this.zze(), string, byArray, string2, list));
    }

    public Task<TurnBasedMatch> finishMatch(@NonNull String string) {
        return TurnBasedMultiplayerClient.zzb(Games.TurnBasedMultiplayer.finishMatch(this.zze(), string));
    }

    public Task<TurnBasedMatch> finishMatch(@NonNull String string, @Nullable byte[] byArray, ParticipantResult ... participantResultArray) {
        return TurnBasedMultiplayerClient.zzb(Games.TurnBasedMultiplayer.finishMatch(this.zze(), string, byArray, participantResultArray));
    }

    public Task<TurnBasedMatch> finishMatch(@NonNull String string, @Nullable byte[] byArray, @Nullable List<ParticipantResult> list) {
        return TurnBasedMultiplayerClient.zzb(Games.TurnBasedMultiplayer.finishMatch(this.zze(), string, byArray, list));
    }

    public Task<Void> leaveMatch(@NonNull String string) {
        return TurnBasedMultiplayerClient.zza(Games.TurnBasedMultiplayer.leaveMatch(this.zze(), string));
    }

    public Task<Void> leaveMatchDuringTurn(@NonNull String string, @Nullable String string2) {
        return TurnBasedMultiplayerClient.zza(Games.TurnBasedMultiplayer.leaveMatchDuringTurn(this.zze(), string, string2));
    }

    public Task<String> cancelMatch(@NonNull String string) {
        return com.google.android.gms.games.internal.zzg.zza(Games.TurnBasedMultiplayer.cancelMatch(this.zze(), string), zzf);
    }

    public Task<Void> dismissMatch(@NonNull String string) {
        return this.zzb(new zzcu(this, string));
    }

    public Task<AnnotatedData<LoadMatchesResponse>> loadMatchesByStatus(@NonNull int[] nArray) {
        return com.google.android.gms.games.internal.zzg.zza(Games.TurnBasedMultiplayer.loadMatchesByStatus(this.zze(), nArray), zzc, zzd);
    }

    public Task<AnnotatedData<LoadMatchesResponse>> loadMatchesByStatus(int n, @NonNull int[] nArray) {
        return com.google.android.gms.games.internal.zzg.zza(Games.TurnBasedMultiplayer.loadMatchesByStatus(this.zze(), n, nArray), zzc, zzd);
    }

    public Task<AnnotatedData<TurnBasedMatch>> loadMatch(@NonNull String string) {
        return com.google.android.gms.games.internal.zzg.zzb(Games.TurnBasedMultiplayer.loadMatch(this.zze(), string), zze);
    }

    private static Task<Void> zza(@NonNull PendingResult<TurnBasedMultiplayer.LeaveMatchResult> pendingResult) {
        return com.google.android.gms.games.internal.zzg.zza(pendingResult, zzg, zzh, zzi, zzb);
    }

    private static Task<TurnBasedMatch> zzb(@NonNull PendingResult<TurnBasedMultiplayer.UpdateMatchResult> pendingResult) {
        return com.google.android.gms.games.internal.zzg.zza(pendingResult, zzj, zzk, zzk, zzb);
    }

    public static class MatchOutOfDateApiException
    extends ApiException {
        protected final TurnBasedMatch match;

        MatchOutOfDateApiException(@NonNull Status status, @NonNull TurnBasedMatch turnBasedMatch) {
            super(status);
            this.match = turnBasedMatch;
        }

        public TurnBasedMatch getMatch() {
            return this.match;
        }
    }
}

