/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.zza;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;

public final class AchievementEntity
extends zzc
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new zza();
    private final String zza;
    private final int zzb;
    private final String zzc;
    private final String zzd;
    private final Uri zze;
    private final String zzf;
    private final Uri zzg;
    private final String zzh;
    private final int zzi;
    private final String zzj;
    private final PlayerEntity zzk;
    private final int zzl;
    private final int zzm;
    private final String zzn;
    private final long zzo;
    private final long zzp;

    @Hide
    public AchievementEntity(Achievement achievement) {
        this.zza = achievement.getAchievementId();
        this.zzb = achievement.getType();
        this.zzc = achievement.getName();
        this.zzd = achievement.getDescription();
        this.zze = achievement.getUnlockedImageUri();
        this.zzf = achievement.getUnlockedImageUrl();
        this.zzg = achievement.getRevealedImageUri();
        this.zzh = achievement.getRevealedImageUrl();
        this.zzk = (PlayerEntity)achievement.getPlayer().freeze();
        this.zzl = achievement.getState();
        this.zzo = achievement.getLastUpdatedTimestamp();
        this.zzp = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzi = achievement.getTotalSteps();
            this.zzj = achievement.getFormattedTotalSteps();
            this.zzm = achievement.getCurrentSteps();
            this.zzn = achievement.getFormattedCurrentSteps();
        } else {
            this.zzi = 0;
            this.zzj = null;
            this.zzm = 0;
            this.zzn = null;
        }
        com.google.android.gms.common.internal.zzc.zza((Object)this.zza);
        com.google.android.gms.common.internal.zzc.zza((Object)this.zzd);
    }

    AchievementEntity(String string, int n, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n2, String string6, PlayerEntity playerEntity, int n3, int n4, String string7, long l, long l2) {
        this.zza = string;
        this.zzb = n;
        this.zzc = string2;
        this.zzd = string3;
        this.zze = uri;
        this.zzf = string4;
        this.zzg = uri2;
        this.zzh = string5;
        this.zzi = n2;
        this.zzj = string6;
        this.zzk = playerEntity;
        this.zzl = n3;
        this.zzm = n4;
        this.zzn = string7;
        this.zzo = l;
        this.zzp = l2;
    }

    @Override
    public final String getAchievementId() {
        return this.zza;
    }

    @Override
    public final int getType() {
        return this.zzb;
    }

    @Override
    public final String getName() {
        return this.zzc;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzh.zza((String)this.zzc, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzd;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzh.zza((String)this.zzd, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getUnlockedImageUri() {
        return this.zze;
    }

    @Override
    public final String getUnlockedImageUrl() {
        return this.zzf;
    }

    @Override
    public final Uri getRevealedImageUri() {
        return this.zzg;
    }

    @Override
    public final String getRevealedImageUrl() {
        return this.zzh;
    }

    @Override
    public final int getTotalSteps() {
        com.google.android.gms.common.internal.zzc.zza((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzi;
    }

    @Override
    public final String getFormattedTotalSteps() {
        com.google.android.gms.common.internal.zzc.zza((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzj;
    }

    @Override
    public final void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zza((this.getType() == 1 ? 1 : 0) != 0);
        com.google.android.gms.common.util.zzh.zza((String)this.zzj, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Player getPlayer() {
        return this.zzk;
    }

    @Override
    public final int getState() {
        return this.zzl;
    }

    @Override
    public final int getCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zza((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzm;
    }

    @Override
    public final String getFormattedCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zza((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzn;
    }

    @Override
    public final void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zza((this.getType() == 1 ? 1 : 0) != 0);
        com.google.android.gms.common.util.zzh.zza((String)this.zzn, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzo;
    }

    @Override
    public final long getXpValue() {
        return this.zzp;
    }

    public final Achievement freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        AchievementEntity achievementEntity = this;
        int n = 0;
        int n2 = 0;
        if (achievementEntity.getType() == 1) {
            n = achievementEntity.getCurrentSteps();
            n2 = achievementEntity.getTotalSteps();
        }
        return Arrays.hashCode(new Object[]{achievementEntity.getAchievementId(), achievementEntity.getName(), achievementEntity.getType(), achievementEntity.getDescription(), achievementEntity.getXpValue(), achievementEntity.getState(), achievementEntity.getLastUpdatedTimestamp(), achievementEntity.getPlayer(), n, n2});
    }

    public final boolean equals(Object object) {
        Object object2 = object;
        AchievementEntity achievementEntity = this;
        if (object2 instanceof Achievement) {
            if (achievementEntity == object2) {
                return true;
            }
            Achievement achievement = (Achievement)object2;
            boolean bl = true;
            boolean bl2 = true;
            if (achievementEntity.getType() == 1) {
                bl = zzbg.zza((Object)achievement.getCurrentSteps(), (Object)achievementEntity.getCurrentSteps());
                bl2 = zzbg.zza((Object)achievement.getTotalSteps(), (Object)achievementEntity.getTotalSteps());
            }
            if (zzbg.zza((Object)achievement.getAchievementId(), (Object)achievementEntity.getAchievementId()) && zzbg.zza((Object)achievement.getName(), (Object)achievementEntity.getName()) && zzbg.zza((Object)achievement.getType(), (Object)achievementEntity.getType()) && zzbg.zza((Object)achievement.getDescription(), (Object)achievementEntity.getDescription()) && zzbg.zza((Object)achievement.getXpValue(), (Object)achievementEntity.getXpValue()) && zzbg.zza((Object)achievement.getState(), (Object)achievementEntity.getState()) && zzbg.zza((Object)achievement.getLastUpdatedTimestamp(), (Object)achievementEntity.getLastUpdatedTimestamp()) && zzbg.zza((Object)achievement.getPlayer(), (Object)achievementEntity.getPlayer()) && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        return AchievementEntity.zza(this);
    }

    static String zza(Achievement achievement) {
        zzbi zzbi2 = zzbg.zza((Object)achievement).zza("Id", (Object)achievement.getAchievementId()).zza("Type", (Object)achievement.getType()).zza("Name", (Object)achievement.getName()).zza("Description", (Object)achievement.getDescription()).zza("Player", (Object)achievement.getPlayer()).zza("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zzbi2.zza("CurrentSteps", (Object)achievement.getCurrentSteps());
            zzbi2.zza("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zzbi2.toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AchievementEntity achievementEntity = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)achievementEntity.getAchievementId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (int)achievementEntity.getType());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)achievementEntity.getName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)achievementEntity.getDescription(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)achievementEntity.getUnlockedImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)achievementEntity.getUnlockedImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)achievementEntity.getRevealedImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (String)achievementEntity.getRevealedImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (int)achievementEntity.zzi);
        zzbgo.zza((Parcel)parcel2, (int)10, (String)achievementEntity.zzj, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)11, (Parcelable)achievementEntity.getPlayer(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)12, (int)achievementEntity.getState());
        zzbgo.zza((Parcel)parcel2, (int)13, (int)achievementEntity.zzm);
        zzbgo.zza((Parcel)parcel2, (int)14, (String)achievementEntity.zzn, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)15, (long)achievementEntity.getLastUpdatedTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)16, (long)achievementEntity.getXpValue());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }
}

