/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.zzb;
import java.util.ArrayList;
import java.util.Arrays;

@Hide
public final class LeaderboardEntity
implements Leaderboard {
    private final String zza;
    private final String zzb;
    private final Uri zzc;
    private final int zzd;
    private final ArrayList<zzb> zze;
    private final Game zzf;
    private final String zzg;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zza = leaderboard.getLeaderboardId();
        this.zzb = leaderboard.getDisplayName();
        this.zzc = leaderboard.getIconImageUri();
        this.zzg = leaderboard.getIconImageUrl();
        this.zzd = leaderboard.getScoreOrder();
        Game game = leaderboard.zza();
        this.zzf = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zze = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zze.add((zzb)arrayList.get(i).freeze());
        }
    }

    @Override
    public final String getLeaderboardId() {
        return this.zza;
    }

    @Override
    public final String getDisplayName() {
        return this.zzb;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzh.zza((String)this.zzb, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzc;
    }

    @Override
    @Hide
    public final String getIconImageUrl() {
        return this.zzg;
    }

    @Override
    public final int getScoreOrder() {
        return this.zzd;
    }

    @Override
    public final ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zze);
    }

    @Override
    @Hide
    public final Game zza() {
        return this.zzf;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return Arrays.hashCode(new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public final boolean equals(Object object) {
        return LeaderboardEntity.zza(this, object);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzbg.zza((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzbg.zza((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzbg.zza((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzbg.zza((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzbg.zza(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public final String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzbg.zza((Object)leaderboard).zza("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zza("DisplayName", (Object)leaderboard.getDisplayName()).zza("IconImageUri", (Object)leaderboard.getIconImageUri()).zza("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zza("ScoreOrder", (Object)leaderboard.getScoreOrder()).zza("Variants", leaderboard.getVariants()).toString();
    }
}

