/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new zza();
    private final GameEntity zza;
    private final String zzb;
    private final long zzc;
    private final int zzd;
    private final ParticipantEntity zze;
    private final ArrayList<ParticipantEntity> zzf;
    private final int zzg;
    private final int zzh;

    InvitationEntity(Invitation invitation) {
        this.zza = new GameEntity(invitation.getGame());
        this.zzb = invitation.getInvitationId();
        this.zzc = invitation.getCreationTimestamp();
        this.zzd = invitation.getInvitationType();
        this.zzg = invitation.getVariant();
        this.zzh = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.zzf = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.zzf.add((ParticipantEntity)participant2.freeze());
        }
        zzbq.zza(participant, (Object)"Must have a valid inviter!");
        this.zze = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(GameEntity gameEntity, String string, long l, int n, ParticipantEntity participantEntity, ArrayList<ParticipantEntity> arrayList, int n2, int n3) {
        this.zza = gameEntity;
        this.zzb = string;
        this.zzc = l;
        this.zzd = n;
        this.zze = participantEntity;
        this.zzf = arrayList;
        this.zzg = n2;
        this.zzh = n3;
    }

    @Override
    public final Game getGame() {
        return this.zza;
    }

    @Override
    public final String getInvitationId() {
        return this.zzb;
    }

    @Override
    public final Participant getInviter() {
        return this.zze;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.zzc;
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzf);
    }

    @Override
    @Hide
    public final int getInvitationType() {
        return this.zzd;
    }

    @Override
    public final int getVariant() {
        return this.zzg;
    }

    @Override
    public final int getAvailableAutoMatchSlots() {
        return this.zzh;
    }

    public final Invitation freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return Arrays.hashCode(new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public final boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzbg.zza((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzbg.zza((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzbg.zza((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzbg.zza((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzbg.zza((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzbg.zza((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzbg.zza((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzbg.zza((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public final String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzbg.zza((Object)invitation).zza("Game", (Object)invitation.getGame()).zza("InvitationId", (Object)invitation.getInvitationId()).zza("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zza("InvitationType", (Object)invitation.getInvitationType()).zza("Inviter", (Object)invitation.getInviter()).zza("Participants", (Object)invitation.getParticipants()).zza("Variant", (Object)invitation.getVariant()).zza("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        InvitationEntity invitationEntity = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)invitationEntity.getGame(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)invitationEntity.getInvitationId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)invitationEntity.getCreationTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)4, (int)invitationEntity.getInvitationType());
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)invitationEntity.getInviter(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)6, invitationEntity.getParticipants(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (int)invitationEntity.getVariant());
        zzbgo.zza((Parcel)parcel2, (int)8, (int)invitationEntity.getAvailableAutoMatchSlots());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends com.google.android.gms.games.multiplayer.zza {
        zza() {
        }

        @Override
        public final InvitationEntity zza(Parcel parcel) {
            if (InvitationEntity.zzb(InvitationEntity.o_()) || InvitationEntity.zza((String)InvitationEntity.class.getCanonicalName())) {
                return super.zza(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n2 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new InvitationEntity(gameEntity, string, l, n, participantEntity, arrayList, -1, 0);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((com.google.android.gms.games.multiplayer.zza)this).zza(parcel);
        }
    }
}

