/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.zza;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class GameRequestEntity
extends zzc
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new zza();
    private final GameEntity zza;
    private final PlayerEntity zzb;
    private final byte[] zzc;
    private final String zzd;
    private final ArrayList<PlayerEntity> zze;
    private final int zzf;
    private final long zzg;
    private final long zzh;
    private final Bundle zzi;
    private final int zzj;

    @Hide
    public GameRequestEntity(GameRequest gameRequest) {
        this.zza = new GameEntity(gameRequest.getGame());
        this.zzb = new PlayerEntity(gameRequest.getSender());
        this.zzd = gameRequest.getRequestId();
        this.zzf = gameRequest.getType();
        this.zzg = gameRequest.getCreationTimestamp();
        this.zzh = gameRequest.getExpirationTimestamp();
        this.zzj = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.zzc = null;
        } else {
            this.zzc = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzc, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.zze = new ArrayList(n);
        this.zzi = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zze.add((PlayerEntity)player);
            this.zzi.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n, long l, long l2, Bundle bundle, int n2) {
        this.zza = gameEntity;
        this.zzb = playerEntity;
        this.zzc = byArray;
        this.zzd = string;
        this.zze = arrayList;
        this.zzf = n;
        this.zzg = l;
        this.zzh = l2;
        this.zzi = bundle;
        this.zzj = n2;
    }

    @Override
    public final String getRequestId() {
        return this.zzd;
    }

    @Override
    public final Game getGame() {
        return this.zza;
    }

    @Override
    public final Player getSender() {
        return this.zzb;
    }

    @Override
    public final List<Player> getRecipients() {
        return new ArrayList<Player>(this.zze);
    }

    @Override
    public final boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public final byte[] getData() {
        return this.zzc;
    }

    @Override
    public final int getType() {
        return this.zzf;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.zzg;
    }

    @Override
    public final long getExpirationTimestamp() {
        return this.zzh;
    }

    @Override
    public final int getRecipientStatus(String string) {
        return this.zzi.getInt(string, 0);
    }

    @Override
    public final int getStatus() {
        return this.zzj;
    }

    public final GameRequest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return Arrays.hashCode(new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzc(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public final boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzbg.zza((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzbg.zza(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzbg.zza((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzbg.zza((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzc(gameRequest2), GameRequestEntity.zzc(gameRequest)) && zzbg.zza((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzbg.zza((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzbg.zza((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzc(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public final String toString() {
        return GameRequestEntity.zzb(this);
    }

    static String zzb(GameRequest gameRequest) {
        return zzbg.zza((Object)gameRequest).zza("Game", (Object)gameRequest.getGame()).zza("Sender", (Object)gameRequest.getSender()).zza("Recipients", gameRequest.getRecipients()).zza("Data", (Object)gameRequest.getData()).zza("RequestId", (Object)gameRequest.getRequestId()).zza("Type", (Object)gameRequest.getType()).zza("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zza("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GameRequestEntity gameRequestEntity = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)gameRequestEntity.getGame(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)gameRequestEntity.getSender(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (byte[])gameRequestEntity.getData(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)gameRequestEntity.getRequestId(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)5, gameRequestEntity.getRecipients(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (int)gameRequestEntity.getType());
        zzbgo.zza((Parcel)parcel2, (int)9, (long)gameRequestEntity.getCreationTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)10, (long)gameRequestEntity.getExpirationTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)11, (Bundle)gameRequestEntity.zzi, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)12, (int)gameRequestEntity.getStatus());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }
}

