/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.zze;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new zze();

    public String getDescription();

    public Long getPlayedTimeMillis();

    @Hide
    public BitmapTeleporter zza();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zza;
        private Long zzb;
        private Long zzc;
        private BitmapTeleporter zzd;
        private Uri zze;

        public Builder() {
        }

        public final Builder setDescription(String string) {
            this.zza = string;
            return this;
        }

        public final Builder setPlayedTimeMillis(long l) {
            this.zzb = l;
            return this;
        }

        public final Builder setProgressValue(long l) {
            this.zzc = l;
            return this;
        }

        public final Builder setCoverImage(Bitmap bitmap) {
            this.zzd = new BitmapTeleporter(bitmap);
            this.zze = null;
            return this;
        }

        public final Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zza = snapshotMetadata.getDescription();
            this.zzb = snapshotMetadata.getPlayedTime();
            this.zzc = snapshotMetadata.getProgressValue();
            if (this.zzb == -1L) {
                this.zzb = null;
            }
            this.zze = snapshotMetadata.getCoverImageUri();
            if (this.zze != null) {
                this.zzd = null;
            }
            return this;
        }

        public final SnapshotMetadataChange build() {
            return new zze(this.zza, this.zzb, this.zzd, this.zze, this.zzc);
        }
    }
}

