/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.games.video.zzb;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class VideoConfiguration
extends zzbgl {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new zzb();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int zza;
    private final int zzb;
    private final String zzc;
    private final String zzd;
    private final String zze;
    private final String zzf;
    private final boolean zzg;

    @Hide
    public VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        zzbq.zzb((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        zzbq.zzb((boolean)VideoConfiguration.isValidCaptureMode(n2, false));
        this.zza = n;
        this.zzb = n2;
        this.zzg = bl;
        if (n2 == 1) {
            this.zzd = string2;
            this.zzc = string;
            this.zze = string3;
            this.zzf = string4;
            return;
        }
        zzbq.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
        zzbq.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
        zzbq.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
        zzbq.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
        this.zzd = null;
        this.zzc = null;
        this.zze = null;
        this.zzf = null;
    }

    public final int getQualityLevel() {
        return this.zza;
    }

    public final int getCaptureMode() {
        return this.zzb;
    }

    @Hide
    public final String getStreamUrl() {
        return this.zzc;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoConfiguration videoConfiguration = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (int)videoConfiguration.getQualityLevel());
        zzbgo.zza((Parcel)parcel2, (int)2, (int)videoConfiguration.getCaptureMode());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)videoConfiguration.getStreamUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)videoConfiguration.zzd, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)videoConfiguration.zze, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)videoConfiguration.zzf, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)videoConfiguration.zzg);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zza;
        private int zzb;
        private boolean zzc;
        private String zzd;
        private String zze;
        private String zzf;
        private String zzg;

        public Builder(int n, int n2) {
            this.zza = n;
            this.zzb = n2;
            this.zzc = true;
            this.zzd = null;
            this.zze = null;
            this.zzf = null;
            this.zzg = null;
        }

        public final Builder setQualityLevel(int n) {
            this.zza = n;
            return this;
        }

        public final Builder setCaptureMode(int n) {
            this.zzb = n;
            return this;
        }

        public final VideoConfiguration build() {
            return new VideoConfiguration(this.zza, this.zzb, null, null, null, null, this.zzc);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ValidCaptureModes {
    }
}

