/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.zzb;
import com.google.android.gms.games.zzap;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new zza();
    private String zzfld;
    private String zzemi;
    private final Uri zzhra;
    private final Uri zzhrb;
    private final long zzhtf;
    private final int zzhtg;
    private final long zzhth;
    private final String zzhrl;
    private final String zzhrm;
    private final String zzesj;
    private final zzb zzhti;
    private final PlayerLevelInfo zzhtj;
    private final boolean zzhtk;
    private final boolean zzhtl;
    private final String zzhtm;
    private final String mName;
    private final Uri zzhtn;
    private final String zzhto;
    private final Uri zzhtp;
    private final String zzhtq;
    private final int zzhtr;
    private final long zzhts;
    private final boolean zzhtt;

    @Hide
    public PlayerEntity(Player player) {
        this(player, true);
    }

    @Hide
    private PlayerEntity(Player player, boolean bl) {
        this.zzfld = player.getPlayerId();
        this.zzemi = player.getDisplayName();
        this.zzhra = player.getIconImageUri();
        this.zzhrl = player.getIconImageUrl();
        this.zzhrb = player.getHiResImageUri();
        this.zzhrm = player.getHiResImageUrl();
        this.zzhtf = player.getRetrievedTimestamp();
        this.zzhtg = player.zzasx();
        this.zzhth = player.getLastPlayedWithTimestamp();
        this.zzesj = player.getTitle();
        this.zzhtk = player.zzasy();
        com.google.android.gms.games.internal.player.zza zza2 = player.zzasz();
        this.zzhti = zza2 == null ? null : new zzb(zza2);
        this.zzhtj = player.getLevelInfo();
        this.zzhtl = player.zzasw();
        this.zzhtm = player.zzasv();
        this.mName = player.getName();
        this.zzhtn = player.getBannerImageLandscapeUri();
        this.zzhto = player.getBannerImageLandscapeUrl();
        this.zzhtp = player.getBannerImagePortraitUri();
        this.zzhtq = player.getBannerImagePortraitUrl();
        this.zzhtr = player.zzata();
        this.zzhts = player.zzatb();
        this.zzhtt = player.isMuted();
        zzc.zzv((Object)this.zzfld);
        zzc.zzv((Object)this.zzemi);
        zzc.checkState((this.zzhtf > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(String string, String string2, Uri uri, Uri uri2, long l, int n, long l2, String string3, String string4, String string5, zzb zzb2, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n2, long l3, boolean bl3) {
        this.zzfld = string;
        this.zzemi = string2;
        this.zzhra = uri;
        this.zzhrl = string3;
        this.zzhrb = uri2;
        this.zzhrm = string4;
        this.zzhtf = l;
        this.zzhtg = n;
        this.zzhth = l2;
        this.zzesj = string5;
        this.zzhtk = bl;
        this.zzhti = zzb2;
        this.zzhtj = playerLevelInfo;
        this.zzhtl = bl2;
        this.zzhtm = string6;
        this.mName = string7;
        this.zzhtn = uri3;
        this.zzhto = string8;
        this.zzhtp = uri4;
        this.zzhtq = string9;
        this.zzhtr = n2;
        this.zzhts = l3;
        this.zzhtt = bl3;
    }

    @Override
    public final String getPlayerId() {
        return this.zzfld;
    }

    @Override
    public final String getDisplayName() {
        return this.zzemi;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzemi, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    @Hide
    public final String zzasv() {
        return this.zzhtm;
    }

    @Override
    @Hide
    public final String getName() {
        return this.mName;
    }

    @Override
    @Hide
    public final boolean zzasw() {
        return this.zzhtl;
    }

    @Override
    public final boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhra;
    }

    @Override
    @Hide
    public final String getIconImageUrl() {
        return this.zzhrl;
    }

    @Override
    public final boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzhrb;
    }

    @Override
    @Hide
    public final String getHiResImageUrl() {
        return this.zzhrm;
    }

    @Override
    public final long getRetrievedTimestamp() {
        return this.zzhtf;
    }

    @Override
    public final long getLastPlayedWithTimestamp() {
        return this.zzhth;
    }

    @Override
    @Hide
    public final int zzasx() {
        return this.zzhtg;
    }

    @Override
    @Hide
    public final boolean zzasy() {
        return this.zzhtk;
    }

    @Override
    public final String getTitle() {
        return this.zzesj;
    }

    @Override
    public final void getTitle(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzesj, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final PlayerLevelInfo getLevelInfo() {
        return this.zzhtj;
    }

    @Override
    @Hide
    public final com.google.android.gms.games.internal.player.zza zzasz() {
        return this.zzhti;
    }

    @Override
    public final Uri getBannerImageLandscapeUri() {
        return this.zzhtn;
    }

    @Override
    @Hide
    public final String getBannerImageLandscapeUrl() {
        return this.zzhto;
    }

    @Override
    public final Uri getBannerImagePortraitUri() {
        return this.zzhtp;
    }

    @Override
    @Hide
    public final String getBannerImagePortraitUrl() {
        return this.zzhtq;
    }

    @Override
    @Hide
    public final int zzata() {
        return this.zzhtr;
    }

    @Override
    @Hide
    public final long zzatb() {
        return this.zzhts;
    }

    @Override
    @Hide
    public final boolean isMuted() {
        return this.zzhtt;
    }

    public final Player freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return Arrays.hashCode(new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzasw(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzasv(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzata(), player.zzatb(), player.isMuted()});
    }

    public final boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzbg.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzbg.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzbg.equal((Object)player2.zzasw(), (Object)player.zzasw()) && zzbg.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzbg.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzbg.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzbg.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzbg.equal((Object)((Object)player2.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && zzbg.equal((Object)player2.zzasv(), (Object)player.zzasv()) && zzbg.equal((Object)player2.getName(), (Object)player.getName()) && zzbg.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzbg.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzbg.equal((Object)player2.zzata(), (Object)player.zzata()) && zzbg.equal((Object)player2.zzatb(), (Object)player.zzatb()) && zzbg.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public final String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzbg.zzx((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzasw()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzasv()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzata()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzatb()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlayerEntity playerEntity = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)playerEntity.getPlayerId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)playerEntity.getDisplayName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)playerEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)playerEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (long)playerEntity.getRetrievedTimestamp());
        zzbgo.zzc((Parcel)parcel2, (int)6, (int)playerEntity.zzhtg);
        zzbgo.zza((Parcel)parcel2, (int)7, (long)playerEntity.getLastPlayedWithTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)8, (String)playerEntity.getIconImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (String)playerEntity.getHiResImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)14, (String)playerEntity.getTitle(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)15, (Parcelable)playerEntity.zzhti, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)16, (Parcelable)playerEntity.getLevelInfo(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)18, (boolean)playerEntity.zzhtk);
        zzbgo.zza((Parcel)parcel2, (int)19, (boolean)playerEntity.zzhtl);
        zzbgo.zza((Parcel)parcel2, (int)20, (String)playerEntity.zzhtm, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)21, (String)playerEntity.mName, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)22, (Parcelable)playerEntity.getBannerImageLandscapeUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)23, (String)playerEntity.getBannerImageLandscapeUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)24, (Parcelable)playerEntity.getBannerImagePortraitUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)25, (String)playerEntity.getBannerImagePortraitUrl(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)26, (int)playerEntity.zzhtr);
        zzbgo.zza((Parcel)parcel2, (int)27, (long)playerEntity.zzhts);
        zzbgo.zza((Parcel)parcel2, (int)28, (boolean)playerEntity.zzhtt);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzap {
        zza() {
        }

        @Override
        public final PlayerEntity zzp(Parcel parcel) {
            if (PlayerEntity.zze(PlayerEntity.zzamq()) || PlayerEntity.zzgq((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzp(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzap)this).zzp(parcel);
        }
    }
}

