/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.zza;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;

public final class AchievementEntity
extends zzc
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new zza();
    private final String zzhwd;
    private final int zzenu;
    private final String mName;
    private final String zzdxh;
    private final Uri zzhwe;
    private final String zzhwf;
    private final Uri zzhwg;
    private final String zzhwh;
    private final int zzhwi;
    private final String zzhwj;
    private final PlayerEntity zzhwk;
    private final int mState;
    private final int zzhwl;
    private final String zzhwm;
    private final long zzhwn;
    private final long zzhwo;

    @Hide
    public AchievementEntity(Achievement achievement) {
        this.zzhwd = achievement.getAchievementId();
        this.zzenu = achievement.getType();
        this.mName = achievement.getName();
        this.zzdxh = achievement.getDescription();
        this.zzhwe = achievement.getUnlockedImageUri();
        this.zzhwf = achievement.getUnlockedImageUrl();
        this.zzhwg = achievement.getRevealedImageUri();
        this.zzhwh = achievement.getRevealedImageUrl();
        this.zzhwk = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzhwn = achievement.getLastUpdatedTimestamp();
        this.zzhwo = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzhwi = achievement.getTotalSteps();
            this.zzhwj = achievement.getFormattedTotalSteps();
            this.zzhwl = achievement.getCurrentSteps();
            this.zzhwm = achievement.getFormattedCurrentSteps();
        } else {
            this.zzhwi = 0;
            this.zzhwj = null;
            this.zzhwl = 0;
            this.zzhwm = null;
        }
        com.google.android.gms.common.internal.zzc.zzv((Object)this.zzhwd);
        com.google.android.gms.common.internal.zzc.zzv((Object)this.zzdxh);
    }

    AchievementEntity(String string, int n, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n2, String string6, PlayerEntity playerEntity, int n3, int n4, String string7, long l, long l2) {
        this.zzhwd = string;
        this.zzenu = n;
        this.mName = string2;
        this.zzdxh = string3;
        this.zzhwe = uri;
        this.zzhwf = string4;
        this.zzhwg = uri2;
        this.zzhwh = string5;
        this.zzhwi = n2;
        this.zzhwj = string6;
        this.zzhwk = playerEntity;
        this.mState = n3;
        this.zzhwl = n4;
        this.zzhwm = string7;
        this.zzhwn = l;
        this.zzhwo = l2;
    }

    @Override
    public final String getAchievementId() {
        return this.zzhwd;
    }

    @Override
    public final int getType() {
        return this.zzenu;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdxh;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzdxh, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getUnlockedImageUri() {
        return this.zzhwe;
    }

    @Override
    public final String getUnlockedImageUrl() {
        return this.zzhwf;
    }

    @Override
    public final Uri getRevealedImageUri() {
        return this.zzhwg;
    }

    @Override
    public final String getRevealedImageUrl() {
        return this.zzhwh;
    }

    @Override
    public final int getTotalSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhwi;
    }

    @Override
    public final String getFormattedTotalSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhwj;
    }

    @Override
    public final void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        zzh.zzb((String)this.zzhwj, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Player getPlayer() {
        return this.zzhwk;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getCurrentSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhwl;
    }

    @Override
    public final String getFormattedCurrentSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhwm;
    }

    @Override
    public final void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        zzh.zzb((String)this.zzhwm, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhwn;
    }

    @Override
    public final long getXpValue() {
        return this.zzhwo;
    }

    public final Achievement freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        AchievementEntity achievementEntity = this;
        int n = 0;
        int n2 = 0;
        if (achievementEntity.getType() == 1) {
            n = achievementEntity.getCurrentSteps();
            n2 = achievementEntity.getTotalSteps();
        }
        return Arrays.hashCode(new Object[]{achievementEntity.getAchievementId(), achievementEntity.getName(), achievementEntity.getType(), achievementEntity.getDescription(), achievementEntity.getXpValue(), achievementEntity.getState(), achievementEntity.getLastUpdatedTimestamp(), achievementEntity.getPlayer(), n, n2});
    }

    public final boolean equals(Object object) {
        Object object2 = object;
        AchievementEntity achievementEntity = this;
        if (object2 instanceof Achievement) {
            if (achievementEntity == object2) {
                return true;
            }
            Achievement achievement = (Achievement)object2;
            boolean bl = true;
            boolean bl2 = true;
            if (achievementEntity.getType() == 1) {
                bl = zzbg.equal((Object)achievement.getCurrentSteps(), (Object)achievementEntity.getCurrentSteps());
                bl2 = zzbg.equal((Object)achievement.getTotalSteps(), (Object)achievementEntity.getTotalSteps());
            }
            if (zzbg.equal((Object)achievement.getAchievementId(), (Object)achievementEntity.getAchievementId()) && zzbg.equal((Object)achievement.getName(), (Object)achievementEntity.getName()) && zzbg.equal((Object)achievement.getType(), (Object)achievementEntity.getType()) && zzbg.equal((Object)achievement.getDescription(), (Object)achievementEntity.getDescription()) && zzbg.equal((Object)achievement.getXpValue(), (Object)achievementEntity.getXpValue()) && zzbg.equal((Object)achievement.getState(), (Object)achievementEntity.getState()) && zzbg.equal((Object)achievement.getLastUpdatedTimestamp(), (Object)achievementEntity.getLastUpdatedTimestamp()) && zzbg.equal((Object)achievement.getPlayer(), (Object)achievementEntity.getPlayer()) && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        return AchievementEntity.zza(this);
    }

    static String zza(Achievement achievement) {
        zzbi zzbi2 = zzbg.zzx((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zzbi2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zzbi2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zzbi2.toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AchievementEntity achievementEntity = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)achievementEntity.getAchievementId(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)2, (int)achievementEntity.getType());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)achievementEntity.getName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)achievementEntity.getDescription(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)achievementEntity.getUnlockedImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)achievementEntity.getUnlockedImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)achievementEntity.getRevealedImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (String)achievementEntity.getRevealedImageUrl(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)9, (int)achievementEntity.zzhwi);
        zzbgo.zza((Parcel)parcel2, (int)10, (String)achievementEntity.zzhwj, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)11, (Parcelable)achievementEntity.getPlayer(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)12, (int)achievementEntity.getState());
        zzbgo.zzc((Parcel)parcel2, (int)13, (int)achievementEntity.zzhwl);
        zzbgo.zza((Parcel)parcel2, (int)14, (String)achievementEntity.zzhwm, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)15, (long)achievementEntity.getLastUpdatedTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)16, (long)achievementEntity.getXpValue());
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

